/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.component;

import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.component.ComponentFunctions;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Unbreakable;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface ItemComponentFunctions
extends ComponentFunctions {
    default public void kjs$setMaxStackSize(int size) {
        this.kjs$override(DataComponents.MAX_STACK_SIZE, size);
    }

    default public void kjs$setMaxDamage(int maxDamage) {
        this.kjs$override(DataComponents.MAX_DAMAGE, maxDamage);
    }

    default public void kjs$setDamage(int damage) {
        this.kjs$override(DataComponents.DAMAGE, damage);
    }

    default public void kjs$setUnbreakable() {
        this.kjs$override(DataComponents.UNBREAKABLE, new Unbreakable(false));
    }

    default public void kjs$setUnbreakableWithTooltip() {
        this.kjs$override(DataComponents.UNBREAKABLE, new Unbreakable(true));
    }

    default public void kjs$setItemName(Component component) {
        this.kjs$override(DataComponents.ITEM_NAME, component);
    }

    default public void kjs$setRepairCost(int repairCost) {
        this.kjs$override(DataComponents.REPAIR_COST, repairCost);
    }

    default public void kjs$setFood(FoodProperties foodProperties) {
        this.kjs$override(DataComponents.FOOD, foodProperties);
    }

    default public void kjs$setFood(int nutrition, float saturation) {
        this.kjs$setFood(new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturation).build());
    }

    default public void kjs$setFireResistant() {
        this.kjs$setUnit((DataComponentType<Unit>)DataComponents.FIRE_RESISTANT);
    }

    default public void kjs$setTool(Tool tool) {
        this.kjs$override(DataComponents.TOOL, tool);
    }

    default public void kjs$setMapItemColor(KubeColor color) {
        this.kjs$override(DataComponents.MAP_COLOR, new MapItemColor(color.kjs$getRGB()));
    }

    default public void kjs$setChargedProjectiles(List<ItemStack> items) {
        this.kjs$override(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.of(items));
    }

    default public void kjs$setBundleContents(List<ItemStack> items) {
        this.kjs$override(DataComponents.BUNDLE_CONTENTS, new BundleContents(items));
    }

    default public void kjs$setBucketEntityData(CompoundTag tag) {
        this.kjs$override(DataComponents.BUCKET_ENTITY_DATA, CustomData.of((CompoundTag)tag));
    }

    default public void kjs$setBlockEntityData(CompoundTag tag) {
        this.kjs$override(DataComponents.BLOCK_ENTITY_DATA, CustomData.of((CompoundTag)tag));
    }

    default public void kjs$setInstrument(Holder<Instrument> instrument) {
        this.kjs$override(DataComponents.INSTRUMENT, instrument);
    }

    default public void kjs$setFireworkExplosion(FireworkExplosion explosion) {
        this.kjs$override(DataComponents.FIREWORK_EXPLOSION, explosion);
    }

    default public void kjs$setFireworks(Fireworks fireworks) {
        this.kjs$override(DataComponents.FIREWORKS, fireworks);
    }

    default public void kjs$setNoteBlockSound(ResourceLocation id) {
        this.kjs$override(DataComponents.NOTE_BLOCK_SOUND, id);
    }

    default public ItemAttributeModifiers kjs$getAttributeModifiers() {
        ItemAttributeModifiers mods = (ItemAttributeModifiers)this.kjs$get(DataComponents.ATTRIBUTE_MODIFIERS);
        return mods == null ? new ItemAttributeModifiers(List.of(), true) : mods;
    }

    default public boolean kjs$hasAttributeModifier(Holder<Attribute> attribute, ResourceLocation id) {
        for (ItemAttributeModifiers.Entry entry : this.kjs$getAttributeModifiers().modifiers()) {
            if (!entry.matches(attribute, id)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public AttributeModifier kjs$getAttributeModifier(Holder<Attribute> attribute, ResourceLocation id) {
        for (ItemAttributeModifiers.Entry entry : this.kjs$getAttributeModifiers().modifiers()) {
            if (!entry.matches(attribute, id)) continue;
            return entry.modifier();
        }
        return null;
    }

    default public void kjs$setAttributeModifiers(List<ItemAttributeModifiers.Entry> modifiers) {
        this.kjs$override(DataComponents.ATTRIBUTE_MODIFIERS, new ItemAttributeModifiers(modifiers, false));
    }

    default public void kjs$setAttributeModifiersWithTooltip(List<ItemAttributeModifiers.Entry> modifiers) {
        this.kjs$override(DataComponents.ATTRIBUTE_MODIFIERS, new ItemAttributeModifiers(modifiers, true));
    }

    default public void kjs$setAttackSpeed(double speed) {
        ItemAttributeModifiers oldMods = this.kjs$getAttributeModifiers();
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>(oldMods.modifiers().size());
        for (ItemAttributeModifiers.Entry entry : oldMods.modifiers()) {
            if (entry.attribute().equals((Object)Attributes.ATTACK_SPEED)) continue;
            list.add(entry);
        }
        list.add(new ItemAttributeModifiers.Entry(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
        this.kjs$override(DataComponents.ATTRIBUTE_MODIFIERS, new ItemAttributeModifiers(list, oldMods.showInTooltip()));
    }

    default public void kjs$setAttackDamage(double dmg) {
        ItemAttributeModifiers oldMods = this.kjs$getAttributeModifiers();
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>(oldMods.modifiers().size());
        for (ItemAttributeModifiers.Entry entry : oldMods.modifiers()) {
            if (entry.attribute().equals((Object)Attributes.ATTACK_DAMAGE)) continue;
            list.add(entry);
        }
        list.add(new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
        this.kjs$override(DataComponents.ATTRIBUTE_MODIFIERS, new ItemAttributeModifiers(list, oldMods.showInTooltip()));
    }

    default public double kjs$getAttackDamage() {
        double base = this.kjs$getBaseAttackDamage();
        double sum = 0.0;
        for (ItemAttributeModifiers.Entry entry : this.kjs$getAttributeModifiers().modifiers()) {
            if (entry.matches(Attributes.ATTACK_DAMAGE, Item.BASE_ATTACK_DAMAGE_ID)) continue;
            AttributeModifier mod = entry.modifier();
            double d1 = mod.amount();
            sum += (switch (mod.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> d1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * base;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * sum;
            });
        }
        return sum;
    }

    default public double kjs$getAttackSpeed() {
        double base = this.kjs$getBaseAttackSpeed();
        double sum = 0.0;
        for (ItemAttributeModifiers.Entry entry : this.kjs$getAttributeModifiers().modifiers()) {
            if (entry.matches(Attributes.ATTACK_SPEED, Item.BASE_ATTACK_SPEED_ID)) continue;
            AttributeModifier mod = entry.modifier();
            double d1 = mod.amount();
            sum += (switch (mod.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> d1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * base;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * sum;
            });
        }
        return sum;
    }

    default public void kjs$setBaseAttackSpeed(double speed) {
        this.kjs$override(DataComponents.ATTRIBUTE_MODIFIERS, this.kjs$getAttributeModifiers().withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    default public void kjs$setBaseAttackDamage(double dmg) {
        this.kjs$override(DataComponents.ATTRIBUTE_MODIFIERS, this.kjs$getAttributeModifiers().withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    default public double kjs$getBaseAttackDamage() {
        for (ItemAttributeModifiers.Entry modifier : this.kjs$getAttributeModifiers().modifiers()) {
            if (!modifier.matches(Attributes.ATTACK_DAMAGE, Item.BASE_ATTACK_DAMAGE_ID)) continue;
            return modifier.modifier().amount();
        }
        return 0.0;
    }

    default public double kjs$getBaseAttackSpeed() {
        for (ItemAttributeModifiers.Entry modifier : this.kjs$getAttributeModifiers().modifiers()) {
            if (!modifier.matches(Attributes.ATTACK_SPEED, Item.BASE_ATTACK_SPEED_ID)) continue;
            return modifier.modifier().amount();
        }
        return 0.0;
    }
}

