/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.fluid.NamespaceFluidIngredient;
import dev.latvian.mods.kubejs.fluid.RegExFluidIngredient;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.DataComponentFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public interface FluidWrapper {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(FluidStack.class);
    public static final TypeInfo FLUID_TYPE_INFO = TypeInfo.of(Fluid.class);
    public static final TypeInfo INGREDIENT_TYPE_INFO = TypeInfo.of(FluidIngredient.class);
    public static final TypeInfo SIZED_INGREDIENT_TYPE_INFO = TypeInfo.of(SizedFluidIngredient.class);
    public static final SizedFluidIngredient EMPTY_SIZED = new SizedFluidIngredient(FluidIngredient.empty(), 1000);
    public static final DataResult<FluidStack> EMPTY_STACK_RESULT = DataResult.success((Object)FluidStack.EMPTY);
    public static final DataResult<FluidIngredient> EMPTY_INGREDIENT_RESULT = DataResult.success((Object)FluidIngredient.empty());
    public static final DataResult<SizedFluidIngredient> EMPTY_SIZED_RESULT = DataResult.success((Object)EMPTY_SIZED);

    @HideFromJS
    public static DataResult<FluidStack> tryWrap(Context cx, Object from) {
        DataResult dataResult;
        while (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        Object object = from;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FluidStack.class, Fluid.class, Fluid.class, FluidIngredient.class, SizedFluidIngredient.class}, (Object)object, n)) {
                case -1: {
                    dataResult = EMPTY_STACK_RESULT;
                    break block9;
                }
                case 0: {
                    FluidStack s = (FluidStack)object;
                    if (s.isEmpty()) {
                        dataResult = EMPTY_STACK_RESULT;
                        break block9;
                    }
                    dataResult = DataResult.success((Object)s);
                    break block9;
                }
                case 1: {
                    Fluid fluid = (Fluid)object;
                    if (!fluid.kjs$isEmpty()) {
                        n = 2;
                        continue block9;
                    }
                    dataResult = EMPTY_STACK_RESULT;
                    break block9;
                }
                case 2: {
                    Fluid fluid = (Fluid)object;
                    dataResult = DataResult.success((Object)new FluidStack(fluid, 1000));
                    break block9;
                }
                case 3: {
                    FluidIngredient i = (FluidIngredient)object;
                    throw new KubeRuntimeException("Using FluidIngredient in places where FluidStack is expected is dangerous and unsupported!").source(SourceLine.of(cx));
                }
                case 4: {
                    SizedFluidIngredient sized = (SizedFluidIngredient)object;
                    throw new KubeRuntimeException("Using SizedFluidIngredient in places where FluidStack is expected is dangerous and unsupported!").source(SourceLine.of(cx));
                }
                default: {
                    dataResult = FluidWrapper.parseString(cx, RegistryAccessContainer.of(cx).nbt(), from.toString());
                    break block9;
                }
            }
            break;
        }
        return dataResult;
    }

    @HideFromJS
    public static FluidStack wrap(Context cx, Object from) {
        return (FluidStack)FluidWrapper.tryWrap(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read FluidStack from %s: %s".formatted(from, error)).source(SourceLine.of(cx)));
    }

    public static FluidIngredient ingredientOf(FluidIngredient of) {
        return of;
    }

    @Info(value="Returns an ingredient that accepts the given set of fluids under the given component filter.")
    public static FluidIngredient ingredientOf(HolderSet<Fluid> base, DataComponentMap data) {
        return FluidWrapper.ingredientOf(base, data, false);
    }

    @Info(value="Returns an ingredient that accepts the given set of items under the given (optionally strict) component filter.")
    public static FluidIngredient ingredientOf(HolderSet<Fluid> base, DataComponentMap data, boolean strict) {
        return DataComponentFluidIngredient.of((boolean)strict, (DataComponentMap)data, base);
    }

    @HideFromJS
    public static DataResult<FluidIngredient> tryWrapIngredient(Context cx, Object from) {
        DataResult dataResult;
        while (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
        Object object = from;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FluidStack.class, Fluid.class, FluidIngredient.class, FluidStack.class, Fluid.class, FluidIngredient.class, SizedFluidIngredient.class}, (Object)object, n)) {
                case -1: {
                    dataResult = EMPTY_INGREDIENT_RESULT;
                    break block11;
                }
                case 0: {
                    FluidStack stack = (FluidStack)object;
                    if (!stack.isEmpty()) {
                        n = 1;
                        continue block11;
                    }
                    dataResult = EMPTY_INGREDIENT_RESULT;
                    break block11;
                }
                case 1: {
                    Fluid fluid = (Fluid)object;
                    if (!fluid.kjs$isEmpty()) {
                        n = 2;
                        continue block11;
                    }
                    dataResult = EMPTY_INGREDIENT_RESULT;
                    break block11;
                }
                case 2: {
                    FluidIngredient in = (FluidIngredient)object;
                    if (!in.isEmpty()) {
                        n = 3;
                        continue block11;
                    }
                    dataResult = EMPTY_INGREDIENT_RESULT;
                    break block11;
                }
                case 3: {
                    FluidStack stack = (FluidStack)object;
                    dataResult = DataResult.success((Object)FluidIngredient.of((FluidStack[])new FluidStack[]{stack}));
                    break block11;
                }
                case 4: {
                    Fluid fluid = (Fluid)object;
                    dataResult = DataResult.success((Object)FluidIngredient.of((Fluid[])new Fluid[]{fluid}));
                    break block11;
                }
                case 5: {
                    FluidIngredient in = (FluidIngredient)object;
                    dataResult = DataResult.success((Object)in);
                    break block11;
                }
                case 6: {
                    SizedFluidIngredient s = (SizedFluidIngredient)object;
                    dataResult = DataResult.success((Object)s.ingredient());
                    break block11;
                }
                default: {
                    dataResult = FluidWrapper.ingredientOfString(cx, registries.nbt(), from.toString());
                    break block11;
                }
            }
            break;
        }
        return dataResult;
    }

    @HideFromJS
    public static FluidIngredient wrapIngredient(Context cx, Object from) {
        return (FluidIngredient)FluidWrapper.tryWrapIngredient(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read FluidIngredient from %s: %s".formatted(from, error)).source(SourceLine.of(cx)));
    }

    public static SizedFluidIngredient sizedIngredientOf(SizedFluidIngredient of) {
        return of;
    }

    public static SizedFluidIngredient sizedIngredientOf(FluidIngredient in, int amount) {
        return new SizedFluidIngredient(in, amount);
    }

    @HideFromJS
    public static DataResult<SizedFluidIngredient> tryWrapSizedIngredient(Context cx, Object o) {
        DataResult dataResult;
        RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
        Object object = o;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FluidStack.class, Fluid.class, FluidIngredient.class, FluidStack.class, Fluid.class, FluidIngredient.class, SizedFluidIngredient.class}, (Object)object, n)) {
                case -1: {
                    dataResult = EMPTY_SIZED_RESULT;
                    break block10;
                }
                case 0: {
                    FluidStack stack = (FluidStack)object;
                    if (!stack.isEmpty()) {
                        n = 1;
                        continue block10;
                    }
                    dataResult = EMPTY_SIZED_RESULT;
                    break block10;
                }
                case 1: {
                    Fluid fluid = (Fluid)object;
                    if (!fluid.kjs$isEmpty()) {
                        n = 2;
                        continue block10;
                    }
                    dataResult = EMPTY_SIZED_RESULT;
                    break block10;
                }
                case 2: {
                    FluidIngredient in = (FluidIngredient)object;
                    if (!in.isEmpty()) {
                        n = 3;
                        continue block10;
                    }
                    dataResult = EMPTY_SIZED_RESULT;
                    break block10;
                }
                case 3: {
                    FluidStack stack = (FluidStack)object;
                    dataResult = DataResult.success((Object)SizedFluidIngredient.of((FluidStack)stack));
                    break block10;
                }
                case 4: {
                    Fluid fluid = (Fluid)object;
                    dataResult = DataResult.success((Object)SizedFluidIngredient.of((Fluid)fluid, (int)1000));
                    break block10;
                }
                case 5: {
                    FluidIngredient in = (FluidIngredient)object;
                    dataResult = DataResult.success((Object)new SizedFluidIngredient(in, 1000));
                    break block10;
                }
                case 6: {
                    SizedFluidIngredient s = (SizedFluidIngredient)object;
                    dataResult = DataResult.success((Object)s);
                    break block10;
                }
                default: {
                    dataResult = FluidWrapper.sizedIngredientOfString(cx, registries.nbt(), o.toString());
                    break block10;
                }
            }
            break;
        }
        return dataResult;
    }

    @HideFromJS
    public static SizedFluidIngredient wrapSizedIngredient(Context cx, Object from) {
        return (SizedFluidIngredient)FluidWrapper.tryWrapSizedIngredient(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read SizedFluidIngredient from %s: %s".formatted(from, error)).source(SourceLine.of(cx)));
    }

    public static FluidStack of(FluidStack o) {
        return o;
    }

    public static FluidStack of(FluidStack o, int amount) {
        o.setAmount(amount);
        return o;
    }

    public static FluidStack of(FluidStack o, DataComponentMap components) {
        o.applyComponents(components);
        return o;
    }

    public static FluidStack of(FluidStack o, int amount, DataComponentMap components) {
        o.setAmount(amount);
        o.applyComponents(components);
        return o;
    }

    public static FluidStack water() {
        return FluidWrapper.water(1000);
    }

    public static FluidStack lava() {
        return FluidWrapper.lava(1000);
    }

    public static FluidStack water(int amount) {
        return new FluidStack((Fluid)Fluids.WATER, amount);
    }

    public static FluidStack lava(int amount) {
        return new FluidStack((Fluid)Fluids.LAVA, amount);
    }

    public static Fluid getType(ResourceLocation id) {
        return (Fluid)BuiltInRegistries.FLUID.get(id);
    }

    public static List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            types.add(fluid.kjs$getId());
        }
        return types;
    }

    public static FluidStack getEmpty() {
        return FluidStack.EMPTY;
    }

    public static boolean exists(ResourceLocation id) {
        return BuiltInRegistries.FLUID.containsKey(id);
    }

    public static ResourceLocation getId(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public static <T> DataResult<T> readWithContext(Context cx, DynamicOps<Tag> registryOps, String s, ReadFn<T> fn, String name) {
        try {
            StringReader reader = new StringReader(s);
            reader.skipWhitespace();
            return fn.read(registryOps, reader);
        }
        catch (CommandSyntaxException ex) {
            return DataResult.error(() -> "Error parsing %s from string: %s".formatted(new Object[]{name, ex}));
        }
    }

    public static DataResult<FluidStack> parseString(Context cx, DynamicOps<Tag> registryOps, String s) {
        return switch (s) {
            case "", "-", "empty", "minecraft:empty" -> DataResult.success((Object)FluidStack.EMPTY);
            default -> FluidWrapper.readWithContext(cx, registryOps, s, FluidWrapper::read, "FluidStack");
        };
    }

    public static DataResult<FluidStack> read(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        char next;
        if (!reader.canRead() || reader.peek() == '-') {
            return DataResult.success((Object)FluidStack.EMPTY);
        }
        DataResult<Integer> amount = FluidWrapper.readFluidAmount(reader);
        DataResult fluid = ID.read(reader).flatMap(FluidWrapper::findFluid);
        DataResult fluidStack = fluid.apply2(FluidStack::new, amount);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if (next == '[' || next == '{') {
            return fluidStack.flatMap(stack -> {
                try {
                    DataComponentPatch components = DataComponentWrapper.readPatch(registryOps, reader);
                    stack.applyComponents(components);
                    return DataResult.success((Object)stack);
                }
                catch (CommandSyntaxException e) {
                    return DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
                }
            });
        }
        return fluidStack;
    }

    public static DataResult<FluidIngredient> ingredientOfString(Context cx, DynamicOps<Tag> registryOps, String s) {
        return switch (s) {
            case "", "-", "empty", "minecraft:empty" -> EMPTY_INGREDIENT_RESULT;
            default -> FluidWrapper.readWithContext(cx, registryOps, s, FluidWrapper::readIngredient, "FluidIngredient");
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HideFromJS
    public static DataResult<FluidIngredient> readIngredient(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        DataResult dataResult;
        char next;
        DataResult dataResult2;
        if (!reader.canRead()) return EMPTY_INGREDIENT_RESULT;
        if (reader.peek() == '-') {
            return EMPTY_INGREDIENT_RESULT;
        }
        switch (reader.peek()) {
            case '#': {
                DataResult dataResult3;
                reader.skip();
                dataResult2 = dataResult3 = ID.read(reader).map(FluidTags::create).map(FluidIngredient::tag);
                return dataResult2;
            }
            case '@': {
                DataResult dataResult4;
                reader.skip();
                String id = reader.readUnquotedString();
                dataResult2 = dataResult4 = DataResult.success((Object)((Object)new NamespaceFluidIngredient(id)));
                return dataResult2;
            }
            case '/': {
                DataResult dataResult5;
                dataResult2 = dataResult5 = RegExpKJS.tryRead(reader).map(RegExFluidIngredient::new);
                return dataResult2;
            }
        }
        DataResult fluid = ID.read(reader).flatMap(FluidWrapper::findFluid);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if (next == '[' || next == '{') {
            try {
                DataComponentPredicate components = DataComponentWrapper.readPredicate(registryOps, reader);
                if (components != DataComponentPredicate.EMPTY) {
                    DataResult dataResult6;
                    dataResult2 = dataResult6 = fluid.map(holder -> DataComponentFluidIngredient.of((boolean)false, (DataComponentPredicate)components, (Holder[])new Holder[]{holder}));
                    return dataResult2;
                }
            }
            catch (CommandSyntaxException e) {
                DataResult dataResult7;
                dataResult2 = dataResult7 = DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
                return dataResult2;
            }
        }
        dataResult2 = dataResult = fluid.map(FluidIngredient::single);
        return dataResult2;
    }

    public static DataResult<SizedFluidIngredient> sizedIngredientOfString(Context cx, DynamicOps<Tag> registryOps, String s) {
        return switch (s) {
            case "", "-", "empty", "minecraft:empty" -> EMPTY_SIZED_RESULT;
            default -> FluidWrapper.readWithContext(cx, registryOps, s, FluidWrapper::readSizedIngredient, "SizedFluidIngredient");
        };
    }

    public static DataResult<SizedFluidIngredient> readSizedIngredient(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return EMPTY_SIZED_RESULT;
        }
        DataResult<Integer> amount = FluidWrapper.readFluidAmount(reader);
        DataResult<FluidIngredient> ingredient = FluidWrapper.readIngredient(registryOps, reader);
        return ingredient.apply2(SizedFluidIngredient::new, amount);
    }

    @HideFromJS
    public static DataResult<Holder<Fluid>> findFluid(ResourceLocation id) {
        return BuiltInRegistries.FLUID.getHolder(id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Fluid with ID " + String.valueOf(id) + " does not exist!")).map(Function.identity());
    }

    @HideFromJS
    public static DataResult<Integer> readFluidAmount(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            double amountd = reader.readDouble();
            reader.skipWhitespace();
            if (reader.peek() == 'b' || reader.peek() == 'B') {
                reader.skip();
                reader.skipWhitespace();
                amountd *= 1000.0;
            }
            if (reader.peek() == '/') {
                reader.skip();
                reader.skipWhitespace();
                amountd /= reader.readDouble();
            }
            int amount = (int)amountd;
            reader.expect('x');
            reader.skipWhitespace();
            if (amount < 1) {
                return DataResult.error(() -> "Fluid amount smaller than 1 is not allowed!");
            }
            return DataResult.success((Object)amount);
        }
        return DataResult.success((Object)1000);
    }

    public static interface ReadFn<T> {
        public DataResult<T> read(DynamicOps<Tag> var1, StringReader var2) throws CommandSyntaxException;
    }
}

