/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ColorWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.TextIcons;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

@Info(value="The hub for all things text components. Format text to your hearts content!")
public interface TextWrapper {
    @Info(value="Returns a Component of the input")
    public static MutableComponent of(MutableComponent component) {
        return component;
    }

    @HideFromJS
    public static MutableComponent wrap(Context cx, @Nullable Object o) {
        MutableComponent mutableComponent;
        Object from;
        Object object = from = UtilsJS.wrap(o, JSObjectType.ANY);
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MutableComponent.class, Component.class, Enum.class, StringTag.class, Tag.class, Map.class, Iterable.class}, (Object)object, n)) {
                case -1: {
                    mutableComponent = Component.literal((String)"null");
                    break block10;
                }
                case 0: {
                    MutableComponent component;
                    mutableComponent = component = (MutableComponent)object;
                    break block10;
                }
                case 1: {
                    Component component = (Component)object;
                    mutableComponent = component.copy();
                    break block10;
                }
                case 2: {
                    Enum e = (Enum)object;
                    mutableComponent = TextWrapper.ofString(e.name());
                    break block10;
                }
                case 3: {
                    StringTag tag = (StringTag)object;
                    String s = tag.getAsString();
                    if (s.startsWith("{") && s.endsWith("}")) {
                        mutableComponent = ((Component)ComponentSerialization.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)JsonUtils.GSON.fromJson(s, JsonObject.class))).mapOrElse(Pair::getFirst, error -> Component.literal((String)("Error: " + String.valueOf(error))))).copy();
                        break block10;
                    }
                    mutableComponent = TextWrapper.ofString(s);
                    break block10;
                }
                case 4: {
                    Tag tag = (Tag)object;
                    mutableComponent = (MutableComponent)NbtUtils.toPrettyComponent((Tag)tag);
                    break block10;
                }
                case 5: {
                    MutableComponent text;
                    Map map = (Map)object;
                    if (!map.containsKey("text") && !map.containsKey("translate")) {
                        n = 6;
                        continue block10;
                    }
                    if (map.containsKey("text")) {
                        text = TextWrapper.ofString(map.get("text").toString());
                    } else {
                        Object[] with;
                        Object v = map.get("with");
                        if (v instanceof Collection) {
                            Collection a = (Collection)v;
                            with = new Object[a.size()];
                            int i = 0;
                            for (Object e1 : a) {
                                with[i] = e1;
                                if (with[i] instanceof Map || with[i] instanceof Collection) {
                                    with[i] = TextWrapper.wrap(cx, e1);
                                }
                                ++i;
                            }
                        } else {
                            with = new Object[]{};
                        }
                        text = Component.translatable((String)map.get("translate").toString(), (Object[])with);
                    }
                    if (map.containsKey("color")) {
                        text.kjs$color(ColorWrapper.wrap(map.get("color")));
                    }
                    text.kjs$bold((Boolean)map.getOrDefault("bold", null));
                    text.kjs$italic((Boolean)map.getOrDefault("italic", null));
                    text.kjs$underlined((Boolean)map.getOrDefault("underlined", null));
                    text.kjs$strikethrough((Boolean)map.getOrDefault("strikethrough", null));
                    text.kjs$obfuscated((Boolean)map.getOrDefault("obfuscated", null));
                    text.kjs$insertion((String)map.getOrDefault("insertion", null));
                    text.kjs$font(map.containsKey("font") ? ResourceLocation.parse((String)map.get("font").toString()) : null);
                    text.kjs$click(map.containsKey("click") ? TextWrapper.wrapClickEvent(cx, map.get("click")) : null);
                    text.kjs$hover(map.containsKey("hover") ? TextWrapper.wrap(cx, map.get("hover")) : null);
                    Object v = map.get("extra");
                    if (v instanceof Iterable) {
                        Iterable itr = (Iterable)v;
                        for (Object e : itr) {
                            text.append((Component)TextWrapper.wrap(cx, e));
                        }
                    }
                    mutableComponent = text;
                    break block10;
                }
                case 6: {
                    Iterable list = (Iterable)object;
                    MutableComponent text = Component.empty();
                    for (Object e1 : list) {
                        text.append((Component)TextWrapper.wrap(cx, e1));
                    }
                    mutableComponent = text;
                    break block10;
                }
                default: {
                    mutableComponent = TextWrapper.ofString(from.toString());
                    break block10;
                }
            }
            break;
        }
        return mutableComponent;
    }

    public static Component ofTag(Tag tag) {
        try {
            return (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow()).getFirst();
        }
        catch (JsonParseException ex) {
            return Component.literal((String)("Error: " + String.valueOf((Object)ex)));
        }
    }

    @Info(value="Returns a plain component of the string, or empty if it is an empty string")
    public static MutableComponent ofString(String s) {
        return s.isEmpty() ? Component.empty() : Component.literal((String)s);
    }

    @Info(value="Checks if the passed in component, and all its children are empty")
    public static boolean isEmpty(Component component) {
        return component.getContents() == PlainTextContents.EMPTY && component.getSiblings().isEmpty();
    }

    @Info(value="Returns a ClickEvent of the input")
    public static ClickEvent clickEventOf(ClickEvent event) {
        return event;
    }

    @HideFromJS
    public static ClickEvent wrapClickEvent(Context cx, Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClickEvent) {
            ClickEvent ce = (ClickEvent)o;
            return ce;
        }
        JsonObject json = JsonUtils.objectOf(cx, o);
        if (json != null) {
            String action = GsonHelper.getAsString((JsonObject)json, (String)"action");
            String value = GsonHelper.getAsString((JsonObject)json, (String)"value");
            return (ClickEvent)KubeJSCodecs.fromJsonOrThrow((JsonElement)json, ClickEvent.CODEC);
        }
        String s = o.toString();
        String[] split = s.split(":", 2);
        return switch (split[0]) {
            case "command" -> new ClickEvent(ClickEvent.Action.RUN_COMMAND, split[1]);
            case "suggest_command" -> new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, split[1]);
            case "copy" -> new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, split[1]);
            case "file" -> new ClickEvent(ClickEvent.Action.OPEN_FILE, split[1]);
            default -> {
                for (ClickEvent.Action a : ClickEvent.Action.values()) {
                    if (!a.getSerializedName().equals(split[0])) continue;
                    yield new ClickEvent(a, split[1]);
                }
                yield new ClickEvent(ClickEvent.Action.OPEN_URL, s);
            }
        };
    }

    @Info(value="Returns a colorful representation of the input nbt. Useful for displaying NBT to the player")
    public static Component prettyPrintNbt(Tag tag) {
        return NbtUtils.toPrettyComponent((Tag)tag);
    }

    @Info(value="Joins all components in the list with the separator component")
    public static MutableComponent join(MutableComponent separator, Iterable<? extends Component> texts) {
        MutableComponent joined = Component.empty();
        boolean first = true;
        for (Component component : texts) {
            if (first) {
                first = false;
            } else if (!TextWrapper.isEmpty((Component)separator)) {
                joined.append((Component)separator);
            }
            joined.append(component);
        }
        return joined;
    }

    @Info(value="Returns an empty component")
    public static MutableComponent empty() {
        return Component.empty();
    }

    @Info(value="Joins all components")
    public static MutableComponent join(Component ... texts) {
        return TextWrapper.join(Component.empty(), Arrays.asList(texts));
    }

    @Info(value="Returns a plain component of the passed in string, even if empty")
    public static MutableComponent string(String text) {
        return Component.literal((String)text);
    }

    @Info(value="Returns a plain component of the input")
    public static MutableComponent literal(String text) {
        return Component.literal((String)text);
    }

    @Info(value="Returns a translatable component of the input key")
    public static MutableComponent translate(String key) {
        return Component.translatable((String)key);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects")
    public static MutableComponent translate(String key, Object ... objects) {
        return Component.translatable((String)key, (Object[])objects);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects and a fallback translation in case the client does not have one")
    public static MutableComponent translateWithFallback(String key, String fallback) {
        return Component.translatableWithFallback((String)key, (String)fallback);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects and a fallback translation in case the client does not have one")
    public static MutableComponent translateWithFallback(String key, String fallback, Object ... objects) {
        return Component.translatableWithFallback((String)key, (String)fallback, (Object[])objects);
    }

    @Info(value="Returns a translatable component of the input key")
    public static MutableComponent translatable(String key) {
        return Component.translatable((String)key);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects")
    public static MutableComponent translatable(String key, Object ... objects) {
        return Component.translatable((String)key, (Object[])objects);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects and a fallback translation in case the client does not have one")
    public static MutableComponent translatableWithFallback(String key, String fallback) {
        return Component.translatableWithFallback((String)key, (String)fallback);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects and a fallback translation in case the client does not have one")
    public static MutableComponent translatableWithFallback(String key, String fallback, Object ... objects) {
        return Component.translatableWithFallback((String)key, (String)fallback, (Object[])objects);
    }

    @Info(value="Returns a keybinding component of the input keybinding descriptor")
    public static MutableComponent keybind(String keybind) {
        return Component.keybind((String)keybind);
    }

    @Info(value="Returns a score component of the input objective, for the provided selector")
    public static MutableComponent score(String selector, String objective) {
        return MutableComponent.create((ComponentContents)new ScoreContents(selector, objective));
    }

    @Info(value="Returns a component displaying all entities matching the input selector")
    public static MutableComponent selector(String selector) {
        return MutableComponent.create((ComponentContents)new SelectorContents(selector, Optional.empty()));
    }

    @Info(value="Returns a component displaying all entities matching the input selector, with a custom separator")
    public static MutableComponent selector(String selector, Component separator) {
        return MutableComponent.create((ComponentContents)new SelectorContents(selector, Optional.of(separator)));
    }

    @Info(value="Returns a component of the input, colored black")
    public static MutableComponent black(MutableComponent text) {
        return text.kjs$black();
    }

    @Info(value="Returns a component of the input, colored dark blue")
    public static MutableComponent darkBlue(MutableComponent text) {
        return text.kjs$darkBlue();
    }

    @Info(value="Returns a component of the input, colored dark green")
    public static MutableComponent darkGreen(MutableComponent text) {
        return text.kjs$darkGreen();
    }

    @Info(value="Returns a component of the input, colored dark aqua")
    public static MutableComponent darkAqua(MutableComponent text) {
        return text.kjs$darkAqua();
    }

    @Info(value="Returns a component of the input, colored dark red")
    public static MutableComponent darkRed(MutableComponent text) {
        return text.kjs$darkRed();
    }

    @Info(value="Returns a component of the input, colored dark purple")
    public static MutableComponent darkPurple(MutableComponent text) {
        return text.kjs$darkPurple();
    }

    @Info(value="Returns a component of the input, colored gold")
    public static MutableComponent gold(MutableComponent text) {
        return text.kjs$gold();
    }

    @Info(value="Returns a component of the input, colored gray")
    public static MutableComponent gray(MutableComponent text) {
        return text.kjs$gray();
    }

    @Info(value="Returns a component of the input, colored dark gray")
    public static MutableComponent darkGray(MutableComponent text) {
        return text.kjs$darkGray();
    }

    @Info(value="Returns a component of the input, colored blue")
    public static MutableComponent blue(MutableComponent text) {
        return text.kjs$blue();
    }

    @Info(value="Returns a component of the input, colored green")
    public static MutableComponent green(MutableComponent text) {
        return text.kjs$green();
    }

    @Info(value="Returns a component of the input, colored aqua")
    public static MutableComponent aqua(MutableComponent text) {
        return text.kjs$aqua();
    }

    @Info(value="Returns a component of the input, colored red")
    public static MutableComponent red(MutableComponent text) {
        return text.kjs$red();
    }

    @Info(value="Returns a component of the input, colored light purple")
    public static MutableComponent lightPurple(MutableComponent text) {
        return text.kjs$lightPurple();
    }

    @Info(value="Returns a component of the input, colored yellow")
    public static MutableComponent yellow(MutableComponent text) {
        return text.kjs$yellow();
    }

    @Info(value="Returns a component of the input, colored white")
    public static MutableComponent white(MutableComponent text) {
        return text.kjs$white();
    }

    public static MutableComponent info(Component text) {
        return Component.empty().append((Component)TextIcons.info()).append((Component)TextIcons.smallSpace()).append(text);
    }

    public static MutableComponent warn(Component text) {
        return Component.empty().append((Component)TextIcons.info()).append((Component)TextIcons.smallSpace()).append(text);
    }
}

