/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.BlockWrapper;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.OpsContainer;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record BlockStateComponent(RecipeComponentType<?> type, boolean preferObjectForm, boolean allowEmpty) implements RecipeComponent<BlockState>
{
    public static final TypeInfo TYPE_INFO = TypeInfo.of(BlockState.class);
    public static final RecipeComponentType<BlockState> BLOCK = RecipeComponentType.unit(KubeJS.id("block_state"), type -> new BlockStateComponent((RecipeComponentType<?>)type, true, false));
    public static final RecipeComponentType<BlockState> BLOCK_STRING = RecipeComponentType.unit(KubeJS.id("block_state_string"), type -> new BlockStateComponent((RecipeComponentType<?>)type, false, false));
    public static final RecipeComponentType<BlockState> OPTIONAL_BLOCK = RecipeComponentType.unit(KubeJS.id("optional_block_state"), type -> new BlockStateComponent((RecipeComponentType<?>)type, true, true));
    public static final RecipeComponentType<BlockState> OPTIONAL_BLOCK_STRING = RecipeComponentType.unit(KubeJS.id("optional_block_state_string"), type -> new BlockStateComponent((RecipeComponentType<?>)type, false, true));

    @Override
    public Codec<BlockState> codec() {
        return BlockState.CODEC;
    }

    @Override
    public TypeInfo typeInfo() {
        return TYPE_INFO;
    }

    @Override
    public BlockState wrap(RecipeScriptContext cx, Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockState.class, Block.class, JsonPrimitive.class}, (Object)object, n)) {
            case 0 -> {
                BlockState s;
                yield s = (BlockState)object;
            }
            case 1 -> {
                Block b = (Block)object;
                yield b.defaultBlockState();
            }
            case 2 -> {
                JsonPrimitive json = (JsonPrimitive)object;
                yield BlockWrapper.parseBlockState(cx.registries(), json.getAsString());
            }
            default -> {
                Map map = cx.cx().optionalMapOf(from);
                if (map == null) {
                    yield BlockWrapper.parseBlockState(cx.registries(), String.valueOf(from));
                }
                yield (BlockState)BlockState.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonUtils.GSON.toJsonTree(from)).getPartialOrThrow(message -> {
                    throw new KubeRuntimeException("Failed to parse blockstate: " + message);
                });
            }
        };
    }

    @Override
    public boolean matches(RecipeMatchContext cx, BlockState value, ReplacementMatchInfo match) {
        BlockStatePredicate m2;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof BlockStatePredicate && (m2 = (BlockStatePredicate)replacementMatch).test(value);
    }

    @Override
    public boolean isEmpty(BlockState value) {
        return value.getBlock() == Blocks.AIR;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, BlockState value) {
        builder.append(value.kjs$getIdLocation());
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public String toString(OpsContainer ops, BlockState value) {
        return value.kjs$toString();
    }
}

