/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.event;

import dev.latvian.mods.kubejs.event.EventExceptionHandler;
import dev.latvian.mods.kubejs.event.EventExit;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandlerContainer;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.EventTargetType;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.event.TargetedEventHandler;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.script.ScriptTypePredicate;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class EventHandler
extends BaseFunction {
    private static final TypeInfo EVENT_HANDLER_TYPE_INFO = TypeInfo.of(IEventHandler.class);
    public final EventGroup group;
    public final String name;
    public final ScriptTypePredicate scriptTypePredicate;
    public final Supplier<Class<? extends KubeEvent>> eventType;
    protected TypeInfo result;
    public transient EventTargetType<?> target;
    public transient boolean targetRequired;
    protected EventHandlerContainer[] eventContainers;
    public transient EventExceptionHandler exceptionHandler;

    EventHandler(EventGroup g, String n, ScriptTypePredicate st, Supplier<Class<? extends KubeEvent>> e) {
        this.group = g;
        this.name = n;
        this.scriptTypePredicate = st;
        this.eventType = e;
        this.result = null;
        this.target = null;
        this.targetRequired = false;
        this.eventContainers = null;
        this.exceptionHandler = null;
    }

    @HideFromJS
    public EventHandler hasResult(TypeInfo result) {
        this.result = result;
        return this;
    }

    public EventHandler hasResult() {
        return this.hasResult(TypeInfo.NONE);
    }

    @HideFromJS
    @Nullable
    public TypeInfo getResult() {
        return this.result;
    }

    @HideFromJS
    public EventHandler exceptionHandler(EventExceptionHandler handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private <E> TargetedEventHandler<E> requiredTarget(EventTargetType<E> type, boolean required) {
        TargetedEventHandler<E> handler = new TargetedEventHandler<E>(this.group, this.name, this.scriptTypePredicate, type, this.eventType);
        handler.result = this.result;
        handler.targetRequired = required;
        handler.exceptionHandler = this.exceptionHandler;
        handler.group.getHandlers().put(this.name, handler);
        return handler;
    }

    public <E> TargetedEventHandler<E> requiredTarget(EventTargetType<E> type) {
        return this.requiredTarget(type, true);
    }

    public <E> TargetedEventHandler<E> supportsTarget(EventTargetType<E> type) {
        return this.requiredTarget(type, false);
    }

    @HideFromJS
    public void clear(ScriptType type) {
        if (this.eventContainers != null) {
            this.eventContainers[type.ordinal()] = null;
            if (EventHandlerContainer.isEmpty(this.eventContainers)) {
                this.eventContainers = null;
            }
        }
    }

    public boolean hasListeners() {
        return this.eventContainers != null;
    }

    public void listen(@Nullable Context cx, ScriptType type, @Nullable Object extraId, IEventHandler handler) {
        int index;
        if (cx != null && !((KubeJSContext)cx).kjsFactory.manager.canListenEvents) {
            throw new IllegalStateException("Event handler '" + String.valueOf((Object)this) + "' can only be registered during script loading!");
        }
        if (!this.scriptTypePredicate.test(type)) {
            throw new UnsupportedOperationException("Tried to register event handler '" + String.valueOf((Object)this) + "' for invalid script type " + String.valueOf(type) + "! Valid script types: " + String.valueOf(this.scriptTypePredicate.getValidTypes()));
        }
        if (extraId != null && this.target != null) {
            extraId = Wrapper.unwrapped((Object)extraId);
            extraId = this.target.transformer.transform(extraId);
        }
        if (this.target != null && this.targetRequired && extraId == null) {
            throw new IllegalArgumentException("Event handler '" + String.valueOf((Object)this) + "' requires extra id!");
        }
        if (this.target == null && extraId != null) {
            throw new IllegalArgumentException("Event handler '" + String.valueOf((Object)this) + "' doesn't support extra id!");
        }
        if (this.target != null && extraId != null && !this.target.validator.test(extraId)) {
            throw new IllegalArgumentException("Event handler '" + String.valueOf((Object)this) + "' doesn't accept id '" + String.valueOf(this.target.toString.transform(extraId)) + "'!");
        }
        int[] line = new int[1];
        String source = cx == null ? "java" : Context.getSourcePositionFromStack((Context)cx, (int[])line);
        EventHandlerContainer[] map = this.createMap(extraId);
        if (map[index = type.ordinal()] == null) {
            map[index] = new EventHandlerContainer(extraId, handler, source, line[0]);
        } else {
            map[index].add(extraId, handler, source, line[0]);
        }
    }

    protected EventHandlerContainer[] createMap(@Nullable Object extraId) {
        if (this.eventContainers == null) {
            this.eventContainers = new EventHandlerContainer[ScriptType.VALUES.length];
        }
        return this.eventContainers;
    }

    @HideFromJS
    public void listenJava(ScriptType type, @Nullable Object extraId, IEventHandler handler) {
        this.listen(null, type, extraId, handler);
    }

    public EventResult post(KubeEvent event) {
        ScriptTypePredicate scriptTypePredicate = this.scriptTypePredicate;
        if (scriptTypePredicate instanceof ScriptTypeHolder) {
            ScriptTypeHolder type = (ScriptTypeHolder)((Object)scriptTypePredicate);
            return this.postInternal(type, null, event);
        }
        throw new IllegalStateException("You must specify which script type to post event to");
    }

    public EventResult post(ScriptTypeHolder scriptType, KubeEvent event) {
        return this.postInternal(scriptType, null, event);
    }

    protected EventResult postInternal(ScriptTypeHolder type, @Nullable Object extraId, KubeEvent event) {
        if (!this.hasListeners()) {
            return EventResult.PASS;
        }
        ScriptType scriptType = type.kjs$getScriptType();
        if (this.target != null && this.targetRequired && extraId == null) {
            throw new IllegalArgumentException("Event handler '" + String.valueOf((Object)this) + "' requires extra id!");
        }
        if (this.target == null && extraId != null) {
            throw new IllegalArgumentException("Event handler '" + String.valueOf((Object)this) + "' doesn't support extra id " + String.valueOf(extraId) + "!");
        }
        EventResult eventResult = EventResult.PASS;
        try {
            EventHandlerContainer handler;
            EventHandlerContainer[] extraContainers;
            EventHandler eventHandler = this;
            if (eventHandler instanceof TargetedEventHandler) {
                TargetedEventHandler h = (TargetedEventHandler)eventHandler;
                v0 = h.extraEventContainers == null ? null : h.extraEventContainers.get(extraId);
            } else {
                v0 = extraContainers = null;
            }
            if (extraContainers != null) {
                handler = extraContainers[scriptType.ordinal()];
                if (handler != null) {
                    handler.handle(scriptType.console, this, event);
                }
                if (!scriptType.isStartup() && (handler = extraContainers[ScriptType.STARTUP.ordinal()]) != null) {
                    handler.handle(scriptType.console, this, event);
                }
            }
            if (this.eventContainers != null) {
                handler = this.eventContainers[scriptType.ordinal()];
                if (handler != null) {
                    handler.handle(scriptType.console, this, event);
                }
                if (!scriptType.isStartup() && (handler = this.eventContainers[ScriptType.STARTUP.ordinal()]) != null) {
                    handler.handle(scriptType.console, this, event);
                }
            }
        }
        catch (EventExit exit) {
            eventResult = exit.result;
        }
        catch (Throwable error) {
            scriptType.console.error("Internal Error in '" + String.valueOf((Object)this) + "'", error);
            eventResult = EventResult.Type.ERROR.exit(null, (Object)error).result;
        }
        event.afterPosted(eventResult);
        return eventResult;
    }

    public String toString() {
        return String.valueOf(this.group) + "." + this.name;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptType type = ((KubeJSContext)cx).getType();
        try {
            if (args.length == 1) {
                this.listen(cx, type, null, (IEventHandler)cx.jsToJava(args[0], EVENT_HANDLER_TYPE_INFO));
            } else if (args.length == 2) {
                IEventHandler handler = (IEventHandler)cx.jsToJava(args[1], EVENT_HANDLER_TYPE_INFO);
                for (Object o : ListJS.orSelf(args[0])) {
                    this.listen(cx, type, o, handler);
                }
            }
        }
        catch (Exception ex) {
            type.console.error(ex.getLocalizedMessage());
        }
        return null;
    }

    public void forEachListener(ScriptType type, Consumer<EventHandlerContainer> callback) {
        if (this.eventContainers != null) {
            EventHandlerContainer c = this.eventContainers[type.ordinal()];
            while (c != null) {
                callback.accept(c);
                c = c.child;
            }
        }
    }
}

