/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.item.ItemClickedKubeEvent;
import dev.latvian.mods.kubejs.item.ItemCraftedKubeEvent;
import dev.latvian.mods.kubejs.item.ItemDestroyedKubeEvent;
import dev.latvian.mods.kubejs.item.ItemDroppedKubeEvent;
import dev.latvian.mods.kubejs.item.ItemEntityInteractedKubeEvent;
import dev.latvian.mods.kubejs.item.ItemPickedUpKubeEvent;
import dev.latvian.mods.kubejs.item.ItemSmeltedKubeEvent;
import dev.latvian.mods.kubejs.player.InventoryChangedKubeEvent;
import dev.latvian.mods.kubejs.plugin.builtin.event.ItemEvents;
import dev.latvian.mods.kubejs.plugin.builtin.event.PlayerEvents;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="kubejs")
public class KubeJSItemEventHandler {
    @SubscribeEvent
    public static void rightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        ResourceKey key = stack.getItem().kjs$getKey();
        if (ItemEvents.RIGHT_CLICKED.hasListeners((ResourceKey<Item>)key) && !event.getEntity().getCooldowns().isOnCooldown(stack.getItem())) {
            ItemEvents.RIGHT_CLICKED.post((ScriptTypeHolder)event.getEntity(), (ResourceKey<Item>)key, new ItemClickedKubeEvent(event.getEntity(), event.getHand(), stack)).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
    }

    @SubscribeEvent
    public static void itemPickupPre(ItemEntityPickupEvent.Pre event) {
        ResourceKey key = event.getItemEntity().getItem().getItem().kjs$getKey();
        if (ItemEvents.CAN_PICK_UP.hasListeners((ResourceKey<Item>)key)) {
            ItemEvents.CAN_PICK_UP.post((ScriptTypeHolder)event.getPlayer(), (ResourceKey<Item>)key, new ItemPickedUpKubeEvent(event.getPlayer(), event.getItemEntity(), event.getItemEntity().getItem())).applyTristate(arg_0 -> ((ItemEntityPickupEvent.Pre)event).setCanPickup(arg_0));
        }
    }

    @SubscribeEvent
    public static void itemPickupPost(ItemEntityPickupEvent.Post event) {
        ResourceKey key = event.getCurrentStack().getItem().kjs$getKey();
        if (ItemEvents.PICKED_UP.hasListeners((ResourceKey<Item>)key)) {
            ItemEvents.PICKED_UP.post((ScriptTypeHolder)event.getPlayer(), (ResourceKey<Item>)key, new ItemPickedUpKubeEvent(event.getPlayer(), event.getItemEntity(), event.getCurrentStack()));
        }
    }

    @SubscribeEvent
    public static void itemDrop(ItemTossEvent event) {
        ResourceKey key = event.getEntity().getItem().getItem().kjs$getKey();
        if (ItemEvents.DROPPED.hasListeners((ResourceKey<Item>)key)) {
            ItemEvents.DROPPED.post((ScriptTypeHolder)event.getPlayer(), (ResourceKey<Item>)key, new ItemDroppedKubeEvent(event.getPlayer(), event.getEntity())).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void entityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        ResourceKey key = stack.getItem().kjs$getKey();
        if (ItemEvents.ENTITY_INTERACTED.hasListeners((ResourceKey<Item>)key)) {
            ItemEvents.ENTITY_INTERACTED.post((ScriptTypeHolder)event.getEntity(), (ResourceKey<Item>)key, new ItemEntityInteractedKubeEvent(event.getEntity(), event.getTarget(), event.getHand(), stack)).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void crafted(PlayerEvent.ItemCraftedEvent event) {
        if (!event.getCrafting().isEmpty()) {
            ResourceKey key = event.getCrafting().getItem().kjs$getKey();
            if (ItemEvents.CRAFTED.hasListeners((ResourceKey<Item>)key)) {
                ItemEvents.CRAFTED.post((ScriptTypeHolder)event.getEntity(), (ResourceKey<Item>)key, new ItemCraftedKubeEvent(event.getEntity(), event.getCrafting(), event.getInventory()));
            }
            if (PlayerEvents.INVENTORY_CHANGED.hasListeners((ResourceKey<Item>)key)) {
                PlayerEvents.INVENTORY_CHANGED.post((ScriptTypeHolder)event.getEntity(), (ResourceKey<Item>)key, new InventoryChangedKubeEvent(event.getEntity(), event.getCrafting(), -1));
            }
        }
    }

    @SubscribeEvent
    public static void smelted(PlayerEvent.ItemSmeltedEvent event) {
        if (!event.getSmelting().isEmpty()) {
            ResourceKey key = event.getSmelting().getItem().kjs$getKey();
            if (ItemEvents.SMELTED.hasListeners((ResourceKey<Item>)key)) {
                ItemEvents.SMELTED.post((ScriptTypeHolder)event.getEntity(), (ResourceKey<Item>)key, new ItemSmeltedKubeEvent(event.getEntity(), event.getSmelting()));
            }
            if (PlayerEvents.INVENTORY_CHANGED.hasListeners((ResourceKey<Item>)key)) {
                PlayerEvents.INVENTORY_CHANGED.post((ScriptTypeHolder)event.getEntity(), (ResourceKey<Item>)key, new InventoryChangedKubeEvent(event.getEntity(), event.getSmelting(), -1));
            }
        }
    }

    @SubscribeEvent
    public static void itemDestroyed(PlayerDestroyItemEvent event) {
        ResourceKey key = event.getOriginal().getItem().kjs$getKey();
        if (ItemEvents.ITEM_DESTROYED.hasListeners((ResourceKey<Item>)key)) {
            ItemEvents.ITEM_DESTROYED.post((ScriptTypeHolder)event.getEntity(), (ResourceKey<Item>)key, new ItemDestroyedKubeEvent(event));
        }
    }
}

