/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.component.ComponentValueMap;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ErrorStack;
import dev.latvian.mods.kubejs.util.OpsContainer;
import dev.latvian.mods.rhino.Context;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RecipeConstructor {
    public final List<RecipeKey<?>> keys;
    public Map<RecipeKey<?>, RecipeOptional<?>> overrides;
    public Map<RecipeKey<?>, RecipeOptional<?>> defaultValues;

    public RecipeConstructor(List<RecipeKey<?>> keys) {
        this.keys = keys;
        this.overrides = Map.of();
        this.defaultValues = Map.of();
    }

    public RecipeConstructor(RecipeKey<?> ... keys) {
        this(List.of(keys));
    }

    public <T> RecipeConstructor override(RecipeKey<T> key, RecipeOptional<T> value) {
        if (this.overrides.isEmpty()) {
            this.overrides = new Reference2ObjectLinkedOpenHashMap(1);
        }
        this.overrides.put(key, value);
        return this;
    }

    public <T> RecipeConstructor overrideValue(RecipeKey<T> key, T value) {
        return this.override(key, new RecipeOptional.Constant<T>(value));
    }

    public <T> RecipeConstructor defaultValue(RecipeKey<T> key, RecipeOptional<T> value) {
        if (this.defaultValues.isEmpty()) {
            this.defaultValues = new Reference2ObjectLinkedOpenHashMap(1);
        }
        this.defaultValues.put(key, value);
        return this;
    }

    public String toString() {
        return this.toString(OpsContainer.DEFAULT);
    }

    public String toString(OpsContainer ops) {
        Object str = this.keys.stream().map(RecipeKey::toString).collect(Collectors.joining(", ", "(", ")"));
        if (!this.overrides.isEmpty() || !this.defaultValues.isEmpty()) {
            LinkedHashMap map = new LinkedHashMap();
            map.putAll(this.defaultValues);
            map.putAll(this.overrides);
            str = (String)str + map.entrySet().stream().map(e -> {
                RecipeKey k = (RecipeKey)e.getKey();
                try {
                    Object v = ((RecipeOptional)e.getValue()).getInformativeValue();
                    if (v == null) {
                        return k.name + " = ?";
                    }
                    return k.name + " = " + k.component.toString(ops, Cast.to(v));
                }
                catch (Throwable ex) {
                    return k.name + " = ?";
                }
            }).collect(Collectors.joining(", ", " [", "]"));
        }
        return str;
    }

    public KubeRecipe create(Context cx, SourceLine sourceLine, RecipeTypeFunction type, RecipeSchemaType schemaType, ComponentValueMap from) {
        KubeRecipe recipe = schemaType.schema.recipeFactory.create(type, sourceLine, true);
        recipe.json = new JsonObject();
        recipe.json.addProperty("type", type.idString);
        recipe.newRecipe = true;
        this.setValues(new RecipeScriptContext.Impl(cx, recipe, new ErrorStack()), schemaType, from);
        return recipe;
    }

    public void setValues(RecipeScriptContext cx, RecipeSchemaType schemaType, ComponentValueMap from) {
        KubeRecipe recipe = cx.recipe();
        cx.errors().push("keys");
        for (RecipeKey<?> recipeKey : this.keys) {
            cx.errors().setKey(recipeKey.name);
            recipe.setValue(recipeKey, Cast.to(from.getValue(cx, recipeKey)));
        }
        cx.errors().pop();
        cx.errors().push("overrides");
        for (Map.Entry entry : this.overrides.entrySet()) {
            cx.errors().setKey(((RecipeKey)entry.getKey()).name);
            recipe.setValue((RecipeKey)entry.getKey(), Cast.to(((RecipeOptional)entry.getValue()).getDefaultValue(schemaType)));
        }
        cx.errors().pop();
        cx.errors().push("key_overrides");
        for (Map.Entry entry : schemaType.schema.keyOverrides.entrySet()) {
            cx.errors().setKey(((RecipeKey)entry.getKey()).name);
            recipe.setValue((RecipeKey)entry.getKey(), Cast.to(((RecipeOptional)entry.getValue()).getDefaultValue(schemaType)));
        }
        cx.errors().pop();
    }

    public JsonObject toJson(RecipeSchemaType type, DynamicOps<JsonElement> ops) {
        JsonObject json = new JsonObject();
        JsonArray k = new JsonArray(this.keys.size());
        for (RecipeKey<?> key : this.keys) {
            k.add(key.name);
        }
        json.add("keys", (JsonElement)k);
        if (!this.overrides.isEmpty()) {
            JsonObject o = new JsonObject();
            for (Map.Entry<RecipeKey<?>, RecipeOptional<?>> entry : this.overrides.entrySet()) {
                o.add(entry.getKey().name, (JsonElement)entry.getKey().codec.encodeStart(ops, Cast.to(entry.getValue().getDefaultValue(type))).getOrThrow());
            }
            json.add("overrides", (JsonElement)o);
        }
        return json;
    }
}

