/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.plugin.builtin.event.ServerEvents;
import dev.latvian.mods.kubejs.recipe.RecipeTypeRegistryContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.schema.JsonRecipeSchemaLoader;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeFactoryRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeMappingRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.UnknownRecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessor;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessorType;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class RecipeSchemaStorage {
    private final ServerScriptManager manager;
    public final Map<ResourceLocation, KubeRecipeFactory> recipeTypes;
    public final Map<String, RecipeNamespace> namespaces;
    public final Map<String, ResourceLocation> mappings;
    public final Map<String, RecipeSchemaType> schemaTypes;
    public RecipeSchema shapedSchema;
    public RecipeSchema shapelessSchema;
    public RecipeSchema specialSchema;
    public Codec<RecipeComponent<?>> recipeComponentCodec;
    public Codec<RecipePostProcessor> recipePostProcessorCodec;

    public RecipeSchemaStorage(ServerScriptManager manager) {
        this.manager = manager;
        this.recipeTypes = new HashMap<ResourceLocation, KubeRecipeFactory>();
        this.namespaces = new HashMap<String, RecipeNamespace>();
        this.mappings = new HashMap<String, ResourceLocation>();
        this.schemaTypes = new HashMap<String, RecipeSchemaType>();
    }

    public RecipeNamespace namespace(String namespace) {
        return this.namespaces.computeIfAbsent(namespace, n -> new RecipeNamespace(this, (String)n));
    }

    RegistryAccessContainer getRegistries() {
        return this.manager.getRegistries();
    }

    public void fireEvents(RegistryAccessContainer registries, ResourceManager resourceManager) {
        this.recipeTypes.clear();
        this.namespaces.clear();
        this.mappings.clear();
        this.schemaTypes.clear();
        this.shapedSchema = null;
        this.shapelessSchema = null;
        this.specialSchema = null;
        RegistryOps<JsonElement> jsonOps = registries.json();
        RecipeFactoryRegistry typeEvent = new RecipeFactoryRegistry(this);
        KubeJSPlugins.forEachPlugin(typeEvent, KubeJSPlugin::registerRecipeFactories);
        for (Map.Entry entry : resourceManager.listResources("kubejs", path -> path.getPath().endsWith("/recipe_mappings.json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                    for (Iterator entry1 : json.entrySet()) {
                        ResourceLocation id2 = ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((String)entry1.getKey()));
                        Object object = entry1.getValue();
                        if (object instanceof JsonArray) {
                            JsonArray arr = (JsonArray)object;
                            for (JsonElement n : arr) {
                                this.mappings.put(n.getAsString(), id2);
                            }
                            continue;
                        }
                        this.mappings.put(((JsonElement)entry1.getValue()).getAsString(), id2);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        RecipeMappingRegistry mappingRegistry = new RecipeMappingRegistry(this);
        KubeJSPlugins.forEachPlugin(mappingRegistry, KubeJSPlugin::registerRecipeMappings);
        ServerEvents.RECIPE_MAPPING_REGISTRY.post(ScriptType.SERVER, mappingRegistry);
        HashMap<ResourceLocation, StoredRecipeComponentType> componentTypes = new HashMap<ResourceLocation, StoredRecipeComponentType>();
        Codec typeCodec = KubeJSCodecs.KUBEJS_ID.comapFlatMap(id -> {
            StoredRecipeComponentType stored = (StoredRecipeComponentType)componentTypes.get(id);
            if (stored != null) {
                return DataResult.success((Object)stored);
            }
            return DataResult.error(() -> "Unknown recipe component type '" + ID.reduceKjs(id) + "'");
        }, stored -> stored.type.id());
        Codec directComponentCodec = typeCodec.partialDispatch("type", c -> {
            StoredRecipeComponentType stored = (StoredRecipeComponentType)componentTypes.get(c.type().id());
            if (stored != null) {
                return DataResult.success((Object)stored);
            }
            return DataResult.error(() -> "Missing stored recipe component type for '" + ID.reduceKjs(c.type().id()) + "'");
        }, type -> DataResult.success(type.mapCodec));
        this.recipeComponentCodec = Codec.either((Codec)typeCodec, (Codec)directComponentCodec).comapFlatMap(either -> (DataResult)either.map(stored -> {
            if (stored.unit != null) {
                return DataResult.success(stored.unit);
            }
            return stored.mapCodec.decode((DynamicOps)jsonOps, JsonUtils.MAP_LIKE);
        }, DataResult::success), component -> {
            if (component.type().isUnit()) {
                return Either.left((Object)((StoredRecipeComponentType)componentTypes.get(component.type().id())));
            }
            return Either.right((Object)component);
        });
        KubeJSPlugins.forEachPlugin(type -> componentTypes.put(type.id(), new StoredRecipeComponentType(type)), KubeJSPlugin::registerRecipeComponents);
        RecipeTypeRegistryContext rcCtx = new RecipeTypeRegistryContext(registries, this);
        for (StoredRecipeComponentType stored2 : componentTypes.values()) {
            stored2.init(rcCtx);
        }
        for (Map.Entry entry : resourceManager.listResources("kubejs", path -> path.getPath().endsWith("/recipe_components.json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                    for (Map.Entry entry1 : json.entrySet()) {
                        ResourceLocation id3 = ID.kjs(entry1.getKey());
                        DataResult componentResult = this.recipeComponentCodec.parse(jsonOps, (Object)((JsonElement)entry1.getValue()));
                        if (componentResult.isSuccess()) {
                            StoredRecipeComponentType stored3 = new StoredRecipeComponentType(RecipeComponentType.unit(id3, (RecipeComponent)componentResult.getOrThrow()));
                            componentTypes.put(id3, stored3);
                            stored3.init(rcCtx);
                            continue;
                        }
                        KubeJS.LOGGER.error("Failed to load recipe component {} from {}: {}", new Object[]{id3, entry.getKey(), componentResult.error().map(DataResult.Error::message).orElse("Unknown Error")});
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception ex) {
                KubeJS.LOGGER.error("Failed to load recipe component file {}: {}", entry.getKey(), (Object)ex);
            }
        }
        this.recipePostProcessorCodec = RecipePostProcessorType.CODEC.dispatch("type", RecipePostProcessor::type, type -> type.mapCodec().apply(rcCtx));
        for (Map.Entry entry : BuiltInRegistries.RECIPE_SERIALIZER.entrySet()) {
            RecipeNamespace ns = this.namespace(((ResourceKey)entry.getKey()).location().getNamespace());
            ns.put(((ResourceKey)entry.getKey()).location().getPath(), new UnknownRecipeSchemaType(ns, ((ResourceKey)entry.getKey()).location(), (RecipeSerializer)entry.getValue()));
        }
        RecipeSchemaRegistry schemaRegistry = new RecipeSchemaRegistry(this);
        JsonRecipeSchemaLoader.load(rcCtx, jsonOps, schemaRegistry, resourceManager);
        this.shapedSchema = Objects.requireNonNull(((RecipeSchemaType)this.namespace((String)"minecraft").get((Object)"shaped")).schema);
        this.shapelessSchema = Objects.requireNonNull(((RecipeSchemaType)this.namespace((String)"minecraft").get((Object)"shapeless")).schema);
        this.specialSchema = Objects.requireNonNull(((RecipeSchemaType)this.namespace((String)"minecraft").get((Object)"special")).schema);
        KubeJSPlugins.forEachPlugin(schemaRegistry, KubeJSPlugin::registerRecipeSchemas);
        ServerEvents.RECIPE_SCHEMA_REGISTRY.post(ScriptType.SERVER, schemaRegistry);
    }

    public static final class StoredRecipeComponentType {
        private final RecipeComponentType<?> type;
        private MapCodec<RecipeComponent<?>> mapCodec;
        private RecipeComponent<?> unit;

        public StoredRecipeComponentType(RecipeComponentType<?> type) {
            this.type = type;
        }

        @NotNull
        public String toString() {
            return this.type.toString();
        }

        public void init(RecipeTypeRegistryContext ctx) {
            this.mapCodec = this.type.mapCodec(ctx);
            this.unit = this.type.isUnit() ? this.type.instance() : (RecipeComponent)this.mapCodec.decode((DynamicOps)JsonOps.INSTANCE, JsonUtils.MAP_LIKE).result().orElse(null);
        }
    }
}

