/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema.postprocessing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.IngredientComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeValidationContext;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessor;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessorType;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.TinyMap;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public record KeyPatternCleanupPostProcessor(String patternName, String keyName, RecipeComponent<?> component) implements RecipePostProcessor
{
    public static final RecipePostProcessorType<KeyPatternCleanupPostProcessor> TYPE = new RecipePostProcessorType(KubeJS.id("key_pattern_cleanup"), ctx -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("pattern", (Object)"pattern").forGetter(KeyPatternCleanupPostProcessor::patternName), (App)Codec.STRING.optionalFieldOf("key", (Object)"key").forGetter(KeyPatternCleanupPostProcessor::keyName), (App)ctx.recipeComponentCodec().optionalFieldOf("component", IngredientComponent.INGREDIENT.instance()).forGetter(KeyPatternCleanupPostProcessor::component)).apply((Applicative)instance, KeyPatternCleanupPostProcessor::new)));

    @Override
    public RecipePostProcessorType<?> type() {
        return TYPE;
    }

    @Override
    public void process(RecipeValidationContext ctx, KubeRecipe recipe) {
        RecipeKey keyKey = recipe.type.schemaType.schema.getKey(this.keyName);
        TinyMap key = (TinyMap)recipe.getValue(keyKey);
        CharArrayList airs = null;
        ArrayList entries = new ArrayList(Arrays.asList(key.entries()));
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            TinyMap.Entry entry = itr.next();
            if (entry.value() != null && !this.component.isEmpty(Cast.to(entry.value()))) continue;
            if (airs == null) {
                airs = new CharArrayList(1);
            }
            airs.add(((Character)entry.key()).charValue());
            itr.remove();
        }
        if (airs != null) {
            RecipeKey patternKey = recipe.type.schemaType.schema.getKey(this.patternName);
            ArrayList<String> pattern = new ArrayList<String>((Collection)recipe.getValue(patternKey));
            char[] airChars = airs.toCharArray();
            for (int i = 0; i < pattern.size(); ++i) {
                for (char a : airChars) {
                    pattern.set(i, ((String)pattern.get(i)).replace(a, ' '));
                }
            }
            recipe.setValue(patternKey, pattern);
            recipe.setValue(keyKey, new TinyMap(entries));
        }
    }
}

