/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.models;

import com.ninni.ftgu.client.models.animations.ChargedCreeperAnimations;
import com.ninni.ftgu.server.entity.ChargedCreeperEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ChargedCreeperModel
extends HierarchicalModel<ChargedCreeperEntity> {
    private final ModelPart root;
    private final ModelPart all2;
    private final ModelPart all;
    private final ModelPart body2;
    private final ModelPart body;
    private final ModelPart torso;
    private final ModelPart head2;
    private final ModelPart head;
    private final ModelPart creeperHead;
    private final ModelPart supportHead;
    private final ModelPart festiveHead;
    private final ModelPart rocketHead;
    private final ModelPart leftArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;

    public ChargedCreeperModel(ModelPart root) {
        this.root = root;
        this.all2 = this.root.m_171324_("all2");
        this.all = this.all2.m_171324_("all");
        this.body2 = this.all.m_171324_("body2");
        this.body = this.body2.m_171324_("body");
        this.torso = this.body.m_171324_("torso");
        this.head2 = this.body.m_171324_("head2");
        this.head = this.head2.m_171324_("head");
        this.creeperHead = this.head.m_171324_("creeperHead");
        this.supportHead = this.head.m_171324_("supportHead");
        this.festiveHead = this.head.m_171324_("festiveHead");
        this.rocketHead = this.head.m_171324_("rocketHead");
        this.leftArm = this.all.m_171324_("leftArm");
        this.leftLeg = this.all.m_171324_("leftLeg");
        this.rightLeg = this.all.m_171324_("rightLeg");
        this.rightArm = this.all.m_171324_("rightArm");
    }

    public void setupAnim(ChargedCreeperEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float pi = (float)Math.PI;
        float degToRad = pi / 180.0f;
        int elapsed = 40 - entity.getHeadTimer();
        float t = Mth.m_14036_((float)((float)elapsed / 20.0f), (float)0.0f, (float)1.0f);
        float eased = (float)Math.sin((double)t * Math.PI * 0.5);
        this.head.f_104204_ = Mth.m_14179_((float)eased, (float)entity.getHeadRotationStart(), (float)entity.getHeadRotation());
        if (elapsed >= 20) {
            this.head.f_104204_ = entity.getHeadRotation();
        }
        this.head.f_104204_ += headYaw * degToRad;
        this.m_267799_(ChargedCreeperAnimations.WALK, limbSwing, limbSwingAmount, 10.0f, 8.0f);
        this.m_233385_(entity.spawnAnimationState, ChargedCreeperAnimations.SPAWN, ageInTicks, 1.0f);
        this.m_233385_(entity.explodeAttackAnimationState, ChargedCreeperAnimations.EXPLODE, ageInTicks, 1.0f);
        this.m_233385_(entity.festiveAttackAnimationState, ChargedCreeperAnimations.SHOOT_MINES, ageInTicks, 1.0f);
        this.m_233385_(entity.rocketAttackAnimationState, ChargedCreeperAnimations.SHOOT_ROCKET, ageInTicks, 1.0f);
        this.m_233385_(entity.supportAttackAnimationState, ChargedCreeperAnimations.CREATE_BUSHES, ageInTicks, 1.0f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all2 = partdefinition.m_171599_("all2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition all = all2.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body2 = all.m_171599_("body2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = body2.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-7.0f, -1.0f, -7.0f, 14.0f, 32.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)-31.0f, (float)0.0f));
        PartDefinition head2 = body.m_171599_("head2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-31.0f, (float)0.0f));
        PartDefinition head = head2.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171481_(-9.0f, -19.0f, -9.0f, 18.0f, 19.0f, 18.0f).m_171514_(-18, 83).m_171481_(-9.0f, -11.0f, -9.0f, 18.0f, 0.0f, 18.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition creeperHead = head.m_171599_("creeperHead", CubeListBuilder.m_171558_().m_171514_(56, 23).m_171481_(-4.0f, -4.0f, -3.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-9.0f));
        PartDefinition supportHead = head.m_171599_("supportHead", CubeListBuilder.m_171558_().m_171514_(56, 34).m_171481_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)9.0f));
        PartDefinition festiveHead = head.m_171599_("festiveHead", CubeListBuilder.m_171558_().m_171514_(78, 23).m_171481_(0.0f, -4.0f, -4.0f, 3.0f, 8.0f, 8.0f), PartPose.m_171419_((float)9.0f, (float)-6.0f, (float)0.0f));
        PartDefinition rocketHead = head.m_171599_("rocketHead", CubeListBuilder.m_171558_().m_171514_(78, 39).m_171481_(-3.0f, -4.0f, -4.0f, 3.0f, 8.0f, 8.0f), PartPose.m_171419_((float)-9.0f, (float)-6.0f, (float)0.0f));
        PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171481_(-2.0f, -2.0f, -5.0f, 8.0f, 15.0f, 8.0f).m_171514_(60, 71).m_171481_(-4.0f, 12.9f, -7.0f, 12.0f, 3.0f, 12.0f).m_171514_(20, 86).m_171481_(-6.0f, 15.9f, -9.0f, 16.0f, 0.0f, 16.0f), PartPose.m_171419_((float)7.0f, (float)-4.0f, (float)-8.0f));
        PartDefinition leftLeg = all.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171481_(-2.0f, -2.0f, -3.0f, 8.0f, 15.0f, 8.0f).m_171514_(60, 71).m_171481_(-4.0f, 12.9f, -5.0f, 12.0f, 3.0f, 12.0f).m_171514_(20, 86).m_171481_(-6.0f, 15.9f, -7.0f, 16.0f, 0.0f, 16.0f), PartPose.m_171419_((float)7.0f, (float)-4.0f, (float)8.0f));
        PartDefinition rightLeg = all.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171481_(-6.0f, -2.0f, -3.0f, 8.0f, 15.0f, 8.0f).m_171555_(false).m_171514_(60, 71).m_171480_().m_171481_(-8.0f, 12.9f, -5.0f, 12.0f, 3.0f, 12.0f).m_171555_(false).m_171514_(20, 86).m_171480_().m_171481_(-10.0f, 15.9f, -7.0f, 16.0f, 0.0f, 16.0f).m_171555_(false), PartPose.m_171419_((float)-7.0f, (float)-4.0f, (float)8.0f));
        PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171481_(-6.0f, -2.0f, -5.0f, 8.0f, 15.0f, 8.0f).m_171555_(false).m_171514_(60, 71).m_171480_().m_171481_(-8.0f, 12.9f, -7.0f, 12.0f, 3.0f, 12.0f).m_171555_(false).m_171514_(20, 86).m_171480_().m_171481_(-10.0f, 15.9f, -9.0f, 16.0f, 0.0f, 16.0f).m_171555_(false), PartPose.m_171419_((float)-7.0f, (float)-4.0f, (float)-8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)112, (int)112);
    }

    public static LayerDefinition createChargeBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all2 = partdefinition.m_171599_("all2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition all = all2.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body2 = all.m_171599_("body2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = body2.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -1.0f, -7.0f, 14.0f, 32.0f, 14.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)-31.0f, (float)0.0f));
        PartDefinition head2 = body.m_171599_("head2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-31.0f, (float)0.0f));
        PartDefinition head = head2.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-9.0f, -19.0f, -9.0f, 18.0f, 19.0f, 18.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition creeperHead = head.m_171599_("creeperHead", CubeListBuilder.m_171558_().m_171514_(56, 23).m_171488_(-4.0f, -4.0f, -3.0f, 8.0f, 8.0f, 3.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-9.0f));
        PartDefinition supportHead = head.m_171599_("supportHead", CubeListBuilder.m_171558_().m_171514_(56, 34).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 3.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)9.0f));
        PartDefinition festiveHead = head.m_171599_("festiveHead", CubeListBuilder.m_171558_().m_171514_(78, 23).m_171488_(0.0f, -4.0f, -4.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)9.0f, (float)-6.0f, (float)0.0f));
        PartDefinition rocketHead = head.m_171599_("rocketHead", CubeListBuilder.m_171558_().m_171514_(78, 39).m_171488_(-3.0f, -4.0f, -4.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)-9.0f, (float)-6.0f, (float)0.0f));
        PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-2.0f, -2.0f, -5.0f, 8.0f, 15.0f, 8.0f, new CubeDeformation(-1.0f)).m_171514_(60, 71).m_171488_(-4.0f, 12.9f, -7.0f, 12.0f, 3.0f, 12.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)7.0f, (float)-4.0f, (float)-8.0f));
        PartDefinition leftLeg = all.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-2.0f, -2.0f, -3.0f, 8.0f, 15.0f, 8.0f, new CubeDeformation(-1.0f)).m_171514_(60, 71).m_171488_(-4.0f, 12.9f, -5.0f, 12.0f, 3.0f, 12.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)7.0f, (float)-4.0f, (float)8.0f));
        PartDefinition rightLeg = all.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171488_(-6.0f, -2.0f, -3.0f, 8.0f, 15.0f, 8.0f, new CubeDeformation(-1.0f)).m_171555_(false).m_171514_(60, 71).m_171480_().m_171488_(-8.0f, 12.9f, -5.0f, 12.0f, 3.0f, 12.0f, new CubeDeformation(1.0f)).m_171555_(false), PartPose.m_171419_((float)-7.0f, (float)-4.0f, (float)8.0f));
        PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171488_(-6.0f, -2.0f, -5.0f, 8.0f, 15.0f, 8.0f, new CubeDeformation(-1.0f)).m_171555_(false).m_171514_(60, 71).m_171480_().m_171488_(-8.0f, 12.9f, -7.0f, 12.0f, 3.0f, 12.0f, new CubeDeformation(1.0f)).m_171555_(false), PartPose.m_171419_((float)-7.0f, (float)-4.0f, (float)-8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)112, (int)112);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

