/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.models;

import com.ninni.ftgu.FromTheGroundUp;
import com.ninni.ftgu.client.models.animations.CreeperReanimations;
import com.ninni.ftgu.server.entity.ExplodeAnimationState;
import com.ninni.ftgu.server.entity.accessor.CreeperAccessor;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.monster.Creeper;

public class CreeperRemodel
extends HierarchicalModel<Creeper> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart leaves;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public CreeperRemodel(ModelPart root) {
        this.root = root;
        this.all = root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.leaves = this.body.m_171324_("leaves");
        this.head = this.body.m_171324_("head");
        this.leftArm = this.all.m_171324_("leftArm");
        this.rightArm = this.all.m_171324_("rightArm");
        this.rightleg = this.all.m_171324_("rightleg");
        this.leftleg = this.all.m_171324_("leftleg");
    }

    public void setupAnim(Creeper entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float pi = (float)Math.PI;
        float degToRad = pi / 180.0f;
        this.head.f_104203_ = headPitch * degToRad;
        this.head.f_104204_ = headYaw * degToRad;
        if (entity instanceof CreeperAccessor) {
            CreeperAccessor accessor = (CreeperAccessor)entity;
            if (limbSwingAmount > 0.7f && ((Boolean)FromTheGroundUp.COMMON_CONFIG.canCreepersSprint.get()).booleanValue()) {
                this.m_267799_(CreeperReanimations.RUN, limbSwing, limbSwingAmount, 3.5f, 8.0f);
            } else {
                this.m_267799_(CreeperReanimations.WALK, limbSwing, limbSwingAmount, 3.5f, 8.0f);
            }
            if (accessor.getSwell() > 0) {
                ExplodeAnimationState state = accessor.getExplodeAnimationState();
                float partial = ageInTicks - (float)entity.f_19797_;
                if (partial < 0.0f) {
                    partial = 0.0f;
                }
                if (partial > 1.0f) {
                    partial = 1.0f;
                }
                state.setFromSwell(accessor.getSwell(), partial);
                this.m_233385_(state, CreeperReanimations.EXPLODE, ageInTicks, 1.0f);
            }
            this.m_233385_(accessor.getNoticedAnimationState(), CreeperReanimations.NOTICED, ageInTicks, 1.0f);
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition getLayerDefinition() {
        return CreeperRemodel.createModel(false);
    }

    public static LayerDefinition getChargedLayerDefinition() {
        return CreeperRemodel.createModel(true);
    }

    public static LayerDefinition createModel(boolean charged) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubeDeformation = new CubeDeformation(charged ? 1.5f : 0.0f);
        if (charged) {
            PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
            PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
            PartDefinition leaves = body.m_171599_("leaves", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 18.0f, 10.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
            PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 20).m_171488_(-4.0f, -4.0f, -5.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)-5.0f));
            PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.0f, -1.0f, -4.0f, 6.0f, 10.0f, 6.0f, cubeDeformation), PartPose.m_171419_((float)6.0f, (float)-9.0f, (float)-5.0f));
            PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171480_().m_171488_(-4.0f, -1.0f, -4.0f, 6.0f, 10.0f, 6.0f, cubeDeformation).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)-9.0f, (float)-5.0f));
            PartDefinition rightleg = all.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171480_().m_171488_(-4.0f, -1.0f, -2.0f, 6.0f, 10.0f, 6.0f, cubeDeformation).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)-9.0f, (float)5.0f));
            PartDefinition partDefinition = all.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.0f, -1.0f, -2.0f, 6.0f, 10.0f, 6.0f, cubeDeformation), PartPose.m_171419_((float)6.0f, (float)-9.0f, (float)5.0f));
        } else {
            PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
            PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
            PartDefinition leaves = body.m_171599_("leaves", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 18.0f, 10.0f, cubeDeformation.m_171469_(0.5f)).m_171514_(0, 0).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 18.0f, 10.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
            PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 20).m_171488_(-4.0f, -4.0f, -5.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)-5.0f));
            PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171488_(-5.0f, 8.8f, -8.0f, 13.0f, 0.0f, 13.0f, cubeDeformation).m_171514_(40, 0).m_171488_(-2.0f, -1.0f, -4.0f, 6.0f, 10.0f, 6.0f, cubeDeformation), PartPose.m_171419_((float)6.0f, (float)-9.0f, (float)-5.0f));
            PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171480_().m_171488_(-8.0f, 8.8f, -8.0f, 13.0f, 0.0f, 13.0f, cubeDeformation).m_171555_(false).m_171514_(40, 0).m_171480_().m_171488_(-4.0f, -1.0f, -4.0f, 6.0f, 10.0f, 6.0f, cubeDeformation).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)-9.0f, (float)-5.0f));
            PartDefinition rightleg = all.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171480_().m_171488_(-8.0f, 8.8f, -6.0f, 13.0f, 0.0f, 13.0f, cubeDeformation).m_171555_(false).m_171514_(40, 0).m_171480_().m_171488_(-4.0f, -1.0f, -2.0f, 6.0f, 10.0f, 6.0f, cubeDeformation).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)-9.0f, (float)5.0f));
            PartDefinition partDefinition = all.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(27, 37).m_171488_(-5.0f, 8.8f, -6.0f, 13.0f, 0.0f, 13.0f, cubeDeformation).m_171514_(40, 0).m_171488_(-2.0f, -1.0f, -2.0f, 6.0f, 10.0f, 6.0f, cubeDeformation), PartPose.m_171419_((float)6.0f, (float)-9.0f, (float)5.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)80, (int)64);
    }
}

