/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ShockwaveParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected ShockwaveParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.sprites = spriteSet;
        this.m_108339_(spriteSet);
        this.f_107225_ = 10;
        this.f_107663_ = 4.0f + level.f_46441_.m_188501_();
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        this.m_107271_((float)this.f_107225_ / (float)this.f_107224_);
    }

    protected int m_6355_(float tint) {
        return 240;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float delta) {
        this.renderRotatedParticle(consumer, camera, delta, true, 0.0f);
        this.renderRotatedParticle(consumer, camera, delta, false, 0.0f);
        super.m_5744_(consumer, camera, delta);
    }

    void renderRotatedParticle(VertexConsumer vertexConsumer, Camera camera, float delta, boolean bl, float rotatingAmount) {
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)delta, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)delta, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)delta, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Vector3f vector = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
        Quaternionf quaternionf1 = new Quaternionf().setAngleAxis(0.0f, vector.x(), vector.y(), vector.z());
        quaternionf1.rotationX(1.5707964f);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(delta);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf1);
            if (bl) {
                vector3f.rotate((Quaternionfc)new Quaternionf().rotationX((float)Math.PI));
            }
            if (rotatingAmount > 0.0f) {
                vector3f.rotate((Quaternionfc)new Quaternionf().rotationY((float)this.f_107224_ * rotatingAmount));
            }
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        int j = this.m_6355_(delta);
        this.makeCornerVertex(vertexConsumer, avector3f[0], this.m_5952_(), this.m_5950_(), j);
        this.makeCornerVertex(vertexConsumer, avector3f[1], this.m_5952_(), this.m_5951_(), j);
        this.makeCornerVertex(vertexConsumer, avector3f[2], this.m_5970_(), this.m_5951_(), j);
        this.makeCornerVertex(vertexConsumer, avector3f[3], this.m_5970_(), this.m_5950_(), j);
    }

    void makeCornerVertex(VertexConsumer p_254493_, Vector3f p_253752_, float p_254250_, float p_254047_, int p_253814_) {
        p_254493_.m_5483_((double)p_253752_.x(), (double)p_253752_.y(), (double)p_253752_.z()).m_7421_(p_254250_, p_254047_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p_253814_).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double speed, double pYSpeed, double pZSpeed) {
            return new ShockwaveParticle(pLevel, pX, pY, pZ, this.sprites);
        }
    }
}

