/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.ftgu.client.models.EndermanRemodel;
import com.ninni.ftgu.client.renderer.layer.EndermanCarriedBlockLayer;
import com.ninni.ftgu.client.renderer.layer.EndermanGlowLayer;
import com.ninni.ftgu.registry.FTGUEntityModelLayers;
import com.ninni.ftgu.server.entity.accessor.EnderManAccessor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.EnderMan;

public class EndermanRerenderer
extends MobRenderer<EnderMan, EndermanRemodel> {
    public static final ResourceLocation TEXTURE_SHATTERED = new ResourceLocation("ftgu", "textures/entity/enderman/shattered_enderman.png");
    public static final ResourceLocation TEXTURE = new ResourceLocation("ftgu", "textures/entity/enderman/enderman.png");
    private final EndermanRemodel normalModel;
    private final EndermanRemodel shatteredModel;

    public EndermanRerenderer(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.0f);
        this.m_115326_((RenderLayer)new EndermanGlowLayer((RenderLayerParent<EnderMan, EndermanRemodel>)this));
        this.m_115326_(new EndermanCarriedBlockLayer((RenderLayerParent)this, ctx.m_234597_()));
        this.normalModel = new EndermanRemodel(ctx.m_174023_(FTGUEntityModelLayers.WARPED));
        this.f_115290_ = this.normalModel;
        this.shatteredModel = new EndermanRemodel(ctx.m_174023_(FTGUEntityModelLayers.WARPED_SHATTERED));
    }

    public void render(EnderMan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity instanceof EnderManAccessor) {
            EnderManAccessor accessor = (EnderManAccessor)entity;
            this.f_115290_ = accessor.isShattered() ? this.shatteredModel : this.normalModel;
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(EnderMan livingEntity, PoseStack poseStack, float partialTickTime) {
        poseStack.m_85841_(0.87f, 0.87f, 0.87f);
        super.m_7546_((LivingEntity)livingEntity, poseStack, partialTickTime);
    }

    public ResourceLocation getTextureLocation(EnderMan entity) {
        EnderManAccessor accessor;
        if (entity instanceof EnderManAccessor && (accessor = (EnderManAccessor)entity).isShattered()) {
            return TEXTURE_SHATTERED;
        }
        return TEXTURE;
    }
}

