/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.mixin;

import com.ninni.ftgu.FromTheGroundUp;
import com.ninni.ftgu.registry.FTGUParticles;
import com.ninni.ftgu.registry.FTGUSoundEvents;
import com.ninni.ftgu.registry.FTGUTags;
import com.ninni.ftgu.server.entity.accessor.EnderManAccessor;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderMan.class}, priority=2000)
public abstract class EnderManMixin
extends Monster
implements NeutralMob,
EnderManAccessor {
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> f_32473_;
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_SHATTERED;
    @Unique
    public final AnimationState idleAnimationState = new AnimationState();
    @Unique
    public final AnimationState creepyIdleAnimationState = new AnimationState();
    @Unique
    public final AnimationState screamAnimationState = new AnimationState();
    @Unique
    public final AnimationState teleportAnimationState = new AnimationState();
    @Unique
    private int idleAnimationTimeout = 0;
    @Unique
    private int creepyIdleAnimationTimeout = 0;
    @Unique
    private byte TELEPORT = (byte)67;
    @Unique
    private byte SCREAM = (byte)68;
    @Unique
    private byte SPAWN = (byte)69;
    @Unique
    private double tpFromX;
    @Unique
    private double tpFromY;
    @Unique
    private double tpFromZ;

    @Shadow
    public abstract boolean m_32531_();

    @Shadow
    abstract boolean m_32500_(Entity var1);

    @Shadow
    public abstract void m_32521_(@Nullable BlockState var1);

    protected EnderManMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (!(level instanceof ServerLevel)) {
            return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        }
        Holder biome = level.m_204166_(this.m_20183_());
        if (((Boolean)FromTheGroundUp.COMMON_CONFIG.endermenSpawnAsShattered.get()).booleanValue()) {
            if (biome.m_203656_(FTGUTags.ENDERMAN_HOME)) {
                this.setShattered(false);
            } else if (biome.m_203656_(FTGUTags.ENDERMAN_SAFE)) {
                this.setShattered((double)this.f_19796_.m_188501_() < 0.3);
            } else {
                this.setShattered(true);
            }
        }
        Optional<Block> optional = BuiltInRegistries.f_256975_.m_203431_(FTGUTags.ENDERMAN_HOLDING_SPAWN).flatMap(element -> element.m_213653_(this.f_19796_)).map(Holder::m_203334_);
        optional.ifPresent(block -> this.selectBlockToSpawn(level, block.m_49966_()));
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @Unique
    private void selectBlockToSpawn(ServerLevelAccessor level, BlockState state) {
        if (level.m_6018_().m_46472_().equals((Object)Level.f_46430_)) {
            if ((double)this.f_19796_.m_188501_() <= (Double)FromTheGroundUp.COMMON_CONFIG.endermanSpawnHoldingBlocksChanceEnd.get()) {
                this.m_32521_(state);
            }
        } else if (level.m_6018_().m_46472_().equals((Object)Level.f_46429_)) {
            if ((double)this.f_19796_.m_188501_() <= (Double)FromTheGroundUp.COMMON_CONFIG.endermanSpawnHoldingBlocksChanceNether.get()) {
                this.m_32521_(state);
            }
        } else if ((double)this.f_19796_.m_188501_() <= (Double)FromTheGroundUp.COMMON_CONFIG.endermanSpawnHoldingBlocksChance.get()) {
            this.m_32521_(state);
        }
    }

    @Redirect(method={"registerGoals"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V"))
    private void ftgu$skipBlockPickupGoals(GoalSelector instance, int priority, Goal goal) {
        String name;
        if (!((Boolean)FromTheGroundUp.COMMON_CONFIG.endermanAllowedToPickUpAndPlaceBlocks.get()).booleanValue() && ((name = goal.getClass().getName()).contains("TakeBlock") || name.contains("LeaveBlock") || name.contains("PlaceBlock"))) {
            return;
        }
        instance.m_25352_(priority, goal);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_9236_().m_7605_((Entity)this, this.SPAWN);
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
            this.m_5496_((SoundEvent)FTGUSoundEvents.ENDERMAN_TELEPORT_TO.get(), 0.5f, this.m_6100_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_32531_() && this.m_5448_() != null) {
            if (this.isShattered()) {
                if ((double)this.f_19796_.m_188501_() <= (Double)FromTheGroundUp.COMMON_CONFIG.shatteredEndermenFightingTeleportChance.get()) {
                    this.m_32500_((Entity)this.m_5448_());
                }
            } else if ((double)this.f_19796_.m_188501_() <= (Double)FromTheGroundUp.COMMON_CONFIG.endermenFightingTeleportChance.get()) {
                this.m_32500_((Entity)this.m_5448_());
            }
        }
        if (this.m_9236_().f_46443_) {
            if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.endermanFightSoundsEnabled.get()).booleanValue()) {
                if (this.m_9236_().f_46441_.m_188503_(40) == 0 && this.m_32531_()) {
                    FromTheGroundUp.PROXY.playClientSoundEvent((SoundEvent)FTGUSoundEvents.ENDERMAN_SCATTER.get(), this.m_5720_(), 1.0f, 1.0f, this.f_19796_.m_188505_());
                }
                if (this.m_9236_().f_46441_.m_188503_(20) == 0 && this.m_32531_()) {
                    FromTheGroundUp.PROXY.playClientSoundEvent((SoundEvent)FTGUSoundEvents.ENDERMAN_AURA.get(), this.m_5720_(), 1.0f, 1.0f, this.f_19796_.m_188505_());
                }
            }
            this.setupAnimationStates();
        }
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"))
    private void FTGU$replaceIdleParticle(Level level, ParticleOptions original, double x, double y, double z, double dx, double dy, double dz) {
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanParticles.get()).booleanValue()) {
            if ((double)this.f_19796_.m_188501_() < 0.1) {
                level.m_7106_((ParticleOptions)FTGUParticles.WARP.get(), this.m_20208_(2.0), this.m_20187_() - 0.25, this.m_20262_(2.0), dx, dy, dz);
            }
        } else {
            level.m_7106_(original, x, y, z, dx, dy, dz);
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void FTGU$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_SHATTERED, (Object)false);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void FTGU$readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        this.setShattered(compound.m_128471_("Shattered"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void FTGU$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Shattered", this.isShattered());
    }

    @Override
    public boolean isShattered() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHATTERED);
    }

    public void setShattered(boolean bl) {
        this.f_19804_.m_135381_(DATA_SHATTERED, (Object)bl);
    }

    @Inject(method={"teleport(DDD)Z"}, at={@At(value="RETURN")})
    private void FTGU$afterTeleport(CallbackInfoReturnable<Boolean> cir) {
        if (!this.m_9236_().f_46443_ && ((Boolean)cir.getReturnValue()).booleanValue()) {
            this.m_9236_().m_7605_((Entity)((EnderMan)this), this.TELEPORT);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onSyncedDataUpdated"})
    private void FTGU$onSyncedDataUpdated(EntityDataAccessor<?> key, CallbackInfo ci) {
        if (f_32473_.equals(key) && this.m_32531_()) {
            this.m_9236_().m_7605_((Entity)this, this.SCREAM);
            if (!this.m_9236_().f_46443_ && !this.m_20067_() && ((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20188_(), this.m_20189_(), (SoundEvent)FTGUSoundEvents.ENDERMAN_AGGRO.get(), this.m_5720_(), 2.5f, 1.0f);
                this.m_216990_((SoundEvent)FTGUSoundEvents.ENDERMAN_SCREAM.get());
            }
        }
    }

    protected void m_6153_() {
        super.m_6153_();
        if (((Boolean)FromTheGroundUp.COMMON_CONFIG.shatteredEndermenReleaseDragonBreath.get()).booleanValue() && this.f_20919_ == 1 && this.isShattered()) {
            if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
                this.m_5496_((SoundEvent)FTGUSoundEvents.ENDERMAN_RELEASE_BREATH.get(), 1.0f, 1.0f);
            }
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_() - 0.25, this.m_20189_());
            areaeffectcloud.m_19718_((LivingEntity)this);
            areaeffectcloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
            areaeffectcloud.m_19712_(0.5f);
            areaeffectcloud.m_19734_(200);
            areaeffectcloud.m_19738_((2.5f - areaeffectcloud.m_19743_()) / (float)areaeffectcloud.m_19748_());
            areaeffectcloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 1));
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
            this.m_5496_((SoundEvent)FTGUSoundEvents.ENDERMAN_STEP.get(), 0.15f, 1.0f);
        } else {
            super.m_7355_(pos, state);
        }
    }

    @Inject(method={"teleport(DDD)Z"}, at={@At(value="HEAD")})
    private void FTGU$captureTeleportFrom(double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        this.tpFromX = this.m_20185_();
        this.tpFromY = this.m_20186_();
        this.tpFromZ = this.m_20189_();
    }

    @Redirect(method={"teleport(DDD)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"))
    private void FTGU$replaceTeleportFromSound(Level level, Player player, double x, double y, double z, SoundEvent original, SoundSource category, float volume, float pitch) {
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
            level.m_6263_(player, this.tpFromX, this.tpFromY, this.tpFromZ, (SoundEvent)FTGUSoundEvents.ENDERMAN_TELEPORT_FROM.get(), category, volume, pitch);
        } else {
            level.m_6263_(player, x, y, z, original, category, volume, pitch);
        }
    }

    @Redirect(method={"teleport(DDD)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/EnderMan;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V"))
    private void FTGU$replaceTeleportToSound(EnderMan self, SoundEvent original, float volume, float pitch) {
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
            self.m_5496_((SoundEvent)FTGUSoundEvents.ENDERMAN_TELEPORT_TO.get(), volume, pitch);
        } else {
            self.m_5496_(original, volume, pitch);
        }
    }

    @Redirect(method={"playStareSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playLocalSound(DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V"))
    private void FTGU$suppressVanillaStare(Level level, double x, double y, double z, SoundEvent original, SoundSource src, float vol, float pitch, boolean distanceDelay) {
        if (!((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
            level.m_7785_(x, y, z, original, src, vol, pitch, distanceDelay);
        }
    }

    public void m_7822_(byte id) {
        if (id == 46 && ((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanParticles.get()).booleanValue()) {
            return;
        }
        if (id == this.TELEPORT) {
            this.teleportAnimationState.m_216977_(this.f_19797_);
            if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.endermanTeleportParticleEnabled.get()).booleanValue()) {
                if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.endermanRemodel.get()).booleanValue()) {
                    this.m_9236_().m_7106_((ParticleOptions)FTGUParticles.ENDERMAN_REMODEL_TELEPORT.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                } else {
                    this.m_9236_().m_7106_((ParticleOptions)FTGUParticles.ENDERMAN_TELEPORT.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (id == this.SPAWN) {
            this.teleportAnimationState.m_216977_(this.f_19797_);
            return;
        }
        if (id == this.SCREAM) {
            this.screamAnimationState.m_216977_(this.f_19797_);
            return;
        }
        super.m_7822_(id);
    }

    private void setupAnimationStates() {
        if (!this.m_32531_()) {
            if (this.idleAnimationTimeout == 0) {
                this.idleAnimationTimeout = 160;
                this.idleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.idleAnimationTimeout;
            }
        } else {
            this.idleAnimationState.m_216973_();
        }
        if (this.m_32531_()) {
            if (this.creepyIdleAnimationTimeout == 0) {
                this.creepyIdleAnimationTimeout = 40;
                this.creepyIdleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.creepyIdleAnimationTimeout;
            }
        } else {
            this.creepyIdleAnimationState.m_216973_();
        }
    }

    @Inject(method={"getAmbientSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void FTGU$getAmbientSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
            cir.setReturnValue((Object)(this.m_32531_() ? (SoundEvent)FTGUSoundEvents.ENDERMAN_SCREAM.get() : (SoundEvent)FTGUSoundEvents.ENDERMAN_IDLE.get()));
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void FTGU$getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
            cir.setReturnValue((Object)((SoundEvent)FTGUSoundEvents.ENDERMAN_DEATH.get()));
        }
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void FTGU$getHurtSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newEndermanSounds.get()).booleanValue()) {
            cir.setReturnValue((Object)((SoundEvent)FTGUSoundEvents.ENDERMAN_HURT.get()));
        }
    }

    @Override
    public AnimationState getIdleAnimationState() {
        return this.idleAnimationState;
    }

    @Override
    public AnimationState getCreepyIdleAnimationState() {
        return this.creepyIdleAnimationState;
    }

    @Override
    public AnimationState getTeleportAnimationState() {
        return this.teleportAnimationState;
    }

    @Override
    public AnimationState getScreamAnimationState() {
        return this.screamAnimationState;
    }

    static {
        DATA_SHATTERED = SynchedEntityData.m_135353_(EnderManMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

