/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.mixin.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.ftgu.FromTheGroundUp;
import java.awt.Color;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SkullBlockRenderer.class})
public abstract class SkullBlockRendererMixin {
    @Unique
    private static final ResourceLocation CREEPER_HEAD = new ResourceLocation("ftgu", "textures/entity/creeper/creeper_head.png");
    @Unique
    private static final ResourceLocation CREEPER_HEAD_GUNPOWDER = new ResourceLocation("ftgu", "textures/entity/creeper/creeper_head_gunpowder.png");
    @Unique
    private static final ThreadLocal<float[]> FTGU_SKULL_TINT = new ThreadLocal();
    @Unique
    private static final ThreadLocal<Boolean> FTGU_IS_CREEPER_RENDER = ThreadLocal.withInitial(() -> Boolean.FALSE);

    @Inject(method={"getRenderType"}, at={@At(value="HEAD")}, cancellable=true)
    private static void FTGU$getRenderType(SkullBlock.Type skullType, GameProfile gameProfile, CallbackInfoReturnable<RenderType> cir) {
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.creeperRemodel.get()).booleanValue() && skullType == SkullBlock.Types.CREEPER) {
            FTGU_IS_CREEPER_RENDER.set(Boolean.TRUE);
            cir.setReturnValue((Object)RenderType.m_110473_((ResourceLocation)CREEPER_HEAD));
        } else {
            FTGU_IS_CREEPER_RENDER.set(Boolean.FALSE);
        }
    }

    @Inject(method={"render*"}, at={@At(value="HEAD")})
    private void ftgu$setTint(SkullBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, CallbackInfo ci) {
        BlockState blockstate = blockEntity.m_58900_();
        SkullBlock.Type type = ((AbstractSkullBlock)blockstate.m_60734_()).m_48754_();
        if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.creeperRemodel.get()).booleanValue() && type == SkullBlock.Types.CREEPER) {
            if (blockEntity.m_58904_() == null) {
                FTGU_SKULL_TINT.remove();
                return;
            }
            BlockPos pos = blockEntity.m_58899_();
            int tintInt = blockEntity.m_58904_().m_6171_(pos, BiomeColors.f_108790_);
            Color c = new Color(tintInt);
            float[] rgb = new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f};
            FTGU_SKULL_TINT.set(rgb);
        }
    }

    @Inject(method={"render*"}, at={@At(value="RETURN")})
    private void ftgu$clearTint(SkullBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, CallbackInfo ci) {
        FTGU_SKULL_TINT.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"renderSkull"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ftgu$RenderToBuffer(Direction direction, float yRot, float mouthAnimation, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, SkullModelBase model, RenderType renderType, CallbackInfo ci) {
        if (!((Boolean)FromTheGroundUp.CLIENT_CONFIG.creeperRemodel.get()).booleanValue()) {
            return;
        }
        if (!(model instanceof SkullModel)) {
            return;
        }
        Boolean isCreeper = FTGU_IS_CREEPER_RENDER.get();
        if (isCreeper == null || !isCreeper.booleanValue()) {
            FTGU_IS_CREEPER_RENDER.remove();
            return;
        }
        float[] tint = FTGU_SKULL_TINT.get();
        float r = 0.4f;
        float g = 0.8f;
        float b = 0.3f;
        if (tint != null && tint.length >= 3) {
            r = tint[0] * 1.2f;
            g = tint[1] * 1.2f;
            b = tint[2] * 1.2f;
        }
        poseStack.m_85836_();
        try {
            if (direction == null) {
                poseStack.m_252880_(0.5f, 0.0f, 0.5f);
            } else {
                poseStack.m_252880_(0.5f - (float)direction.m_122429_() * 0.25f, 0.25f, 0.5f - (float)direction.m_122431_() * 0.25f);
            }
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            VertexConsumer baseVc = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)CREEPER_HEAD));
            model.m_6251_(mouthAnimation, yRot, 0.0f);
            model.m_7695_(poseStack, baseVc, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
            poseStack.m_85836_();
            poseStack.m_85841_(1.002f, 1.002f, 1.002f);
            VertexConsumer overlayVc = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)CREEPER_HEAD_GUNPOWDER));
            model.m_7695_(poseStack, overlayVc, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        finally {
            poseStack.m_85849_();
            FTGU_IS_CREEPER_RENDER.remove();
        }
        ci.cancel();
    }
}

