/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.server;

import net.minecraftforge.common.ForgeConfigSpec;

public class FTGUServerConfig {
    public final ForgeConfigSpec.BooleanValue endermanAllowedToPickUpAndPlaceBlocks;
    public final ForgeConfigSpec.DoubleValue endermanSpawnHoldingBlocksChance;
    public final ForgeConfigSpec.DoubleValue endermanSpawnHoldingBlocksChanceNether;
    public final ForgeConfigSpec.DoubleValue endermanSpawnHoldingBlocksChanceEnd;
    public final ForgeConfigSpec.BooleanValue shatteredEndermenReleaseDragonBreath;
    public final ForgeConfigSpec.BooleanValue shatteredEndermenDragonBreathPickable;
    public final ForgeConfigSpec.BooleanValue endermenSpawnAsShattered;
    public final ForgeConfigSpec.DoubleValue endermenFightingTeleportChance;
    public final ForgeConfigSpec.DoubleValue shatteredEndermenFightingTeleportChance;
    public final ForgeConfigSpec.BooleanValue creeperExplosionReplace;
    public final ForgeConfigSpec.IntValue creeperFallExplosionRadius;
    public final ForgeConfigSpec.IntValue creeperExplosionRadius;
    public final ForgeConfigSpec.IntValue chargedCreeperFallExplosionRadius;
    public final ForgeConfigSpec.IntValue chargedCreeperExplosionRadius;
    public final ForgeConfigSpec.BooleanValue chargedCreepersImmuneToFire;
    public final ForgeConfigSpec.BooleanValue creeperExplosionScreenShake;
    public final ForgeConfigSpec.BooleanValue canCreepersSprint;
    public final ForgeConfigSpec.BooleanValue doCreepersSneakUpOnTarget;
    public final ForgeConfigSpec.BooleanValue creepersExplodeWhenOnFire;
    public final ForgeConfigSpec.BooleanValue creeperExplosionKnockbackEntities;
    public final ForgeConfigSpec.BooleanValue creeperExplosionChainReaction;
    public final ForgeConfigSpec.BooleanValue creeperHissAndRunFromCats;
    public final ForgeConfigSpec.BooleanValue creeperOinkAtPigs;
    public final ForgeConfigSpec.BooleanValue newChargedCreeperMiniboss;

    public FTGUServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("enderman-changes");
        this.endermanAllowedToPickUpAndPlaceBlocks = builder.comment("whether Endermen can pick up and place down blocks.").translation("enderman_allowed_to_pick_up_and_place_blocks").define("enderman_allowed_to_pick_up_and_place_blocks", false);
        this.endermanSpawnHoldingBlocksChance = builder.comment("the chance of Endermen spawning with a random block. 1 is 100% chance.").defineInRange("block-spawning-chance", 0.2, 0.0, 1.0);
        this.endermanSpawnHoldingBlocksChanceNether = builder.comment("the chance of Endermen spawning with a random block in the Nether. 1 is 100% chance.").defineInRange("block-spawning-chance-nether", 0.05, 0.0, 1.0);
        this.endermanSpawnHoldingBlocksChanceEnd = builder.comment("the chance of Endermen spawning with a random block in the End. 1 is 100% chance.").defineInRange("block-spawning-chance-end", 0.001, 0.0, 1.0);
        this.shatteredEndermenReleaseDragonBreath = builder.comment("whether Shattered Endermen release Dragon Breath upon death.").translation("shattered_endermen_release_dragon_breath").define("shattered_endermen_release_dragon_breath", true);
        this.shatteredEndermenDragonBreathPickable = builder.comment("whether Dragon Breath released by Shattered Endermen can be picked up with a bottle.").translation("shattered_endermen_dragon_breath_pickable").define("shattered_endermen_dragon_breath_pickable", true);
        this.endermenSpawnAsShattered = builder.comment("whether Endermen can spawn as Shattered Endermen.").translation("endermen_spawn_as_shattered").define("endermen_spawn_as_shattered", true);
        this.endermenFightingTeleportChance = builder.comment("the additional chance Endermen have to teleport while fighting each tick. 1 is 100% chance.").defineInRange("fight-teleport-chance", 0.01, 0.0, 1.0);
        this.shatteredEndermenFightingTeleportChance = builder.comment("the additional chance Shattered Endermen have to teleport while fighting each tick. 1 is 100% chance.").defineInRange("shattered-fight-teleport-chance", 0.025, 0.0, 1.0);
        builder.pop();
        builder.push("creeper-changes");
        this.creeperExplosionReplace = builder.comment("whether Creeper explosions don't break blocks but make blocks fall.").translation("creper_explosion_replace").define("creper_explosion_replace", true);
        this.creeperFallExplosionRadius = builder.comment("The radius creeper explosions can make blocks fall if `creper_explosion_replace` is enabled.").defineInRange("creeper-fall-explosion-radius", 5, 0, 15);
        this.creeperExplosionRadius = builder.comment("The radius creeper explosions deal damage in if `creper_explosion_replace` is enabled.").defineInRange("creeper-explosion-radius", 6, 0, 15);
        this.chargedCreeperFallExplosionRadius = builder.comment("The radius charged creeper explosions can make blocks fall if `creper_explosion_replace` is enabled").defineInRange("charged-creeper-fall-explosion-radius", 8, 0, 30);
        this.chargedCreeperExplosionRadius = builder.comment("The radius charged creeper explosions deal damage in if `creper_explosion_replace` is enabled").defineInRange("charged-creeper-explosion-radius", 8, 0, 30);
        this.creeperExplosionScreenShake = builder.comment("whether Creeper explosions cause the screen to shake.").translation("creper_explosion_screen_shake").define("creper_explosion_screen_shake", true);
        this.canCreepersSprint = builder.comment("whether Creeper sprint if their target is sprinting.").translation("can_creepers_sprint").define("can_creepers_sprint", true);
        this.doCreepersSneakUpOnTarget = builder.comment("whether Creeper sneak up quietly until discovered.").translation("do_creepers_sneak_up_on_target").define("do_creepers_sneak_up_on_target", true);
        this.creepersExplodeWhenOnFire = builder.comment("whether Creeper explode when on fire.").translation("creepers_explode_when_on_fire").define("creepers_explode_when_on_fire", true);
        this.chargedCreepersImmuneToFire = builder.comment("whether Charged Creepers are immune fire.").translation("charged_creepers_immune_to_fire").define("charged_creepers_immune_to_fire", true);
        this.creeperExplosionKnockbackEntities = builder.comment("whether Creeper explosions knockback entities.").translation("creeper_explosion_knockback_entities").define("creeper_explosion_knockback_entities", true);
        this.creeperExplosionChainReaction = builder.comment("whether Creeper explosions set other Creepers off.").translation("creeper_explosion_chain_reaction").define("creeper_explosion_chain_reaction", true);
        this.creeperHissAndRunFromCats = builder.comment("whether Creeper hiss before running from cats and ocelots.").translation("creeper_hiss_and_run_from_cats").define("creeper_hiss_and_run_from_cats", true);
        this.creeperOinkAtPigs = builder.comment("whether Creeper go up to pigs and oink at them.").translation("creeper_oink_at_pigs").define("creeper_oink_at_pigs", true);
        this.newChargedCreeperMiniboss = builder.comment("whether Creepers struck by lightning summon a new Charged Creeper miniboss. This also enables Beheading Spores, a new crop dropped by the Charged Creeper that allows you to renewably get heads.").translation("charged_creeper_miniboss").define("charged_creeper_miniboss", true);
        builder.pop();
    }
}

