/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.server.entity.goal;

import com.ninni.ftgu.registry.FTGUSoundEvents;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.Vec3;

public class CreeperHissAndRunFromCatsGoal
extends Goal {
    private final Creeper creeper;
    private final double walkSpeed;
    private final double sprintSpeed;
    private final float range;
    private LivingEntity target;
    private boolean hasHissed = false;
    private Vec3 fleePos;
    private final PathNavigation nav;

    public CreeperHissAndRunFromCatsGoal(Creeper creeper, double walkSpeed, float range) {
        this.creeper = creeper;
        this.walkSpeed = walkSpeed;
        this.sprintSpeed = walkSpeed * 1.5;
        this.range = range;
        this.nav = creeper.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        List entities = this.creeper.m_9236_().m_6443_(LivingEntity.class, this.creeper.m_20191_().m_82400_((double)this.range), e -> e instanceof Cat || e instanceof Ocelot);
        if (entities.isEmpty()) {
            return false;
        }
        this.target = (LivingEntity)entities.get(0);
        this.fleePos = DefaultRandomPos.m_148407_((PathfinderMob)this.creeper, (int)16, (int)7, (Vec3)this.target.m_20182_());
        return this.fleePos != null && this.target.m_20238_(this.fleePos) > this.target.m_20280_((Entity)this.creeper);
    }

    public void m_8056_() {
        if (!this.hasHissed && this.target != null) {
            this.creeper.m_216990_((SoundEvent)FTGUSoundEvents.CREEPER_HISS.get());
            this.hasHissed = true;
        }
        this.nav.m_26519_(this.fleePos.f_82479_, this.fleePos.f_82480_, this.fleePos.f_82481_, this.walkSpeed);
    }

    public boolean m_8045_() {
        return !this.nav.m_26571_();
    }

    public void m_8037_() {
        if (this.target != null && this.creeper.m_20280_((Entity)this.target) < 49.0) {
            this.nav.m_26517_(this.sprintSpeed);
        } else {
            this.nav.m_26517_(this.walkSpeed);
        }
    }

    public void m_8041_() {
        this.target = null;
        this.hasHissed = false;
    }
}

