/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.server.entity.subentities;

import com.ninni.ftgu.registry.FTGUSoundEvents;
import com.ninni.ftgu.registry.FTGUStatusEffects;
import com.ninni.ftgu.server.entity.ChargedCreeperEntity;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class BaseSporeEntity
extends AbstractArrow {
    protected BaseSporeEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_SPORE_LAND.get();
    }

    public void explode() {
        this.playExplosionEffects();
        this.m_146870_();
    }

    protected boolean m_5603_(Entity target) {
        if (target instanceof ChargedCreeperEntity) {
            return false;
        }
        return super.m_5603_(target);
    }

    protected void playExplosionEffects() {
    }

    protected void shockwaveEntities(float pushAmount, boolean dealDamage, float baseDamage, float radius) {
        AABB pushArea = this.m_20191_().m_82400_((double)radius);
        List pushableEntities = this.m_9236_().m_45933_((Entity)this, pushArea);
        pushableEntities.removeIf(entity -> !entity.m_6094_() || entity.m_20159_() || entity instanceof ChargedCreeperEntity);
        Vec3 center = this.m_20182_();
        for (Entity entity2 : pushableEntities) {
            float damage;
            Vec3 pushDir;
            Vec3 diff = entity2.m_20182_().m_82546_(center);
            double dist = diff.m_82553_();
            if (dist <= 1.0E-6) {
                pushDir = new Vec3(this.f_19796_.m_188500_() - 0.5, 0.0, this.f_19796_.m_188500_() - 0.5).m_82541_();
                dist = 0.0;
            } else {
                pushDir = diff.m_82490_(1.0 / dist);
            }
            double falloff = Math.max(0.0, 1.0 - dist / (double)radius);
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            float kbStrength = (float)((double)pushAmount * falloff);
            living.m_147240_((double)kbStrength, -pushDir.f_82479_, -pushDir.f_82481_);
            living.m_7292_(new MobEffectInstance((MobEffect)FTGUStatusEffects.DOOMED.get(), 6000, 0));
            living.f_19864_ = true;
            if (dealDamage && (damage = (float)((double)baseDamage * falloff)) > 0.0f) {
                living.m_6469_(this.m_269291_().m_269036_((Entity)this, (Entity)this), damage);
            }
            if (!(living instanceof Creeper)) continue;
            Creeper creeper = (Creeper)living;
            creeper.m_32312_();
        }
    }
}

