/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.server.entity.subentities;

import com.ninni.ftgu.client.particle.EmberParticleOptions;
import com.ninni.ftgu.registry.FTGUEntityType;
import com.ninni.ftgu.registry.FTGUSoundEvents;
import com.ninni.ftgu.registry.FTGUStatusEffects;
import com.ninni.ftgu.server.entity.ChargedCreeperEntity;
import com.ninni.ftgu.server.entity.subentities.BaseSporeEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SporeBrambleEntity
extends BaseSporeEntity {
    private static final EntityDataAccessor<Boolean> DATA_MALEVOLENT = SynchedEntityData.m_135353_(SporeBrambleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int ambientSoundTime;

    public SporeBrambleEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public SporeBrambleEntity(Level level, Vec3 pos, @Nullable LivingEntity owner, Boolean isMalevolent) {
        this((EntityType<? extends AbstractArrow>)((EntityType)FTGUEntityType.SPORE_BRAMBLE.get()), level);
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.f_19854_ = pos.f_82479_;
        this.f_19855_ = pos.f_82480_;
        this.f_19856_ = pos.f_82481_;
        this.m_5602_((Entity)owner);
        this.setMalevolent(isMalevolent);
    }

    public boolean isMalevolent() {
        return (Boolean)this.f_19804_.m_135370_(DATA_MALEVOLENT);
    }

    public void setMalevolent(boolean evil) {
        this.f_19804_.m_135381_(DATA_MALEVOLENT, (Object)evil);
    }

    protected ItemStack m_7941_() {
        return null;
    }

    @Override
    public void playExplosionEffects() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isMalevolent()) {
                this.m_216990_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_BRAMBLE_MALEVOLENT.get());
            } else {
                this.m_216990_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_BRAMBLE_BENEVOLENT.get());
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 15, (double)0.1f, 1.0, (double)0.1f, 0.0);
            serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.SPORE, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 15, 0.0, 0.0, 0.0, 3.0);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Player nearestPlayer = this.m_9236_().m_45930_((Entity)this, 6.0);
        if (nearestPlayer != null) {
            Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.m_90377_((Entity)this);
            double d0 = nearestPlayer.m_20182_().f_82479_ - vec3.f_82479_;
            double d1 = nearestPlayer.m_20182_().f_82480_ - vec3.f_82480_;
            double d2 = nearestPlayer.m_20182_().f_82481_ - vec3.f_82481_;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float xRot = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
            float yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            this.m_146926_(Mth.m_14189_((float)0.2f, (float)this.f_19860_, (float)xRot));
            this.m_146922_(Mth.m_14189_((float)0.2f, (float)this.f_19859_, (float)yRot));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_6084_() && this.f_19796_.m_188503_(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    public int getAmbientSoundInterval() {
        return 190;
    }

    public void playAmbientSound() {
        this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_BRAMBLE_IDLE.get(), 0.7f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof ChargedCreeperEntity) {
            return;
        }
        super.m_7334_(entity);
    }

    public boolean m_6094_() {
        return this.m_6084_();
    }

    public void m_5997_(double x, double y, double z) {
        this.explode();
        super.m_5997_(x, y, z);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_MALEVOLENT, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMalevolent(compound.m_128471_("IsMalevolent"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsMalevolent", this.isMalevolent());
    }

    @Override
    public void explode() {
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        MobEffectInstance effectInstance = new MobEffectInstance(this.isMalevolent() ? MobEffects.f_19614_ : MobEffects.f_19605_, 200);
        areaeffectcloud.m_19716_(effectInstance);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0));
        for (LivingEntity living : entities) {
            if (living instanceof ChargedCreeperEntity) continue;
            living.m_7292_(new MobEffectInstance((MobEffect)FTGUStatusEffects.DOOMED.get(), 6000, 0));
            living.m_7292_(effectInstance);
        }
        areaeffectcloud.m_19712_(1.0f);
        areaeffectcloud.m_19732_(-0.5f);
        areaeffectcloud.m_19740_(10);
        areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
        areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
        if (this.isMalevolent()) {
            LightningBolt lightningbolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)this.m_20183_()));
            this.m_9236_().m_7967_((Entity)lightningbolt);
        }
        this.m_9236_().m_7967_((Entity)areaeffectcloud);
        this.playExplosionEffects();
        this.m_146870_();
    }
}

