/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.server.entity.subentities;

import com.ninni.ftgu.client.particle.EmberParticleOptions;
import com.ninni.ftgu.client.particle.SporeParticleOptions;
import com.ninni.ftgu.registry.FTGUEntityType;
import com.ninni.ftgu.registry.FTGUSoundEvents;
import com.ninni.ftgu.server.entity.ChargedCreeperEntity;
import com.ninni.ftgu.server.entity.subentities.BaseSporeEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SporeMineEntity
extends BaseSporeEntity {
    public int timeTillExplosion = 0;
    public boolean impulseExplosion = false;

    public SporeMineEntity(EntityType<? extends BaseSporeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SporeMineEntity(Level level, Vec3 pos, @Nullable LivingEntity owner) {
        this((EntityType<? extends BaseSporeEntity>)((EntityType)FTGUEntityType.SPORE_MINE.get()), level);
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.f_19854_ = pos.f_82479_;
        this.f_19855_ = pos.f_82480_;
        this.f_19856_ = pos.f_82481_;
        this.m_5602_((Entity)owner);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_5496_(SoundEvents.f_11664_, 2.0f, this.f_19796_.m_188501_() * 0.2f + 1.0f);
    }

    protected ItemStack m_7941_() {
        return null;
    }

    @Override
    public void playExplosionEffects() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_SPORE_MINE_EXPLODE.get(), 1.0f, 1.0f);
            serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.SPORE, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 15, 0.0, 0.0, 0.0, 3.0);
            serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.EMBER_1, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 10, 0.0, 0.0, 0.0, 3.0);
            serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.EMBER_2, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 10, 0.0, 0.0, 0.0, 3.0);
        }
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof ChargedCreeperEntity) {
            return;
        }
        super.m_7334_(entity);
    }

    public boolean m_6094_() {
        return this.m_6084_();
    }

    public void m_5997_(double x, double y, double z) {
        if (this.f_36703_) {
            this.impulseExplosion = false;
            this.explode();
        }
        super.m_5997_(x, y, z);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.f_19796_.m_188503_(40) == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)SporeParticleOptions.SPORE, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 3.0);
        }
        if (!this.f_36703_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.timeTillExplosion > 0) {
            --this.timeTillExplosion;
        } else if (this.impulseExplosion) {
            this.explode();
        }
    }

    @Override
    public void explode() {
        if (this.timeTillExplosion == 0) {
            super.explode();
            this.shockwaveEntities(1.0f, true, 25.0f, 4.0f);
            List entities = this.m_9236_().m_45976_(SporeMineEntity.class, this.m_20191_().m_82400_(2.0));
            for (SporeMineEntity entity : entities) {
                if (entity.m_7306_((Entity)this)) continue;
                entity.impulseExplosion = true;
                entity.timeTillExplosion = 2;
                entity.explode();
            }
        }
    }
}

