/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.events;

import com.ninni.ftgu.FromTheGroundUp;
import com.ninni.ftgu.client.gui.EndermanScreamOverlay;
import com.ninni.ftgu.client.models.ChargedCreeperModel;
import com.ninni.ftgu.client.models.CreeperRemodel;
import com.ninni.ftgu.client.models.EndermanRemodel;
import com.ninni.ftgu.client.models.SporeBrambleModel;
import com.ninni.ftgu.client.models.SporeMineModel;
import com.ninni.ftgu.client.models.SporeRocketModel;
import com.ninni.ftgu.client.particle.EmberParticle;
import com.ninni.ftgu.client.particle.EndermanRemodelTeleportParticle;
import com.ninni.ftgu.client.particle.EndermanTeleportParticle;
import com.ninni.ftgu.client.particle.ShockwaveParticle;
import com.ninni.ftgu.client.particle.SporeParticle;
import com.ninni.ftgu.client.particle.WarpParticle;
import com.ninni.ftgu.client.renderer.ChargedCreeperRenderer;
import com.ninni.ftgu.client.renderer.CreeperRerenderer;
import com.ninni.ftgu.client.renderer.EndermanRerenderer;
import com.ninni.ftgu.client.renderer.SporeBrambleRenderer;
import com.ninni.ftgu.client.renderer.SporeMineRenderer;
import com.ninni.ftgu.client.renderer.SporeRocketRenderer;
import com.ninni.ftgu.client.screen.ScreenShakeEvent;
import com.ninni.ftgu.registry.FTGUEntityModelLayers;
import com.ninni.ftgu.registry.FTGUEntityType;
import com.ninni.ftgu.registry.FTGUItems;
import com.ninni.ftgu.registry.FTGUParticles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.locating.IModFile;

@Mod.EventBusSubscriber(modid="ftgu", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    public static final List<ScreenShakeEvent> SCREEN_SHAKE_EVENTS = new ArrayList<ScreenShakeEvent>();
    private static float shakeAmount;
    private static float prevShakeAmount;

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END) {
            Entity cameraEntity = mc.m_91288_();
            prevShakeAmount = shakeAmount;
            float shake = 0.0f;
            Iterator<ScreenShakeEvent> groundShakeMomentIterator = SCREEN_SHAKE_EVENTS.iterator();
            while (groundShakeMomentIterator.hasNext()) {
                ScreenShakeEvent groundShakeMoment = groundShakeMomentIterator.next();
                groundShakeMoment.tick();
                if (groundShakeMoment.isDone()) {
                    groundShakeMomentIterator.remove();
                    continue;
                }
                shake = Math.max(shake, groundShakeMoment.getDegree(cameraEntity, 1.0f));
            }
            shakeAmount = shake * ((Double)mc.f_91066_.m_231924_().m_231551_()).floatValue();
        }
    }

    @SubscribeEvent
    public void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Minecraft mc = Minecraft.m_91087_();
        float partialTicks = (float)event.getPartialTick();
        float lerpedShakeAmount = Mth.m_14036_((float)(prevShakeAmount + (shakeAmount - prevShakeAmount) * partialTicks), (float)0.0f, (float)4.0f);
        if (lerpedShakeAmount > 0.0f) {
            float time = mc.f_91075_ == null ? 0.0f : (float)mc.f_91075_.f_19797_ + mc.getPartialTick();
            event.setRoll((float)((double)lerpedShakeAmount * Math.sin(2.0f * time)));
        }
    }

    @SubscribeEvent
    public static void registerCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = event.getTabKey();
        MutableHashedLinkedMap entries = event.getEntries();
        if (key == CreativeModeTabs.f_257028_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42162_), (Object)new ItemStack((ItemLike)FTGUItems.DISPLACER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256869_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42711_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_TERRA.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42711_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_ARIA.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42711_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_ACQUA.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42711_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_MAGMA.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42711_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_DROOP.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_186363_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_SPRINKLE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_186363_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_RIPPLE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_186363_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_GAMBLE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_186363_), (Object)new ItemStack((ItemLike)FTGUItems.MUSIC_DISC_LOBBY.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256731_ && ((Boolean)FromTheGroundUp.COMMON_CONFIG.newChargedCreeperMiniboss.get()).booleanValue()) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42551_), (Object)new ItemStack((ItemLike)FTGUItems.CHARGED_CREEPER_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256776_ && ((Boolean)FromTheGroundUp.COMMON_CONFIG.newChargedCreeperMiniboss.get()).booleanValue()) {
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42588_), (Object)new ItemStack((ItemLike)FTGUItems.BEHEADING_SPORES.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public static void registerParticleTypes(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)FTGUParticles.WARP.get(), WarpParticle.Provider::new);
        event.registerSpriteSet((ParticleType)FTGUParticles.ENDERMAN_TELEPORT.get(), EndermanTeleportParticle.Provider::new);
        event.registerSpriteSet((ParticleType)FTGUParticles.ENDERMAN_REMODEL_TELEPORT.get(), EndermanRemodelTeleportParticle.Provider::new);
        event.registerSpriteSet((ParticleType)FTGUParticles.SHOCKWAVE.get(), ShockwaveParticle.Provider::new);
        event.registerSpriteSet((ParticleType)FTGUParticles.PIXEL_PARTICLE.get(), EmberParticle.Provider::new);
        event.registerSpriteSet((ParticleType)FTGUParticles.SPORE_PARTICLE.get(), SporeParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("warped_scream", (IGuiOverlay)EndermanScreamOverlay.INSTANCE);
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer(EntityType.f_20558_, ctx -> {
            try {
                if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.creeperRemodel.get()).booleanValue()) {
                    return new CreeperRerenderer(ctx);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return new CreeperRenderer(ctx);
        });
        e.registerEntityRenderer(EntityType.f_20566_, ctx -> {
            try {
                if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.endermanRemodel.get()).booleanValue()) {
                    return new EndermanRerenderer(ctx);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return new EndermanRenderer(ctx);
        });
        e.registerEntityRenderer((EntityType)FTGUEntityType.CHARGED_CREEPER.get(), ChargedCreeperRenderer::new);
        e.registerEntityRenderer((EntityType)FTGUEntityType.SPORE_MINE.get(), SporeMineRenderer::new);
        e.registerEntityRenderer((EntityType)FTGUEntityType.SPORE_ROCKET.get(), SporeRocketRenderer::new);
        e.registerEntityRenderer((EntityType)FTGUEntityType.SPORE_BRAMBLE.get(), SporeBrambleRenderer::new);
        e.registerEntityRenderer((EntityType)FTGUEntityType.BEHEADING_SPORES.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(FTGUEntityModelLayers.WARPED_SHATTERED, EndermanRemodel::getShatteredLayerDefinition);
        event.registerLayerDefinition(FTGUEntityModelLayers.WARPED, EndermanRemodel::getLayerDefinition);
        event.registerLayerDefinition(FTGUEntityModelLayers.CREEPER, CreeperRemodel::getLayerDefinition);
        event.registerLayerDefinition(FTGUEntityModelLayers.CREEPER_CHARGE, CreeperRemodel::getChargedLayerDefinition);
        event.registerLayerDefinition(FTGUEntityModelLayers.CHARGED_CREEPER, ChargedCreeperModel::createBodyLayer);
        event.registerLayerDefinition(FTGUEntityModelLayers.CHARGED_CREEPER_CHARGE, ChargedCreeperModel::createChargeBodyLayer);
        event.registerLayerDefinition(FTGUEntityModelLayers.SPORE_MINE, SporeMineModel::createBodyLayer);
        event.registerLayerDefinition(FTGUEntityModelLayers.SPORE_ROCKET, SporeRocketModel::createBodyLayer);
        event.registerLayerDefinition(FTGUEntityModelLayers.SPORE_BRAMBLE, SporeBrambleModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void addResourcePacks(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        IModFile modFile = ModList.get().getModFileById("ftgu").getFile();
        Path path = modFile.findResource(new String[]{"resourcepacks/grounded"});
        try (PathPackResources pack = new PathPackResources(modFile.getFileName() + ":" + path, path, true);){
            event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"builtin/ftgu", (Component)Component.m_237113_((String)"Grounded"), (boolean)true, ignored -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
        }
    }
}

