/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ninni.ftgu.FromTheGroundUp;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class EndermanScreamOverlay
implements IGuiOverlay {
    public static final EndermanScreamOverlay INSTANCE = new EndermanScreamOverlay();
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("ftgu", "textures/gui/overlay/enderman_scream_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("ftgu", "textures/gui/overlay/enderman_scream_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("ftgu", "textures/gui/overlay/enderman_scream_2.png");
    private static final ResourceLocation TEXTURE_VIGNETTE = new ResourceLocation("ftgu", "textures/gui/overlay/enderman_vignette.png");
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("ftgu", "textures/gui/overlay/enderman_eyes.png");
    private float alpha = 0.0f;

    public void render(ForgeGui forgeGui, GuiGraphics gfx, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        boolean isInEnd = Minecraft.m_91087_().f_91074_.m_9236_().m_46472_().equals((Object)Level.f_46430_);
        if (mc.f_91073_ == null || mc.f_91074_ == null || mc.f_91066_.f_92062_) {
            return;
        }
        this.alpha = EndermanScreamOverlay.isLookingAtEnderman(partialTick) ? Math.min(1.0f, this.alpha + 0.005f) : Math.max(0.0f, this.alpha - 0.02f);
        if (this.alpha <= 0.01f) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        gfx.m_280246_(1.0f, 1.0f, 1.0f, this.alpha);
        int f = forgeGui.m_93079_() % 4;
        int f2 = forgeGui.m_93079_() % 4;
        float f3 = Mth.m_14031_((float)((float)forgeGui.m_93079_() / 20.0f));
        float f4 = Mth.m_14036_((float)Mth.m_14031_((float)((float)forgeGui.m_93079_() * 10.0f)), (float)0.8f, (float)1.0f);
        gfx.m_280163_(this.getTexture(f), 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        gfx.m_280246_(1.0f, 1.0f, 1.0f, this.alpha * this.alpha / 2.0f);
        gfx.m_280163_(TEXTURE_VIGNETTE, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        gfx.m_280246_(1.0f, 1.0f, 1.0f, f4 * f3 * this.alpha * this.alpha * this.alpha * this.alpha * this.alpha * this.alpha / 2.0f);
        if (!isInEnd) {
            gfx.m_280168_().m_252880_((float)f / 10.0f, (float)f2 / 10.0f, (float)f / 10.0f);
            gfx.m_280163_(TEXTURE_EYES, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
            gfx.m_280168_().m_252880_((float)(-f) / 10.0f, (float)(-f2) / 10.0f, (float)(-f) / 10.0f);
        }
        gfx.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    public ResourceLocation getTexture(int i) {
        return switch (i) {
            case 0 -> TEXTURE_0;
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            default -> TEXTURE_0;
        };
    }

    public static boolean isLookingAtEnderman(float partialTick) {
        Entity entity;
        Predicate<Entity> predicate;
        AABB search;
        Vec3 look;
        Vec3 end;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null || !((Boolean)FromTheGroundUp.CLIENT_CONFIG.endermanStareOverlay.get()).booleanValue()) {
            return false;
        }
        Vec3 start = player.m_20299_(partialTick);
        EntityHitResult ehr = ProjectileUtil.m_37287_((Entity)player, (Vec3)start, (Vec3)(end = start.m_82549_((look = player.m_20252_(partialTick)).m_82490_(64.0))), (AABB)(search = player.m_20191_().m_82369_(look.m_82490_(64.0)).m_82400_(0.5)), predicate = e -> {
            EnderMan enderMan;
            return e instanceof EnderMan && (enderMan = (EnderMan)e).m_6084_() && enderMan.m_32531_();
        }, (double)4096.0);
        if (ehr == null || !((entity = ehr.m_82443_()) instanceof EnderMan)) {
            return false;
        }
        EnderMan enderman = (EnderMan)entity;
        Vec3 toEyes = enderman.m_20299_(partialTick).m_82546_(start).m_82541_();
        if (look.m_82526_(toEyes) < 0.994) {
            return false;
        }
        Vec3 hitLoc = ehr.m_82450_();
        double eyeY = enderman.m_20299_((float)partialTick).f_82480_;
        return !(Math.abs(hitLoc.f_82480_ - eyeY) > 0.45);
    }
}

