/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.ftgu.client.models.ChargedCreeperModel;
import com.ninni.ftgu.server.entity.ChargedCreeperEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChargedCreeperGlowLayer
extends EyesLayer<ChargedCreeperEntity, ChargedCreeperModel> {
    private static final ResourceLocation EXPLODE = new ResourceLocation("ftgu", "textures/entity/charged_creeper/charged_creeper_explode.png");
    private static final ResourceLocation SUPPORT = new ResourceLocation("ftgu", "textures/entity/charged_creeper/charged_creeper_support.png");
    private static final ResourceLocation FESTIVE = new ResourceLocation("ftgu", "textures/entity/charged_creeper/charged_creeper_festive.png");
    private static final ResourceLocation ROCKET = new ResourceLocation("ftgu", "textures/entity/charged_creeper/charged_creeper_rocket.png");

    public ChargedCreeperGlowLayer(RenderLayerParent<ChargedCreeperEntity, ChargedCreeperModel> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ChargedCreeperEntity entity, float f, float g, float h, float j, float k, float l) {
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)this.getTextureLocation(entity)));
        if (entity.getHead() != ChargedCreeperEntity.ChargedCreeperAttack.NONE) {
            ((ChargedCreeperModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, ChargedCreeperGlowLayer.getAlpha(entity));
        }
    }

    private static float getAlpha(ChargedCreeperEntity entity) {
        int headTimer = entity.getHeadTimer();
        int headElapsed = 20 - headTimer;
        float headAlpha = Mth.m_14036_((float)((float)headElapsed / 20.0f), (float)0.0f, (float)1.0f);
        float attackDim = 1.0f;
        int attackTimer = entity.getAttackTimer();
        if (entity.getAttack() != ChargedCreeperEntity.ChargedCreeperAttack.NONE && attackTimer <= 20) {
            attackDim = Mth.m_14036_((float)((float)Math.max(attackTimer, 0) / 20.0f), (float)0.0f, (float)1.0f);
        }
        float alpha = Mth.m_14036_((float)(headAlpha * attackDim), (float)0.0f, (float)1.0f);
        return alpha;
    }

    protected ResourceLocation getTextureLocation(ChargedCreeperEntity entity) {
        return switch (entity.getHead()) {
            default -> throw new IncompatibleClassChangeError();
            case ChargedCreeperEntity.ChargedCreeperAttack.NONE, ChargedCreeperEntity.ChargedCreeperAttack.EXPLODE -> EXPLODE;
            case ChargedCreeperEntity.ChargedCreeperAttack.SUPPORT -> SUPPORT;
            case ChargedCreeperEntity.ChargedCreeperAttack.FESTIVE -> FESTIVE;
            case ChargedCreeperEntity.ChargedCreeperAttack.ROCKET -> ROCKET;
        };
    }

    public RenderType m_5708_() {
        return RenderType.m_110488_((ResourceLocation)EXPLODE);
    }
}

