/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.server.entity;

import com.ninni.ftgu.FromTheGroundUp;
import com.ninni.ftgu.client.particle.EmberParticleOptions;
import com.ninni.ftgu.client.particle.SporeParticleOptions;
import com.ninni.ftgu.client.screen.ScreenShakeEvent;
import com.ninni.ftgu.registry.FTGUParticles;
import com.ninni.ftgu.registry.FTGUSoundEvents;
import com.ninni.ftgu.registry.FTGUStatusEffects;
import com.ninni.ftgu.server.entity.goal.ChargedCreeperChooseAttackGoal;
import com.ninni.ftgu.server.entity.goal.ChargedCreeperPerformAttackGoal;
import com.ninni.ftgu.server.entity.subentities.SporeBrambleEntity;
import com.ninni.ftgu.server.entity.subentities.SporeMineEntity;
import com.ninni.ftgu.server.entity.subentities.SporeRocketEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChargedCreeperEntity
extends Monster
implements PowerableMob {
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TIMER = SynchedEntityData.m_135353_(ChargedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ATTACK_COOLDOWN = SynchedEntityData.m_135353_(ChargedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_ATTACK = SynchedEntityData.m_135353_(ChargedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_HEAD = SynchedEntityData.m_135353_(ChargedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DATA_HEAD_TIMER = SynchedEntityData.m_135353_(ChargedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_HEAD_ROTATION_START = SynchedEntityData.m_135353_(ChargedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_HEAD_ROTATION = SynchedEntityData.m_135353_(ChargedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_SHOT_MINES = SynchedEntityData.m_135353_(ChargedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static byte ROCKET = (byte)67;
    public static byte SUPPORT = (byte)68;
    public static byte FESTIVE = (byte)69;
    public static byte EXPLODE = (byte)70;
    public static byte STOP_ATTACK = (byte)71;
    public final AnimationState spawnAnimationState = new AnimationState();
    public final AnimationState rocketAttackAnimationState = new AnimationState();
    public final AnimationState supportAttackAnimationState = new AnimationState();
    public final AnimationState festiveAttackAnimationState = new AnimationState();
    public final AnimationState explodeAttackAnimationState = new AnimationState();

    public ChargedCreeperEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21365_ = new ChargedCreeperLookControl(this);
        this.m_21530_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.MOB_SUMMONED) {
            this.m_20124_(Pose.EMERGING);
            this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_SPAWN.get(), 3.0f, 1.0f);
            this.setAttackCooldown(140);
            this.setAttackTimer(100);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ChargedCreeperChooseAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ChargedCreeperPerformAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new ChargedCreeperRandomStrollGoal(this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new ChargedCreeperLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getAttack() == ChargedCreeperAttack.NONE) {
                if (this.f_19796_.m_188503_(10) == 0) {
                    serverLevel.m_8767_((ParticleOptions)SporeParticleOptions.SPORE, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 3.0);
                }
            } else {
                serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.SPORE, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 3.0);
            }
        }
        if (this.m_21223_() <= this.m_21233_() / 2.0f && (double)this.m_21223_() > (double)this.m_21233_() / 2.5 && this.hasShotMines()) {
            this.setShotMines(false);
        }
        if (this.getHeadTimer() == 1) {
            this.setAttack(this.getHead());
        }
        if (this.getAttackTimer() > 0) {
            this.setAttackTimer(this.getAttackTimer() - 1);
        }
        if (this.getAttackCooldown() > 0) {
            this.setAttackCooldown(this.getAttackCooldown() - 1);
        }
        if (this.getHeadTimer() > 0) {
            this.setHeadTimer(this.getHeadTimer() - 1);
        }
        if (this.getAttackTimer() == 0 && this.m_20089_() == Pose.EMERGING) {
            this.m_20124_(Pose.STANDING);
        }
        if (!this.m_9236_().f_46443_ && this.m_5448_() == null && this.getHead() != ChargedCreeperAttack.NONE) {
            this.m_9236_().m_7605_((Entity)this, STOP_ATTACK);
            this.setAttack(ChargedCreeperAttack.NONE);
            this.setHead(ChargedCreeperAttack.NONE);
        }
    }

    public boolean shouldMove() {
        return this.getAttackTimer() == 0;
    }

    public void handleAttack() {
        switch (this.getAttack()) {
            case ROCKET: {
                if (this.getAttackTimer() != 10) break;
                this.rocketAttack();
                break;
            }
            case SUPPORT: {
                if (this.getAttackTimer() == 60) {
                    this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_SPAWN_BRAMBLES.get(), 3.0f, 1.0f);
                }
                if (this.getAttackTimer() != 40) break;
                this.supportAttack();
                break;
            }
            case EXPLODE: {
                if (this.getAttackTimer() == 40) {
                    this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_FUSE.get(), 1.5f, 1.0f);
                }
                if (this.getAttackTimer() != 10) break;
                this.explodeAttack();
                break;
            }
            case FESTIVE: {
                if (this.getAttackTimer() != 50 && this.getAttackTimer() != 40 && this.getAttackTimer() != 30 && this.getAttackTimer() != 20) break;
                this.mineAttack();
            }
        }
    }

    private void supportAttack() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int radius = 15;
        int amount = 5;
        for (int i = 0; i < amount; ++i) {
            int Xoffset = this.f_19796_.m_188503_(radius * 2) - radius;
            int Zoffset = this.f_19796_.m_188503_(radius * 2) - radius;
            BlockPos pos = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.m_20183_().m_7918_(Xoffset, 0, Zoffset));
            if (!this.m_9236_().m_45933_(null, new AABB(pos)).isEmpty()) continue;
            positions.add(pos);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (BlockPos pos : positions) {
                serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.SPORE, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 15, 0.5, 0.5, 0.5, 3.0);
                SporeBrambleEntity entity = new SporeBrambleEntity(this.m_9236_(), pos.m_252807_(), (LivingEntity)this, this.f_19796_.m_188499_());
                if (!this.m_9236_().m_7967_((Entity)entity)) continue;
                entity.m_216990_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_BRAMBLE_GROW.get());
            }
        }
    }

    public void explodeAttack() {
        if (((Boolean)FromTheGroundUp.COMMON_CONFIG.creeperExplosionScreenShake.get()).booleanValue()) {
            FromTheGroundUp.PROXY.screenShake(new ScreenShakeEvent(this.m_20182_(), 80, 1.0f, 30.0f, false));
        }
        this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_EXPLODE.get(), 4.0f, 0.7f);
        double radius = 12.0;
        float baseDamage = 60.0f;
        AABB pushArea = this.m_20191_().m_82400_(radius);
        List pushableEntities = this.m_9236_().m_45933_((Entity)this, pushArea);
        pushableEntities.removeIf(entity -> !entity.m_6094_() || entity.m_20159_());
        Vec3 center = this.m_20182_();
        this.m_9236_().m_220400_((Entity)this, GameEvent.f_157812_, this.m_20182_());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)FromTheGroundUp.CLIENT_CONFIG.newCreeperExplosionParticle.get()).booleanValue()) {
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)FTGUParticles.SHOCKWAVE.get()), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.05);
                serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.SPORE, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 15, 0.0, 0.0, 0.0, 3.0);
                serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.EMBER_1, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 10, 0.0, 0.0, 0.0, 3.0);
                serverLevel.m_8767_((ParticleOptions)EmberParticleOptions.EMBER_2, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 10, 0.0, 0.0, 0.0, 3.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 3, (double)0.1f, (double)0.1f, (double)0.1f, 0.05);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 10, (double)0.1f, (double)0.1f, (double)0.1f, 0.05);
            } else {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
        for (Entity entity2 : pushableEntities) {
            LivingEntity living;
            Vec3 pushDir;
            Vec3 diff = entity2.m_20182_().m_82546_(center);
            double dist = diff.m_82553_();
            if (dist <= 1.0E-6) {
                pushDir = new Vec3(this.f_19796_.m_188500_() - 0.5, 0.0, this.f_19796_.m_188500_() - 0.5).m_82541_();
                dist = 0.0;
            } else {
                pushDir = diff.m_82490_(1.0 / dist);
            }
            double falloff = Math.max(0.0, 1.0 - dist / radius);
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_7306_((Entity)this)) {
                float kbStrength = (float)(2.0 * (falloff + 0.5));
                living.m_5997_(pushDir.f_82479_ * (double)kbStrength, 0.1 * (double)kbStrength, pushDir.f_82481_ * (double)kbStrength);
                living.m_7292_(new MobEffectInstance((MobEffect)FTGUStatusEffects.DOOMED.get(), 6000, 0));
                living.f_19864_ = true;
                float damage = (float)((double)baseDamage * falloff);
                if (damage > 0.0f) {
                    living.m_6469_(this.m_269291_().m_269036_((Entity)this, (Entity)this), damage);
                }
            }
            if (!((Boolean)FromTheGroundUp.COMMON_CONFIG.creeperExplosionChainReaction.get()).booleanValue() || !(entity2 instanceof Creeper)) continue;
            Creeper creeper = (Creeper)entity2;
            creeper.m_32312_();
        }
    }

    public void rocketAttack() {
        this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_SHOOT_ROCKET.get(), 3.0f, 1.0f);
        SporeRocketEntity rocket = new SporeRocketEntity(this.m_9236_(), this.m_20182_().m_82520_(0.0, 2.5, 0.0), (LivingEntity)this);
        if (this.m_9236_().m_7967_((Entity)rocket)) {
            rocket.m_20334_((this.m_5448_().m_20182_().f_82479_ - rocket.m_20182_().f_82479_) / 40.0, 1.0, (this.m_5448_().m_20182_().f_82481_ - rocket.m_20182_().f_82481_) / 40.0);
        }
    }

    public void mineAttack() {
        this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_SHOOT_MINES.get(), 3.0f, 1.0f);
        for (int i = 0; i < 6; ++i) {
            SporeMineEntity mine = new SporeMineEntity(this.m_9236_(), this.m_146892_().m_82492_(0.0, 1.0, 0.0), (LivingEntity)this);
            if (!this.m_9236_().m_7967_((Entity)mine)) continue;
            float v = this.m_20270_((Entity)this.m_5448_()) * 0.03f;
            mine.m_20334_(this.f_19796_.m_188583_() * (double)v, 0.75, this.f_19796_.m_188583_() * (double)v);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_269533_(DamageTypeTags.f_268738_) && this.getAttackTimer() > 20) {
            this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_SHIELD.get(), 1.0f, 1.0f);
            return false;
        }
        return !source.m_276093_(DamageTypes.f_268450_) && super.m_6469_(source, amount);
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.shouldMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            travelVector = travelVector.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(travelVector);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ATTACK_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_ATTACK_COOLDOWN, (Object)40);
        this.f_19804_.m_135372_(DATA_ATTACK, (Object)ChargedCreeperAttack.NONE.m_7912_());
        this.f_19804_.m_135372_(DATA_HEAD, (Object)ChargedCreeperAttack.NONE.m_7912_());
        this.f_19804_.m_135372_(DATA_HEAD_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_HEAD_ROTATION_START, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_HEAD_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_SHOT_MINES, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.setAttackTimer(compound.m_128451_("AttackTimer"));
        this.setAttackCooldown(compound.m_128451_("AttackCooldown"));
        this.setAttack((ChargedCreeperAttack)ChargedCreeperAttack.CODEC.m_262792_(compound.m_128461_("Attack"), (Enum)ChargedCreeperAttack.NONE));
        this.setHeadTimer(compound.m_128451_("HeadTimer"));
        this.setHead((ChargedCreeperAttack)ChargedCreeperAttack.CODEC.m_262792_(compound.m_128461_("Head"), (Enum)ChargedCreeperAttack.NONE));
        this.setHeadRotation(compound.m_128457_("HeadRotation"));
        this.setHeadRotationStart(compound.m_128457_("HeadRotationStart"));
        this.setShotMines(compound.m_128471_("ShotMines"));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        compound.m_128405_("AttackTimer", this.getAttackTimer());
        compound.m_128405_("AttackCooldown", this.getAttackCooldown());
        compound.m_128359_("Attack", this.getAttack().m_7912_());
        compound.m_128405_("HeadTimer", this.getHeadTimer());
        compound.m_128359_("Head", this.getHead().m_7912_());
        compound.m_128350_("HeadRotation", this.getHeadRotation());
        compound.m_128350_("HeadRotationStart", this.getHeadRotationStart());
        compound.m_128379_("ShotMines", this.hasShotMines());
    }

    public boolean hasShotMines() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHOT_MINES);
    }

    public void setShotMines(boolean b) {
        this.f_19804_.m_135381_(DATA_SHOT_MINES, (Object)b);
    }

    public float getHeadRotation() {
        return ((Float)this.f_19804_.m_135370_(DATA_HEAD_ROTATION)).floatValue();
    }

    public void setHeadRotation(float rotation) {
        this.f_19804_.m_135381_(DATA_HEAD_ROTATION, (Object)Float.valueOf(rotation));
    }

    public float getHeadRotationStart() {
        return ((Float)this.f_19804_.m_135370_(DATA_HEAD_ROTATION_START)).floatValue();
    }

    public void setHeadRotationStart(float rotation) {
        this.f_19804_.m_135381_(DATA_HEAD_ROTATION_START, (Object)Float.valueOf(rotation));
    }

    public int getAttackTimer() {
        return (Integer)this.f_19804_.m_135370_(DATA_ATTACK_TIMER);
    }

    public void setAttackTimer(int timer) {
        this.f_19804_.m_135381_(DATA_ATTACK_TIMER, (Object)timer);
    }

    public int getAttackCooldown() {
        return (Integer)this.f_19804_.m_135370_(DATA_ATTACK_COOLDOWN);
    }

    public void setAttackCooldown(int cooldown) {
        this.f_19804_.m_135381_(DATA_ATTACK_COOLDOWN, (Object)cooldown);
    }

    public ChargedCreeperAttack getAttack() {
        return (ChargedCreeperAttack)ChargedCreeperAttack.CODEC.m_262792_((String)this.f_19804_.m_135370_(DATA_ATTACK), (Enum)ChargedCreeperAttack.NONE);
    }

    public void setAttack(ChargedCreeperAttack creeperAttack) {
        if (creeperAttack != ChargedCreeperAttack.NONE) {
            this.setAttackTimer(creeperAttack.timer);
            this.m_9236_().m_7605_((Entity)this, creeperAttack.getId());
        }
        this.f_19804_.m_135381_(DATA_ATTACK, (Object)creeperAttack.m_7912_());
    }

    public int getHeadTimer() {
        return (Integer)this.f_19804_.m_135370_(DATA_HEAD_TIMER);
    }

    public void setHeadTimer(int timer) {
        this.f_19804_.m_135381_(DATA_HEAD_TIMER, (Object)timer);
    }

    public ChargedCreeperAttack getHead() {
        return (ChargedCreeperAttack)ChargedCreeperAttack.CODEC.m_262792_((String)this.f_19804_.m_135370_(DATA_HEAD), (Enum)ChargedCreeperAttack.NONE);
    }

    public void setHead(ChargedCreeperAttack creeperAttack) {
        if (creeperAttack != ChargedCreeperAttack.NONE && creeperAttack != this.getHead()) {
            this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_ROTATE_HEAD.get(), 1.5f, 1.0f);
        }
        this.setHeadRotationStart(this.getHeadRotation());
        this.setHeadRotation(creeperAttack.headRotation);
        this.setHeadTimer(40);
        this.f_19804_.m_135381_(DATA_HEAD, (Object)creeperAttack.m_7912_());
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (f_19806_.equals(key)) {
            if (this.m_20089_() == Pose.EMERGING) {
                this.spawnAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == Pose.STANDING) {
                this.spawnAnimationState.m_216973_();
            }
        }
        super.m_7350_(key);
    }

    public void m_7822_(byte id) {
        if (id == ROCKET) {
            this.rocketAttackAnimationState.m_216977_(this.f_19797_);
            return;
        }
        if (id == SUPPORT) {
            this.supportAttackAnimationState.m_216977_(this.f_19797_);
            return;
        }
        if (id == FESTIVE) {
            this.festiveAttackAnimationState.m_216977_(this.f_19797_);
            return;
        }
        if (id == EXPLODE) {
            this.explodeAttackAnimationState.m_216977_(this.f_19797_);
            return;
        }
        if (id == STOP_ATTACK) {
            this.rocketAttackAnimationState.m_216973_();
            this.supportAttackAnimationState.m_216973_();
            this.festiveAttackAnimationState.m_216973_();
            this.explodeAttackAnimationState.m_216973_();
            return;
        }
        super.m_7822_(id);
    }

    public boolean m_6094_() {
        return this.shouldMove() && super.m_6094_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        if (packet.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    public boolean m_7090_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_IDLE.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_STEP.get(), 0.5f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FTGUSoundEvents.CHARGED_CREEPER_HURT.get();
    }

    public static class ChargedCreeperLookControl
    extends LookControl {
        public ChargedCreeperEntity creeper;

        public ChargedCreeperLookControl(ChargedCreeperEntity creeper) {
            super((Mob)creeper);
            this.creeper = creeper;
        }

        public void m_8128_() {
            if (this.creeper.m_5448_() != null) {
                this.m_148051_((Entity)this.creeper.m_5448_());
            }
            super.m_8128_();
        }
    }

    public static class ChargedCreeperRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public ChargedCreeperEntity creeper;

        public ChargedCreeperRandomStrollGoal(ChargedCreeperEntity creeper, double speedModifier) {
            super((PathfinderMob)creeper, speedModifier);
            this.creeper = creeper;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.creeper.m_5448_() == null;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.creeper.m_5448_() == null;
        }
    }

    public static class ChargedCreeperLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public ChargedCreeperEntity creeper;

        public ChargedCreeperLookAtPlayerGoal(ChargedCreeperEntity creeper, Class<? extends LivingEntity> lookAtType, float lookDistance) {
            super((Mob)creeper, lookAtType, lookDistance);
            this.creeper = creeper;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.creeper.m_5448_() == null;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.creeper.m_5448_() == null;
        }
    }

    public static enum ChargedCreeperAttack implements StringRepresentable
    {
        NONE("none", 0, 0.0f, 0),
        EXPLODE("explode", EXPLODE, 0.0f, 41),
        SUPPORT("support", SUPPORT, (float)Math.PI, 61),
        FESTIVE("festive", FESTIVE, 1.5707964f, 71),
        ROCKET("rocket", ROCKET, -1.5707964f, 41);

        final String name;
        final byte id;
        final float headRotation;
        final int timer;
        public static final StringRepresentable.EnumCodec<ChargedCreeperAttack> CODEC;

        private ChargedCreeperAttack(String name, byte id, float headRotation, int timer) {
            this.name = name;
            this.id = id;
            this.headRotation = headRotation;
            this.timer = timer;
        }

        public byte getId() {
            return this.id;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(ChargedCreeperAttack::values);
        }
    }
}

