/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.server.events;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.ninni.ftgu.registry.FTGUStatusEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ftgu")
public class ForgeEvents {
    private static final ThreadLocal<Boolean> SIMULATING = ThreadLocal.withInitial(() -> Boolean.FALSE);

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity victim = event.getEntity();
        if (!victim.m_21023_((MobEffect)FTGUStatusEffects.DOOMED.get())) {
            return;
        }
        if (!(victim instanceof Player)) {
            return;
        }
        Player player = (Player)victim;
        ItemStack head = new ItemStack((ItemLike)Items.f_42680_);
        CompoundTag skullOwner = ForgeEvents.getCompoundTag(player);
        head.m_41784_().m_128365_("SkullOwner", (Tag)skullOwner);
        ItemEntity itemEntity = new ItemEntity(victim.m_9236_(), victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), head);
        event.getDrops().add(itemEntity);
    }

    private static CompoundTag getCompoundTag(Player player) {
        PropertyMap props;
        GameProfile profile = player.m_36316_();
        CompoundTag skullOwner = new CompoundTag();
        if (profile.getId() != null) {
            skullOwner.m_128362_("Id", profile.getId());
        }
        if (profile.getName() != null) {
            skullOwner.m_128359_("Name", profile.getName());
        }
        if ((props = profile.getProperties()) != null && !props.isEmpty()) {
            CompoundTag propsTag = new CompoundTag();
            ListTag texturesList = new ListTag();
            for (Property prop : props.get((Object)"textures")) {
                CompoundTag ptag = new CompoundTag();
                ptag.m_128359_("Value", prop.getValue());
                if (prop.getSignature() != null) {
                    ptag.m_128359_("Signature", prop.getSignature());
                }
                texturesList.add((Object)ptag);
            }
            if (!texturesList.isEmpty()) {
                propsTag.m_128365_("textures", (Tag)texturesList);
            }
            if (!propsTag.m_128456_()) {
                skullOwner.m_128365_("Properties", (Tag)propsTag);
            }
        }
        return skullOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        float health;
        LivingEntity victim = event.getEntity();
        if (victim == null || victim instanceof WitherSkeleton || victim instanceof Player) {
            return;
        }
        Level level = victim.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!victim.m_21023_((MobEffect)FTGUStatusEffects.DOOMED.get())) {
            return;
        }
        if (Boolean.TRUE.equals(SIMULATING.get())) {
            return;
        }
        float incoming = event.getAmount();
        if (incoming < (health = victim.m_21223_())) {
            return;
        }
        try {
            SIMULATING.set(Boolean.TRUE);
            Creeper fakeCreeper = (Creeper)EntityType.f_20558_.m_20615_((Level)serverLevel);
            if (fakeCreeper == null) {
                return;
            }
            fakeCreeper.m_6034_(victim.m_20185_(), victim.m_20186_(), victim.m_20189_());
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("powered", true);
            fakeCreeper.m_20258_(nbt);
            DamageSource fakeExplosionSource = fakeCreeper.m_269291_().m_269036_((Entity)fakeCreeper, (Entity)fakeCreeper);
            event.setCanceled(true);
            victim.m_6469_(fakeExplosionSource, incoming * 2.0f);
        }
        finally {
            SIMULATING.remove();
        }
    }
}

