/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.events;

import com.ninni.ftgu.client.gui.EndermanScreamOverlay;
import com.ninni.ftgu.client.models.EndermanRemodel;
import com.ninni.ftgu.client.particle.EndermanRemodelTeleportParticle;
import com.ninni.ftgu.client.particle.EndermanTeleportParticle;
import com.ninni.ftgu.client.particle.WarpParticle;
import com.ninni.ftgu.client.renderer.TogglingEndermanRenderer;
import com.ninni.ftgu.registry.FTGUEntityModelLayers;
import com.ninni.ftgu.registry.FTGUItems;
import com.ninni.ftgu.registry.FTGUParticles;
import java.nio.file.Path;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.locating.IModFile;

@Mod.EventBusSubscriber(modid="ftgu", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    public static void registerCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = event.getTabKey();
        MutableHashedLinkedMap entries = event.getEntries();
        if (key == CreativeModeTabs.f_257028_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42162_), (Object)new ItemStack((ItemLike)FTGUItems.DISPLACER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public static void registerParticleTypes(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)FTGUParticles.WARP.get(), WarpParticle.Provider::new);
        event.registerSpriteSet((ParticleType)FTGUParticles.ENDERMAN_TELEPORT.get(), EndermanTeleportParticle.Provider::new);
        event.registerSpriteSet((ParticleType)FTGUParticles.ENDERMAN_REMODEL_TELEPORT.get(), EndermanRemodelTeleportParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("warped_scream", (IGuiOverlay)EndermanScreamOverlay.INSTANCE);
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer(EntityType.f_20566_, TogglingEndermanRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(FTGUEntityModelLayers.WARPED_SHATTERED, EndermanRemodel::getShatteredLayerDefinition);
        event.registerLayerDefinition(FTGUEntityModelLayers.WARPED, EndermanRemodel::getLayerDefinition);
    }

    @SubscribeEvent
    public static void addResourcePacks(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        IModFile modFile = ModList.get().getModFileById("ftgu").getFile();
        Path path = modFile.findResource(new String[]{"resourcepacks/grounded"});
        try (PathPackResources pack = new PathPackResources(modFile.getFileName() + ":" + path, path, true);){
            event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"builtin/ftgu", (Component)Component.m_237113_((String)"Grounded"), (boolean)true, ignored -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
        }
    }
}

