/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.client.models;

import com.ninni.ftgu.client.models.animations.EndermanReanimations;
import com.ninni.ftgu.client.models.animations.ShatteredEndermanAnimations;
import com.ninni.ftgu.server.entity.accessor.EnderManAccessor;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.monster.EnderMan;

public class EndermanRemodel
extends HierarchicalModel<EnderMan> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart mouthScreaming;
    private final ModelPart headCube;
    private final ModelPart upperBody;
    private final ModelPart upperBodyCube;
    private final ModelPart lowerBody;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public EndermanRemodel(ModelPart root) {
        this.root = root;
        this.all = root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.mouth = this.head.m_171324_("mouth");
        this.mouthScreaming = this.head.m_171324_("mouthScreaming");
        this.headCube = this.head.m_171324_("headCube");
        this.upperBody = this.body.m_171324_("upperBody");
        this.upperBodyCube = this.upperBody.m_171324_("upperBodyCube");
        this.lowerBody = this.body.m_171324_("lowerBody");
        this.rightArm = this.body.m_171324_("rightArm");
        this.leftArm = this.body.m_171324_("leftArm");
        this.leftLeg = this.all.m_171324_("leftLeg");
        this.rightLeg = this.all.m_171324_("rightLeg");
    }

    public void setupAnim(EnderMan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float pi = (float)Math.PI;
        float degToRad = pi / 180.0f;
        this.head.f_104203_ = headPitch * degToRad;
        this.head.f_104204_ = headYaw * degToRad;
        this.mouthScreaming.f_104207_ = entity.m_32531_();
        boolean bl = this.mouth.f_104207_ = !entity.m_32531_();
        if (entity instanceof EnderManAccessor) {
            EnderManAccessor accessor = (EnderManAccessor)entity;
            if (accessor.isShattered()) {
                this.m_233385_(accessor.getIdleAnimationState(), ShatteredEndermanAnimations.IDLE, ageInTicks, 1.0f);
                this.m_233385_(accessor.getCreepyIdleAnimationState(), ShatteredEndermanAnimations.CREEPY_IDLE, ageInTicks, 1.0f);
                this.m_233385_(accessor.getScreamAnimationState(), ShatteredEndermanAnimations.SCREAM, ageInTicks, 1.0f);
                this.m_233385_(accessor.getTeleportAnimationState(), ShatteredEndermanAnimations.TELEPORT, ageInTicks, 1.0f);
                if (!entity.m_32531_()) {
                    this.m_267799_(ShatteredEndermanAnimations.WALK, limbSwing, limbSwingAmount, 2.0f, 8.0f);
                } else {
                    this.m_267799_(ShatteredEndermanAnimations.RUN, limbSwing, limbSwingAmount, 3.0f, 8.0f);
                }
                this.leftArm.f_104207_ = entity.m_32530_() != null;
            } else {
                this.m_233385_(accessor.getIdleAnimationState(), EndermanReanimations.IDLE, ageInTicks, 1.0f);
                this.m_233385_(accessor.getCreepyIdleAnimationState(), EndermanReanimations.CREEPY_IDLE, ageInTicks, 1.0f);
                this.m_233385_(accessor.getScreamAnimationState(), EndermanReanimations.SCREAM, ageInTicks, 1.0f);
                this.m_233385_(accessor.getTeleportAnimationState(), EndermanReanimations.TELEPORT, ageInTicks, 1.0f);
                if (!entity.m_32531_()) {
                    this.m_267799_(EndermanReanimations.WALK, limbSwing, limbSwingAmount, 2.0f, 8.0f);
                } else {
                    this.m_267799_(EndermanReanimations.RUN, limbSwing, limbSwingAmount, 3.0f, 8.0f);
                }
            }
            if (entity.m_32530_() != null) {
                this.leftArm.f_104203_ = -0.4f;
                this.leftArm.f_104205_ = 0.0f;
                this.leftArm.f_104204_ = 0.0f;
                this.rightArm.f_104203_ = -0.4f;
                this.rightArm.f_104205_ = 0.0f;
                this.rightArm.f_104204_ = 0.0f;
            }
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)-29.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -9.0f, -4.5f, 4.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-13.0f, (float)0.0f));
        PartDefinition mouth = head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-4.5f, 0.0f, -4.5f, 9.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition mouthScreaming = head.m_171599_("mouthScreaming", CubeListBuilder.m_171558_().m_171514_(26, 30).m_171488_(-4.5f, 0.0f, -4.5f, 9.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition headCube = head.m_171599_("headCube", CubeListBuilder.m_171558_().m_171514_(7, 45).m_171488_(-2.5f, -2.5f, -4.5f, 5.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-6.5f, (float)0.0f));
        PartDefinition upperBody = body.m_171599_("upperBody", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition upperBodyCube = upperBody.m_171599_("upperBodyCube", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-6.5f, (float)0.0f));
        PartDefinition lowerBody = body.m_171599_("lowerBody", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-4.0f, -13.0f, -2.0f, 9.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 28.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 28.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leftLeg = all.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 28.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.5f, (float)-28.0f, (float)0.0f));
        PartDefinition rightLeg = all.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 28.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)-28.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition getShatteredLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)-29.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -9.0f, -4.5f, 4.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition mouth = head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-4.5f, 0.0f, -4.5f, 9.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition mouthScreaming = head.m_171599_("mouthScreaming", CubeListBuilder.m_171558_().m_171514_(28, 30).m_171488_(-4.5f, 0.0f, -4.5f, 9.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition headCube = head.m_171599_("headCube", CubeListBuilder.m_171558_().m_171514_(26, 4).m_171488_(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-7.5f, (float)0.0f));
        PartDefinition upperBody = body.m_171599_("upperBody", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-4.5f, -3.0f, -2.0f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 27).m_171488_(-4.5f, -8.0f, -2.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition upperBodyCube = upperBody.m_171599_("upperBodyCube", CubeListBuilder.m_171558_().m_171514_(18, 27).m_171488_(-2.5f, -2.5f, -2.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-6.5f, (float)0.0f));
        PartDefinition lowerBody = body.m_171599_("lowerBody", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(0.5f, -6.0f, -2.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 50).m_171488_(-4.5f, -3.0f, -2.0f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 28.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.5f, (float)-13.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(40, 20).m_171480_().m_171488_(-1.0f, 20.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)7.5f, (float)-14.0f, (float)0.0f));
        PartDefinition leftLeg = all.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 28.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-28.0f, (float)0.0f));
        PartDefinition rightLeg = all.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 28.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-28.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart getLeftArm() {
        return this.leftArm;
    }

    public ModelPart getBody() {
        return this.body;
    }
}

