/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.ftgu.server;

import net.minecraftforge.common.ForgeConfigSpec;

public class FTGUServerConfig {
    public final ForgeConfigSpec.BooleanValue endermanAllowedToPickUpAndPlaceBlocks;
    public final ForgeConfigSpec.DoubleValue endermanSpawnHoldingBlocksChance;
    public final ForgeConfigSpec.DoubleValue endermanSpawnHoldingBlocksChanceNether;
    public final ForgeConfigSpec.DoubleValue endermanSpawnHoldingBlocksChanceEnd;
    public final ForgeConfigSpec.BooleanValue shatteredEndermenReleaseDragonBreath;
    public final ForgeConfigSpec.BooleanValue shatteredEndermenDragonBreathPickable;
    public final ForgeConfigSpec.BooleanValue endermenSpawnAsShattered;
    public final ForgeConfigSpec.DoubleValue endermenFightingTeleportChance;
    public final ForgeConfigSpec.DoubleValue shatteredEndermenFightingTeleportChance;

    public FTGUServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("enderman-changes");
        this.endermanAllowedToPickUpAndPlaceBlocks = builder.comment("whether Endermen can pick up and place down blocks.").translation("enderman_allowed_to_pick_up_and_place_blocks").define("enderman_allowed_to_pick_up_and_place_blocks", false);
        this.endermanSpawnHoldingBlocksChance = builder.comment("the chance of Endermen spawning with a random block. 1 is 100% chance.").defineInRange("block-spawning-chance", 0.2, 0.0, 1.0);
        this.endermanSpawnHoldingBlocksChanceNether = builder.comment("the chance of Endermen spawning with a random block in the Nether. 1 is 100% chance.").defineInRange("block-spawning-chance-nether", 0.05, 0.0, 1.0);
        this.endermanSpawnHoldingBlocksChanceEnd = builder.comment("the chance of Endermen spawning with a random block in the End. 1 is 100% chance.").defineInRange("block-spawning-chance-end", 0.001, 0.0, 1.0);
        this.shatteredEndermenReleaseDragonBreath = builder.comment("whether Shattered Endermen release Dragon Breath upon death.").translation("shattered_endermen_release_dragon_breath").define("shattered_endermen_release_dragon_breath", true);
        this.shatteredEndermenDragonBreathPickable = builder.comment("whether Dragon Breath released by Shattered Endermen can be picked up with a bottle.").translation("shattered_endermen_dragon_breath_pickable").define("shattered_endermen_dragon_breath_pickable", true);
        this.endermenSpawnAsShattered = builder.comment("whether Endermen can spawn as Shattered Endermen.").translation("endermen_spawn_as_shattered").define("endermen_spawn_as_shattered", true);
        this.endermenFightingTeleportChance = builder.comment("the additional chance Endermen have to teleport while fighting each tick. 1 is 100% chance.").defineInRange("fight-teleport-chance", 0.01, 0.0, 1.0);
        this.shatteredEndermenFightingTeleportChance = builder.comment("the additional chance Shattered Endermen have to teleport while fighting each tick. 1 is 100% chance.").defineInRange("shattered-fight-teleport-chance", 0.025, 0.0, 1.0);
        builder.pop();
    }
}

