/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.command.admin;

import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.core.MonsterScoreboardTag;
import cn.handyplus.monster.lib.command.IHandyCommandEvent;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.util.AssertUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.lib.util.RgbTextUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class LookCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "look";
    }

    @Override
    public String permission() {
        return "monsterPlus.look";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            this.look(sender);
            return;
        }
        String type = args[1];
        switch (type.toLowerCase()) {
            case "tp": {
                AssertUtil.notTrue(args.length < 3, BaseUtil.getLangMsg("paramFailureMsg"));
                this.tp(sender, args[2]);
                break;
            }
            case "remove": {
                AssertUtil.notTrue(args.length < 3, BaseUtil.getLangMsg("paramFailureMsg"));
                this.remove(sender, args[2], args[3]);
                break;
            }
            case "view": {
                AssertUtil.notTrue(args.length < 3, BaseUtil.getLangMsg("paramFailureMsg"));
                this.view(sender, args[2]);
                break;
            }
            case "removebykey": {
                AssertUtil.notTrue(args.length < 3, BaseUtil.getLangMsg("paramFailureMsg"));
                this.removeByKey(sender, args[2]);
                break;
            }
            case "removeall": {
                LookCommand.removeAll();
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("lookRemoveMonster"));
                break;
            }
            case "clear": {
                LookCommand.removeByWorld(sender);
                break;
            }
        }
    }

    private void look(CommandSender sender) {
        Map<String, List<UUID>> monsterEntityMap = MonsterPlusConstants.MONSTER_ENTITY_MAP;
        if (monsterEntityMap.isEmpty()) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("lookNoMonster"));
            return;
        }
        if ((monsterEntityMap = monsterEntityMap.entrySet().stream().filter(s -> CollUtil.isNotEmpty((Collection)s.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("lookNoMonster"));
            return;
        }
        int number = 0;
        for (String key : monsterEntityMap.keySet()) {
            number += monsterEntityMap.get(key).size();
        }
        RgbTextUtil rgbTextUtil = RgbTextUtil.getInstance().init("&7========================\n");
        rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(BaseUtil.getLangMsg("lookHaveMonster").replace("${number}", number + "")).build());
        rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(" &8[&c\u3128&8] ").addClickCommand("/mp look removeall 1").build());
        for (String mapKey : monsterEntityMap.keySet()) {
            List<UUID> uuids = monsterEntityMap.get(mapKey);
            rgbTextUtil.addExtra(RgbTextUtil.getInstance().init("\n&7" + mapKey + ": &f" + uuids.size()).build());
            rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(" &8[&aSEE&8] ").addClickCommand("/mp look view " + mapKey).build());
            rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(" &8[&c\u3128&8] ").addClickCommand("/mp look removebykey " + mapKey).build());
        }
        rgbTextUtil.addExtra(RgbTextUtil.getInstance().init("\n&7========================").build());
        if (sender instanceof Player) {
            MessageUtil.sendMessage((Player)sender, rgbTextUtil.build());
        } else {
            MessageUtil.sendMessage(sender, rgbTextUtil.toString());
        }
    }

    private void view(CommandSender sender, String mapKey) {
        List<UUID> uuids = MonsterPlusConstants.MONSTER_ENTITY_MAP.get(mapKey);
        if (CollUtil.isEmpty(uuids)) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("lookNoMonster"));
            return;
        }
        RgbTextUtil rgbTextUtil = RgbTextUtil.getInstance().init("&7========================\n");
        rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(BaseUtil.getLangMsg("lookHaveMonster").replace("${number}", uuids.size() + "")).build());
        for (UUID uuid : uuids) {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null) continue;
            RgbTextUtil childText = RgbTextUtil.getInstance().init("\n" + entity.getCustomName());
            childText.addExtra(RgbTextUtil.getInstance().init(" &8[&aTP&8] ").addClickCommand("/mp look tp " + uuid).build());
            childText.addExtra(RgbTextUtil.getInstance().init(" &8[&c\u3128&8] ").addClickCommand("/mp look remove " + mapKey + " " + uuid).build());
            rgbTextUtil.addExtra(childText.build());
        }
        rgbTextUtil.addExtra(RgbTextUtil.getInstance().init("\n&7========================").build());
        if (sender instanceof Player) {
            MessageUtil.sendMessage((Player)sender, rgbTextUtil.build());
        } else {
            MessageUtil.sendMessage(sender, rgbTextUtil.toString());
        }
    }

    private void tp(CommandSender sender, String uuid) {
        Entity entity = Bukkit.getEntity((UUID)UUID.fromString(uuid));
        if (entity == null) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("lookRemoveMonster"));
            return;
        }
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        player.teleport(entity.getLocation());
        MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("lookTpMonster"));
    }

    private void remove(CommandSender sender, String mapKey, String uuidStr) {
        List<UUID> uuids = MonsterPlusConstants.MONSTER_ENTITY_MAP.get(mapKey);
        Iterator<UUID> it = uuids.iterator();
        while (it.hasNext()) {
            UUID uuid = it.next();
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null || !entity.isValid() || !uuid.toString().equals(uuidStr)) continue;
            entity.remove();
            it.remove();
        }
        MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("lookRemoveMonster"));
    }

    private void removeByKey(CommandSender sender, String mapKey) {
        List<UUID> uuids = MonsterPlusConstants.MONSTER_ENTITY_MAP.get(mapKey);
        for (UUID uuid : uuids) {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null || !entity.isValid()) continue;
            entity.remove();
        }
        MonsterPlusConstants.MONSTER_ENTITY_MAP.remove(mapKey);
        MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("lookRemoveMonster"));
    }

    public static void removeAll() {
        for (String mapKey : MonsterPlusConstants.MONSTER_ENTITY_MAP.keySet()) {
            List<UUID> uuids = MonsterPlusConstants.MONSTER_ENTITY_MAP.get(mapKey);
            for (UUID uuid : uuids) {
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null || !entity.isValid()) continue;
                entity.remove();
            }
        }
        MonsterPlusConstants.MONSTER_ENTITY_MAP.clear();
    }

    private static void removeByWorld(CommandSender sender) {
        List worlds = Bukkit.getWorlds();
        for (World world : worlds) {
            List entities = world.getEntities();
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity) || !MonsterScoreboardTag.isMonsterPlus((LivingEntity)entity)) continue;
                entity.remove();
            }
        }
        MonsterPlusConstants.MONSTER_ENTITY_MAP.clear();
        MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("lookRemoveMonster"));
    }
}

