/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.command.admin;

import cn.handyplus.monster.constants.MonsterTypeEnum;
import cn.handyplus.monster.lib.command.IHandyCommandEvent;
import cn.handyplus.monster.lib.util.AssertUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.util.MonsterPlusUtil;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpawnCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "spawn";
    }

    @Override
    public String permission() {
        return "monsterPlus.spawn";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, BaseUtil.getLangMsg("paramFailureMsg"));
        AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        Player player = (Player)sender;
        Optional<MonsterTypeEnum> monsterTypeEnumOptional = MonsterTypeEnum.getEnum(args[1]);
        if (!monsterTypeEnumOptional.isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("typeFailureMsg").replace("${type}", args[1]));
            return;
        }
        MonsterTypeEnum monsterTypeEnum = monsterTypeEnumOptional.get();
        Integer number = 1;
        if (args.length > 2) {
            number = AssertUtil.isNumericToInt(args[2], BaseUtil.getLangMsg("amountFailureMsg"));
        }
        for (int i = 0; i < number; ++i) {
            MonsterPlusUtil.spawnEntity(player.getLocation(), monsterTypeEnum);
        }
        String spawnMsg = BaseUtil.getLangMsg("spawnMsg", "").replace("${monster}", monsterTypeEnum.getDesc()).replace("${number}", number.toString());
        MessageUtil.sendMessage(sender, spawnMsg);
    }
}

