/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.command.admin;

import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.constants.MonsterTypeEnum;
import cn.handyplus.monster.lib.command.IHandyCommandEvent;
import cn.handyplus.monster.lib.util.AssertUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.param.MonsterSpawnParam;
import cn.handyplus.monster.util.MonsterPlusUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpawnCustomCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "spawnCustom";
    }

    @Override
    public String permission() {
        return "monsterPlus.spawnCustom";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, BaseUtil.getLangMsg("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        MonsterSpawnParam monsterSpawnParam = MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.get(args[1]);
        if (monsterSpawnParam == null) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("typeFailureMsg").replace("${type}", args[1]));
            return;
        }
        Integer number = 1;
        if (args.length > 2) {
            number = AssertUtil.isNumericToInt(args[2], BaseUtil.getLangMsg("amountFailureMsg"));
        }
        for (int i = 0; i < number; ++i) {
            MonsterPlusUtil.spawnEntity(player.getLocation(), monsterSpawnParam);
        }
        String spawnMsg = BaseUtil.getLangMsg("spawnMsg", "").replace("${monster}", MonsterTypeEnum.getDesc(monsterSpawnParam.getEntityType())).replace("${number}", number.toString());
        MessageUtil.sendMessage(player, spawnMsg);
    }
}

