/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.constants;

import cn.handyplus.monster.constants.EntityEquipmentTypeEnum;
import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.lib.constants.BaseConstants;
import cn.handyplus.monster.lib.util.ProbabilityUtil;
import cn.handyplus.monster.param.EntityEquipmentParam;
import lombok.Generated;
import org.bukkit.Material;

public enum EntityEquipmentEnum {
    NETHERITE_BOOTS(0, EntityEquipmentTypeEnum.BOOTS, Material.NETHERITE_BOOTS),
    NETHERITE_CHESTPLATE(0, EntityEquipmentTypeEnum.CHEST_PLATE, Material.NETHERITE_CHESTPLATE),
    NETHERITE_HELMET(0, EntityEquipmentTypeEnum.HELMET, Material.NETHERITE_HELMET),
    NETHERITE_LEGGINGS(0, EntityEquipmentTypeEnum.LEGGINGS, Material.NETHERITE_LEGGINGS),
    NETHERITE_SWORD(0, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, Material.NETHERITE_SWORD),
    NETHERITE_BOW(0, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_BOW, Material.BOW),
    NETHERITE_AXE(0, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, Material.NETHERITE_AXE),
    NETHERITE_TRIDENT(0, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_TRIDENT, Material.TRIDENT),
    DIAMOND_BOOTS(1, EntityEquipmentTypeEnum.BOOTS, Material.DIAMOND_BOOTS),
    DIAMOND_CHESTPLATE(1, EntityEquipmentTypeEnum.CHEST_PLATE, Material.DIAMOND_CHESTPLATE),
    DIAMOND_HELMET(1, EntityEquipmentTypeEnum.HELMET, Material.DIAMOND_HELMET),
    DIAMOND_LEGGINGS(1, EntityEquipmentTypeEnum.LEGGINGS, Material.DIAMOND_LEGGINGS),
    DIAMOND_SWORD(1, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, Material.DIAMOND_SWORD),
    DIAMOND_BOW(1, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_BOW, Material.BOW),
    DIAMOND_AXE(1, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, Material.DIAMOND_AXE),
    DIAMOND_TRIDENT(1, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_TRIDENT, Material.TRIDENT),
    IRON_BOOTS(2, EntityEquipmentTypeEnum.BOOTS, Material.IRON_BOOTS),
    IRON_CHESTPLATE(2, EntityEquipmentTypeEnum.CHEST_PLATE, Material.IRON_CHESTPLATE),
    IRON_HELMET(2, EntityEquipmentTypeEnum.HELMET, Material.IRON_HELMET),
    IRON_LEGGINGS(2, EntityEquipmentTypeEnum.LEGGINGS, Material.IRON_LEGGINGS),
    IRON_SWORD(2, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, Material.IRON_SWORD),
    IRON_BOW(2, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_BOW, Material.BOW),
    IRON_AXE(2, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, Material.IRON_AXE),
    IRON_TRIDENT(2, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_TRIDENT, Material.TRIDENT),
    GOLDEN_BOOTS(3, EntityEquipmentTypeEnum.BOOTS, Material.GOLDEN_BOOTS),
    GOLDEN_CHESTPLATE(3, EntityEquipmentTypeEnum.CHEST_PLATE, Material.GOLDEN_CHESTPLATE),
    GOLDEN_HELMET(3, EntityEquipmentTypeEnum.HELMET, Material.GOLDEN_HELMET),
    GOLDEN_LEGGINGS(3, EntityEquipmentTypeEnum.LEGGINGS, Material.GOLDEN_LEGGINGS),
    GOLDEN_SWORD(3, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, Material.GOLDEN_SWORD),
    GOLDEN_BOW(3, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_BOW, Material.BOW),
    GOLDEN_AXE(3, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, Material.GOLDEN_AXE),
    GOLDEN_TRIDENT(3, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_TRIDENT, Material.TRIDENT),
    CHAINMAIL_BOOTS(4, EntityEquipmentTypeEnum.BOOTS, Material.CHAINMAIL_BOOTS),
    CHAINMAIL_CHESTPLATE(4, EntityEquipmentTypeEnum.CHEST_PLATE, Material.CHAINMAIL_CHESTPLATE),
    CHAINMAIL_HELMET(4, EntityEquipmentTypeEnum.HELMET, Material.CHAINMAIL_HELMET),
    CHAINMAIL_LEGGINGS(4, EntityEquipmentTypeEnum.LEGGINGS, Material.CHAINMAIL_LEGGINGS),
    STONE_SWORD(4, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, Material.STONE_SWORD),
    CHAINMAIL_BOW(4, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_BOW, Material.BOW),
    STONE_AXE(4, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, Material.STONE_AXE),
    STONE_TRIDENT(4, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_TRIDENT, Material.TRIDENT),
    LEATHER_BOOTS(5, EntityEquipmentTypeEnum.BOOTS, Material.LEATHER_BOOTS),
    LEATHER_CHESTPLATE(5, EntityEquipmentTypeEnum.CHEST_PLATE, Material.LEATHER_CHESTPLATE),
    LEATHER_HELMET(5, EntityEquipmentTypeEnum.HELMET, Material.LEATHER_HELMET),
    LEATHER_LEGGINGS(5, EntityEquipmentTypeEnum.LEGGINGS, Material.LEATHER_LEGGINGS),
    WOODEN_SWORD(5, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, Material.WOODEN_SWORD),
    LEATHER_BOW(5, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_BOW, Material.BOW),
    WOODEN_AXE(5, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, Material.WOODEN_AXE),
    LEATHER_TRIDENT(5, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_TRIDENT, Material.TRIDENT);

    private final Integer typeId;
    private final EntityEquipmentTypeEnum equipmentTypeEnum;
    private final Material material;

    public static EntityEquipmentParam getMaterial(EntityEquipmentTypeEnum equipmentTypeEnum) {
        int typeId = MonsterPlusConstants.EQUIPMENT_LOTTERY.randomIndex();
        for (EntityEquipmentEnum entityEquipmentEnum : EntityEquipmentEnum.values()) {
            if (!entityEquipmentEnum.getEquipmentTypeEnum().equals((Object)equipmentTypeEnum) || entityEquipmentEnum.getTypeId() != typeId) continue;
            return EntityEquipmentParam.builder().material(entityEquipmentEnum.getMaterial()).dropChance(EntityEquipmentEnum.getDropChance(typeId)).build();
        }
        return null;
    }

    public static boolean getDropChance(Integer typeId) {
        double dropChance = 0.0;
        switch (typeId) {
            case 0: {
                dropChance = BaseConstants.CONFIG.getDouble("netherDropChance");
                break;
            }
            case 1: {
                dropChance = BaseConstants.CONFIG.getDouble("diamondDropChance");
                break;
            }
            case 2: {
                dropChance = BaseConstants.CONFIG.getDouble("ironDropChance");
                break;
            }
            case 3: {
                dropChance = BaseConstants.CONFIG.getDouble("goldenDropChance");
                break;
            }
            case 4: {
                dropChance = BaseConstants.CONFIG.getDouble("chainMailDropChance");
                break;
            }
            case 5: {
                dropChance = BaseConstants.CONFIG.getDouble("leatherDropChance");
                break;
            }
        }
        return ProbabilityUtil.getInstance().pickIndex(dropChance);
    }

    @Generated
    public Integer getTypeId() {
        return this.typeId;
    }

    @Generated
    public EntityEquipmentTypeEnum getEquipmentTypeEnum() {
        return this.equipmentTypeEnum;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    private EntityEquipmentEnum(Integer typeId, EntityEquipmentTypeEnum equipmentTypeEnum, Material material) {
        this.typeId = typeId;
        this.equipmentTypeEnum = equipmentTypeEnum;
        this.material = material;
    }
}

