/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.core;

import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.core.PatternUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class MonsterDamage {
    public static void updateDamage(UUID monsterUuid, String playerName, double damage) {
        Map playerDamageMap = MonsterPlusConstants.PLAYER_DAMAGE_MAP.computeIfAbsent(monsterUuid, k -> new ConcurrentHashMap());
        playerDamageMap.merge(playerName, damage, Double::sum);
    }

    public static List<Map.Entry<String, Double>> getTopThreePlayers(UUID monsterId) {
        Map players = MonsterPlusConstants.PLAYER_DAMAGE_MAP.getOrDefault(monsterId, Collections.emptyMap());
        List result = players.entrySet().stream().sorted((e1, e2) -> Double.compare((Double)e2.getValue(), (Double)e1.getValue())).limit(3L).map(entry -> {
            double roundedValue = BigDecimal.valueOf((Double)entry.getValue()).setScale(2, RoundingMode.HALF_UP).doubleValue();
            return new AbstractMap.SimpleEntry<String, Double>((String)entry.getKey(), roundedValue);
        }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        while (result.size() < 3) {
            result.add(new AbstractMap.SimpleEntry<String, Double>("\u65e0", 0.0));
        }
        return result;
    }

    public static String getRankPrefix(int index) {
        switch (index) {
            case 0: {
                return "one";
            }
            case 1: {
                return "two";
            }
            case 2: {
                return "three";
            }
        }
        throw new IllegalArgumentException("Invalid rank index: " + index);
    }

    public static List<String> replaceVariables(List<String> messages, Map<String, String> variables) {
        if (CollUtil.isEmpty(messages)) {
            return messages;
        }
        return messages.stream().map(msg -> MonsterDamage.replacePlaceholders(msg, variables)).collect(Collectors.toList());
    }

    private static String replacePlaceholders(String template, Map<String, String> variables) {
        Matcher matcher = PatternUtil.TEMPLATE_EXPRESSION_REGEX.matcher(template);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String replacement = variables.getOrDefault(key, matcher.group());
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

