/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.core;

import cn.handyplus.monster.core.MonsterScoreboardTag;
import cn.handyplus.monster.lib.constants.AttributeCompatEnum;
import cn.handyplus.monster.lib.constants.BaseConstants;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.core.MapUtil;
import cn.handyplus.monster.lib.core.NumberUtil;
import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.HandyConfigUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.lib.util.ProbabilityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Panda;
import org.bukkit.entity.PiglinAbstract;

public class MonsterLevel {
    public static void setLevel(LivingEntity entity, String name, int level) {
        MonsterLevel.setLevel(entity, name, level, null, null, null, true);
    }

    public static void setLevel(LivingEntity entity, String name, int level, List<String> drops, List<String> skill, String displayName, boolean removeWhenFarAway) {
        MonsterScoreboardTag.removeScoreboardTag(entity);
        int mobLevel = MonsterLevel.setMobLevel(entity, level);
        MonsterScoreboardTag.addScoreboardTag(entity, "monster=.=true");
        skill = CollUtil.isEmpty(skill) ? MonsterLevel.levelSkill(mobLevel) : skill;
        int skillCount = 0;
        if (CollUtil.isNotEmpty(skill)) {
            MonsterScoreboardTag.addScoreboardTag(entity, "skill=.=" + CollUtil.listToStr(skill));
            skillCount = skill.size();
        }
        List<String> list = drops = CollUtil.isEmpty(drops) ? MonsterLevel.levelDrop(mobLevel, skillCount) : drops;
        if (CollUtil.isNotEmpty(drops)) {
            MonsterScoreboardTag.addScoreboardTag(entity, "drops=.=" + CollUtil.listToStr(drops));
        }
        String customName = MonsterLevel.setCustomName(entity, name, mobLevel, displayName, skillCount);
        boolean setLevelAttrRst = MonsterLevel.setLevelAttr(entity, mobLevel);
        MessageUtil.sendConsoleDebugMessage("\u602a\u7269:" + customName + ",\u52a0\u8f7d\u7b49\u7ea7\u5c5e\u6027\u7ed3\u679c:" + setLevelAttrRst);
        entity.setRemoveWhenFarAway(removeWhenFarAway);
        MonsterLevel.setImmuneToZombification(entity);
    }

    private static boolean setLevelAttr(LivingEntity entity, int level) {
        AttributeInstance healthAttribute = entity.getAttribute(AttributeCompatEnum.MAX_HEALTH.resolve());
        AttributeInstance damageAttribute = entity.getAttribute(AttributeCompatEnum.ATTACK_DAMAGE.resolve());
        if (healthAttribute == null || damageAttribute == null) {
            return false;
        }
        String levelHealthStr = "MonsterPlus_levelHealth";
        String levelDamageStr = "MonsterPlus_levelDamage";
        for (AttributeModifier modifier : healthAttribute.getModifiers()) {
            if (!levelHealthStr.equals(modifier.getName())) continue;
            healthAttribute.removeModifier(modifier);
        }
        for (AttributeModifier modifier : damageAttribute.getModifiers()) {
            if (!levelDamageStr.equals(modifier.getName())) continue;
            damageAttribute.removeModifier(modifier);
        }
        double levelHealth = (double)level * BaseConstants.CONFIG.getDouble("levelHealth", 1.0);
        double levelDamage = (double)level * BaseConstants.CONFIG.getDouble("levelDamage", 0.1);
        healthAttribute.addModifier(new AttributeModifier(levelHealthStr, levelHealth, AttributeModifier.Operation.ADD_NUMBER));
        damageAttribute.addModifier(new AttributeModifier(levelDamageStr, levelDamage, AttributeModifier.Operation.ADD_NUMBER));
        entity.setHealth(healthAttribute.getValue());
        entity.setMaxHealth(healthAttribute.getValue());
        return true;
    }

    private static int setMobLevel(LivingEntity entity, int level) {
        if (level == -1) {
            int randomLevel = BaseConstants.CONFIG.getInt("randomLevel");
            level = new Random().nextInt(randomLevel);
            level = level == 0 ? 1 : level;
            level += MonsterLevel.distanceLevel(entity).intValue();
        }
        MonsterScoreboardTag.addScoreboardTag(entity, "level=.=" + level);
        return level;
    }

    private static void setImmuneToZombification(LivingEntity entity) {
        if (entity instanceof PiglinAbstract) {
            PiglinAbstract piglinAbstract = (PiglinAbstract)entity;
            piglinAbstract.setImmuneToZombification(true);
        }
        if (entity instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)entity;
            hoglin.setImmuneToZombification(true);
        }
        if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            panda.setHiddenGene(Panda.Gene.AGGRESSIVE);
            panda.setMainGene(Panda.Gene.AGGRESSIVE);
        }
    }

    private static String setCustomName(LivingEntity entity, String name, int level, String displayName, int skillCount) {
        String customName;
        String entityName;
        if (StrUtil.isNotEmpty(displayName)) {
            entityName = displayName;
        } else {
            Map<String, String> nameColor = HandyConfigUtil.getStringMapChild(BaseConstants.CONFIG, "nameColor");
            entityName = BaseConstants.CONFIG.getString("nameColorDefault", "&f[${level}\u7ea7]${elite}&f${name}");
            if (MapUtil.isNotEmpty(nameColor)) {
                for (String key : nameColor.keySet()) {
                    if (level > Integer.parseInt(key)) continue;
                    entityName = nameColor.get(key);
                    break;
                }
            }
        }
        entityName = StrUtil.replace(entityName, "level", String.valueOf(level));
        entityName = StrUtil.replace(entityName, "name", name);
        String elite = "";
        Map<String, String> eliteMap = HandyConfigUtil.getStringMapChild(BaseConstants.LANG_CONFIG, "elite");
        if (!eliteMap.isEmpty()) {
            elite = eliteMap.getOrDefault(String.valueOf(skillCount), elite);
        }
        if (StrUtil.isNotEmpty(customName = BaseUtil.replaceChatColor(entityName = StrUtil.replace(entityName, "elite", elite)))) {
            entity.setCustomName(customName);
            entity.setCustomNameVisible(true);
            MonsterScoreboardTag.addScoreboardTag(entity, "name=.=" + customName);
        }
        return customName;
    }

    private static Integer distanceLevel(LivingEntity entity) {
        boolean distanceLevelEnable = BaseConstants.CONFIG.getBoolean("distanceLevelEnable");
        if (!distanceLevelEnable) {
            return 0;
        }
        String worldName = entity.getWorld().getName();
        Map<String, String> worldLevelMap = HandyConfigUtil.getStringMapChild(BaseConstants.CONFIG, "distanceLevel." + worldName + ".level");
        return MonsterLevel.getDistanceLevel(entity, !worldLevelMap.isEmpty() ? worldName : "default");
    }

    private static Integer getDistanceLevel(LivingEntity entity, String world) {
        double x = BaseConstants.CONFIG.getDouble("distanceLevel." + world + ".x");
        double y = BaseConstants.CONFIG.getDouble("distanceLevel." + world + ".y");
        double z = BaseConstants.CONFIG.getDouble("distanceLevel." + world + ".z");
        double distance = entity.getLocation().distance(new Location(entity.getWorld(), x, y, z));
        Map<String, String> levelMap = HandyConfigUtil.getStringMapChild(BaseConstants.CONFIG, "distanceLevel." + world + ".level");
        if (levelMap.isEmpty()) {
            return 0;
        }
        TreeMap treeMap = levelMap.entrySet().stream().collect(Collectors.toMap(entry -> Integer.parseInt((String)entry.getKey()), entry -> Integer.parseInt((String)entry.getValue()), (oldValue, newValue) -> oldValue, TreeMap::new));
        Map.Entry entry2 = treeMap.floorEntry((int)distance);
        return entry2 != null ? (Integer)entry2.getValue() : 0;
    }

    private static List<String> levelSkill(Integer target) {
        ArrayList<String> skillList = new ArrayList<String>();
        boolean levelSkillEnable = BaseConstants.CONFIG.getBoolean("levelSkillEnable");
        if (!levelSkillEnable) {
            return skillList;
        }
        Set<String> levelSkillSet = HandyConfigUtil.getKey(BaseConstants.CONFIG, "levelSkill");
        if (CollUtil.isEmpty(levelSkillSet)) {
            return skillList;
        }
        Optional<Integer> result = levelSkillSet.stream().map(Integer::parseInt).filter(num -> num < target).max(Integer::compareTo);
        if (!result.isPresent()) {
            return skillList;
        }
        Integer levelResult = result.get();
        List skillListResult = BaseConstants.CONFIG.getStringList("levelSkill." + levelResult);
        if (CollUtil.isEmpty(skillListResult)) {
            return skillList;
        }
        for (String skillResult : skillListResult) {
            String[] split = skillResult.split(":");
            String skill = split[0].trim();
            Double probability = NumberUtil.isNumericToDouble(split[1].trim(), 0.0);
            if (!ProbabilityUtil.getInstance().pickIndex(probability)) continue;
            skillList.add(skill);
        }
        return skillList.stream().distinct().collect(Collectors.toList());
    }

    private static List<String> levelDrop(Integer level, int skillCount) {
        ArrayList<String> dropList = new ArrayList<String>();
        boolean levelDropEnable = BaseConstants.CONFIG.getBoolean("levelDropEnable");
        if (!levelDropEnable) {
            return dropList;
        }
        if (skillCount == 0) {
            return MonsterLevel.getNormalLevelDrop(level);
        }
        return MonsterLevel.getEliteLevelDrop(skillCount);
    }

    private static List<String> getNormalLevelDrop(int level) {
        ArrayList<String> dropList = new ArrayList<String>();
        Set<String> levelDropSet = HandyConfigUtil.getKey(BaseConstants.CONFIG, "levelDrop.normal");
        if (CollUtil.isEmpty(levelDropSet)) {
            return dropList;
        }
        Optional<Integer> result = levelDropSet.stream().map(Integer::parseInt).filter(num -> num < level).max(Integer::compareTo);
        if (!result.isPresent()) {
            return dropList;
        }
        Integer levelResult = result.get();
        List eliteList = BaseConstants.CONFIG.getStringList("levelDrop.normal." + levelResult);
        return eliteList.stream().filter(StrUtil::isNotEmpty).collect(Collectors.toList());
    }

    private static List<String> getEliteLevelDrop(int skillCount) {
        List eliteList = BaseConstants.CONFIG.getStringList("levelDrop.elite." + skillCount);
        return eliteList.stream().filter(StrUtil::isNotEmpty).collect(Collectors.toList());
    }
}

