/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.core;

import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.LivingEntity;

public class MonsterScoreboardTag {
    public static void addScoreboardTag(LivingEntity entity, String tag) {
        entity.addScoreboardTag("MonsterPlus_" + tag);
    }

    public static void removeScoreboardTag(LivingEntity entity) {
        entity.getScoreboardTags().clear();
    }

    public static void removeScoreboardTag(LivingEntity entity, String tag) {
        Set scoreboardTags = entity.getScoreboardTags();
        if (!scoreboardTags.isEmpty()) {
            Iterator it = scoreboardTags.iterator();
            while (it.hasNext()) {
                String scoreboardTag = (String)it.next();
                MessageUtil.sendConsoleDebugMessage("\u602a\u7269\u5305\u542b\u7684\u6807\u7b7e\u4e3a:" + scoreboardTag);
                if (!scoreboardTag.contains("MonsterPlus_" + tag)) continue;
                it.remove();
            }
        }
    }

    public static int getLevel(LivingEntity entity) {
        String level = MonsterScoreboardTag.getScoreboardTag(entity, "level");
        if (StrUtil.isNotEmpty(level)) {
            return Integer.parseInt(level);
        }
        return -1;
    }

    public static boolean isMonsterPlus(LivingEntity entity) {
        String scoreboardTag = MonsterScoreboardTag.getScoreboardTag(entity, "monster");
        return "true".equals(scoreboardTag);
    }

    public static String getMonsterName(LivingEntity entity) {
        return MonsterScoreboardTag.getScoreboardTag(entity, "name");
    }

    public static String getMonsterKey(LivingEntity entity) {
        return MonsterScoreboardTag.getScoreboardTag(entity, "key");
    }

    public static List<String> getDrops(LivingEntity entity) {
        String scoreboardTag = MonsterScoreboardTag.getScoreboardTag(entity, "drops");
        if (StrUtil.isNotEmpty(scoreboardTag)) {
            return StrUtil.strToStrList(scoreboardTag);
        }
        return new ArrayList<String>();
    }

    public static List<String> getSkill(LivingEntity entity) {
        String scoreboardTag = MonsterScoreboardTag.getScoreboardTag(entity, "skill");
        if (StrUtil.isNotEmpty(scoreboardTag)) {
            return StrUtil.strToStrList(scoreboardTag);
        }
        return new ArrayList<String>();
    }

    private static String getScoreboardTag(LivingEntity entity, String tag) {
        Set scoreboardTags = entity.getScoreboardTags();
        if (scoreboardTags.isEmpty()) {
            return null;
        }
        for (String scoreboardTag : scoreboardTags) {
            if (!scoreboardTag.contains("MonsterPlus_" + tag)) continue;
            String[] split = scoreboardTag.split("=.=");
            StringBuilder str = new StringBuilder();
            for (int i = 1; i < split.length; ++i) {
                str.append(split[i]);
            }
            return str.toString();
        }
        return null;
    }
}

