/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.inventory;

import cn.handyplus.monster.constants.GuiTypeEnum;
import cn.handyplus.monster.lib.inventory.HandyInventory;
import cn.handyplus.monster.lib.inventory.HandyInventoryUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.util.ConfigUtil;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class DrawingsGui {
    private static final DrawingsGui INSTANCE = new DrawingsGui();

    private DrawingsGui() {
    }

    public static DrawingsGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, String drawingsParam, ItemStack item) {
        String title = ConfigUtil.DRAWING_CONFIG.getString("title", "");
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.DRAWINGS.getType(), BaseUtil.replaceChatColor(title), false);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(drawingsParam);
        this.setInventoryDate(handyInventory, item);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory, ItemStack item) {
        handyInventory.setGuiType(GuiTypeEnum.DRAWINGS.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory, item);
    }

    private void setFunctionMenu(HandyInventory handyInventory, ItemStack item) {
        Inventory inventory = handyInventory.getInventory();
        HandyInventoryUtil.setButton(ConfigUtil.DRAWING_CONFIG, handyInventory, "confirm");
        int index = ConfigUtil.DRAWING_CONFIG.getInt("drawings.index", 4);
        inventory.setItem(index, item);
        HandyInventoryUtil.setButton(ConfigUtil.DRAWING_CONFIG, handyInventory, "pane");
    }
}

