/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.lib.attribute;

import cn.handyplus.monster.lib.InitApi;
import cn.handyplus.monster.lib.core.JsonUtil;
import cn.handyplus.monster.lib.core.NumberUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;

public class MythicLibUtil {
    private static Boolean IS_NEW_VERSION;

    private MythicLibUtil() {
    }

    protected static void addAttribute(LivingEntity entity, List<String> attributeList) {
        MMOPlayerData playerData = MMOPlayerData.get((UUID)entity.getUniqueId());
        Map<String, Double> aggregateData = MythicLibUtil.aggregateData(attributeList);
        for (String attributeName : aggregateData.keySet()) {
            StatModifier experienceModifier = new StatModifier(InitApi.PLUGIN.getName(), attributeName, aggregateData.get(attributeName).doubleValue(), ModifierType.FLAT);
            experienceModifier.register(playerData);
        }
    }

    protected static void removeAttribute(LivingEntity entity) {
        MMOPlayerData playerData = MMOPlayerData.get((UUID)entity.getUniqueId());
        StatMap statMap = playerData.getStatMap();
        for (StatInstance instance : statMap.getInstances()) {
            instance.removeIf(i -> i.equals(InitApi.PLUGIN.getName()));
        }
    }

    protected static boolean isNewVersion() {
        if (IS_NEW_VERSION != null) {
            return IS_NEW_VERSION;
        }
        try {
            Class.forName("io.lumine.mythic.lib.api.player.MMOPlayerData");
            IS_NEW_VERSION = true;
        }
        catch (ClassNotFoundException e) {
            IS_NEW_VERSION = false;
        }
        return IS_NEW_VERSION;
    }

    private static Map<String, Double> aggregateData(List<String> attributeList) {
        HashMap<String, Double> resultMap = new HashMap<String, Double>();
        for (String attribute : attributeList) {
            String[] split = attribute.split(":");
            String attributeName = BaseUtil.stripColor(split[0].trim()).toUpperCase().replace("-", "_");
            Double number = NumberUtil.isNumericToDouble(split[1].trim(), 0.0);
            resultMap.put(attributeName, resultMap.getOrDefault(attributeName, 0.0) + number);
        }
        MessageUtil.sendConsoleDebugMessage("\u6700\u7ec8\u5c5e\u6027:" + JsonUtil.toJson(resultMap));
        return resultMap;
    }
}

