/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.lib.hologram;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class CmiUtil {
    private static final Map<Location, CMIHologram> CMI_HD_CACHE = new HashMap<Location, CMIHologram>();

    private CmiUtil() {
    }

    protected static void create(List<String> textLineList, Location location) {
        CMIHologram holo = new CMIHologram(UUID.randomUUID().toString(), location);
        holo.setLines(textLineList);
        CMI.getInstance().getHologramManager().addHologram(holo);
        holo.update();
        CMI_HD_CACHE.put(location, holo);
    }

    protected static void delete(Location location) {
        CMIHologram cmiHologram = CMI_HD_CACHE.get(location);
        if (cmiHologram != null) {
            cmiHologram.disable();
            cmiHologram.remove();
            CMI_HD_CACHE.remove(location);
        }
    }

    protected static void deleteAll() {
        if (CMI_HD_CACHE.isEmpty()) {
            return;
        }
        for (Location location : CMI_HD_CACHE.keySet()) {
            CMIHologram cmiHologram = CMI_HD_CACHE.get(location);
            if (cmiHologram == null || cmiHologram.getWorld() == null) continue;
            cmiHologram.disable();
            cmiHologram.remove();
        }
        CMI_HD_CACHE.clear();
    }
}

