/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.lib.hologram;

import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.HologramManager;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;

public class FancyHologramsUtil {
    private static final Map<Location, String> FANCY_HOLOGRAMS_HD_CACHE = new HashMap<Location, String>();

    private FancyHologramsUtil() {
    }

    protected static void create(List<String> textLineList, Location location) {
        HologramManager manager = FancyHologramsPlugin.get().getHologramManager();
        TextHologramData hologramData = new TextHologramData(UUID.randomUUID().toString(), location);
        hologramData.setText(textLineList);
        Hologram hologram = manager.create((HologramData)hologramData);
        manager.addHologram(hologram);
        FANCY_HOLOGRAMS_HD_CACHE.put(location, hologram.getName());
    }

    protected static void delete(Location location) {
        String hdName = FANCY_HOLOGRAMS_HD_CACHE.get(location);
        if (hdName != null && !hdName.isEmpty()) {
            HologramManager manager = FancyHologramsPlugin.get().getHologramManager();
            Optional hologramOptional = manager.getHologram(hdName);
            hologramOptional.ifPresent(arg_0 -> ((HologramManager)manager).removeHologram(arg_0));
            FANCY_HOLOGRAMS_HD_CACHE.remove(location);
        }
    }

    protected static void deleteAll() {
        if (FANCY_HOLOGRAMS_HD_CACHE.isEmpty()) {
            return;
        }
        HologramManager manager = FancyHologramsPlugin.get().getHologramManager();
        for (Location location : FANCY_HOLOGRAMS_HD_CACHE.keySet()) {
            String hdName = FANCY_HOLOGRAMS_HD_CACHE.get(location);
            if (hdName == null || hdName.isEmpty()) continue;
            Optional hologramOptional = manager.getHologram(hdName);
            hologramOptional.ifPresent(arg_0 -> ((HologramManager)manager).removeHologram(arg_0));
        }
        FANCY_HOLOGRAMS_HD_CACHE.clear();
    }
}

