/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.lib.util;

import cn.handyplus.monster.lib.constants.BaseConstants;
import cn.handyplus.monster.lib.core.MapUtil;
import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.util.LegacyUtil;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class TranslationUtil {
    @NotNull
    public static String getEnchantmentTranslation(@NotNull String enchantment) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return enchantment;
        }
        String enchantmentKey = LegacyUtil.getEnchantmentKey(LegacyUtil.getEnchantmentByName(enchantment));
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("enchantment.minecraft." + enchantmentKey, enchantment);
    }

    @NotNull
    public static String getEnchantmentLevelTranslation(@NotNull String enchantmentLevel) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return enchantmentLevel;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("enchantment.level." + enchantmentLevel, enchantmentLevel);
    }

    @NotNull
    public static String getEffectTranslation(@NotNull String effect) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return effect;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("effect.minecraft." + effect.toLowerCase(), effect);
    }

    @NotNull
    public static String getEntityTranslation(@NotNull String entity) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return entity;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("entity.minecraft." + entity.toLowerCase(), entity);
    }

    @NotNull
    public static String getColorTranslation(@NotNull String color) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return color;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("color.minecraft." + color.toLowerCase(), color);
    }

    @Nullable
    public static String getMaterialTranslation(@NotNull String materialName) {
        String itemTranslation = TranslationUtil.getItemTranslation(materialName);
        if (StrUtil.isNotEmpty(itemTranslation)) {
            return itemTranslation;
        }
        return TranslationUtil.getBlockTranslation(materialName);
    }

    @Nullable
    public static String getItemTranslation(@NotNull String item) {
        if (MapUtil.isEmpty(BaseConstants.JSON_CACHE_MAP)) {
            return null;
        }
        return BaseConstants.JSON_CACHE_MAP.get("item.minecraft." + item.toLowerCase());
    }

    @Nullable
    public static String getBlockTranslation(@NotNull String block) {
        if (MapUtil.isEmpty(BaseConstants.JSON_CACHE_MAP)) {
            return null;
        }
        return BaseConstants.JSON_CACHE_MAP.get("block.minecraft." + block.toLowerCase());
    }
}

