/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.listener.monster;

import cn.handyplus.monster.api.MonsterPlusApi;
import cn.handyplus.monster.core.MonsterDamage;
import cn.handyplus.monster.lib.annotation.HandyListener;
import cn.handyplus.monster.skill.SkillFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.jetbrains.annotations.Nullable;

@HandyListener
public class EntityDamageByEntityEventListener
implements Listener {
    @EventHandler
    public void onEvent(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getDamager() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)event.getDamager();
        if (livingEntity.getCustomName() == null) {
            return;
        }
        if (!livingEntity.isValid()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        SkillFactory.attackSkill(event, livingEntity, player);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEvent2(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)event.getEntity();
        if (!MonsterPlusApi.isMonsterPlus(livingEntity)) {
            return;
        }
        Player damagePlayer = this.getDamagePlayer(event);
        if (damagePlayer == null) {
            return;
        }
        double finalDamage = event.getFinalDamage();
        if (event.getFinalDamage() > livingEntity.getHealth()) {
            finalDamage = livingEntity.getHealth();
        }
        MonsterDamage.updateDamage(livingEntity.getUniqueId(), damagePlayer.getName(), finalDamage);
    }

    @Nullable
    private Player getDamagePlayer(EntityDamageByEntityEvent event) {
        ThrownPotion potion;
        Projectile arrow;
        Player damagePlayer = null;
        if (event.getDamager() instanceof Player) {
            damagePlayer = (Player)event.getDamager();
        }
        if (event.getDamager() instanceof Projectile && (arrow = (Projectile)event.getDamager()).getShooter() instanceof Player) {
            damagePlayer = (Player)arrow.getShooter();
        }
        if (event.getDamager() instanceof ThrownPotion && (potion = (ThrownPotion)event.getDamager()).getShooter() instanceof Player) {
            damagePlayer = (Player)potion.getShooter();
        }
        return damagePlayer;
    }
}

