/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.listener.skill;

import cn.handyplus.monster.core.MonsterScoreboardTag;
import cn.handyplus.monster.lib.annotation.HandyListener;
import cn.handyplus.monster.skill.SkillFactory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;

@HandyListener
public class EntityTargetEventListener
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public void onEvent(EntityTargetEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!EntityTargetEvent.TargetReason.CLOSEST_PLAYER.equals((Object)event.getReason())) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        boolean monsterPlus = MonsterScoreboardTag.isMonsterPlus(livingEntity);
        if (!monsterPlus) {
            return;
        }
        SkillFactory.spawnSkill(livingEntity);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEvent2(EntityTargetEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!MonsterScoreboardTag.isMonsterPlus(livingEntity)) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity targetLivingEntity = (LivingEntity)target;
        if (!MonsterScoreboardTag.isMonsterPlus(targetLivingEntity)) {
            return;
        }
        event.setCancelled(true);
    }
}

