/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.skill;

import cn.handyplus.monster.lib.core.BeanUtil;
import cn.handyplus.monster.skill.Skill;
import java.util.Map;
import java.util.Random;
import lombok.Generated;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class AttackArrow
extends Skill {
    private Integer number;
    private Double speed;

    public static AttackArrow getInstance(Map<String, Object> skillMap) {
        return BeanUtil.mapToBean(AttackArrow.class, skillMap);
    }

    public void execution(LivingEntity livingEntity, Player player) {
        for (int i = 0; i < this.number; ++i) {
            Arrow arrow = (Arrow)livingEntity.launchProjectile(Arrow.class);
            AttackArrow.randomArrow(arrow);
            Vector direction = player.getLocation().toVector().subtract(livingEntity.getLocation().toVector()).normalize();
            arrow.setVelocity(direction.multiply(this.speed.doubleValue()));
        }
        super.sendMsg(player, livingEntity.getCustomName());
    }

    public static void randomArrow(Arrow arrow) {
        Random random;
        PotionEffectType[] allEffects = PotionEffectType.values();
        PotionEffectType randomEffectType = allEffects[(random = new Random()).nextInt(allEffects.length)];
        if (randomEffectType != null && randomEffectType.isInstant()) {
            PotionEffect effect = new PotionEffect(randomEffectType, 100, 1);
            arrow.addCustomEffect(effect, true);
        }
        arrow.setCritical(true);
        arrow.setGlowing(true);
        arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
    }

    @Generated
    public Integer getNumber() {
        return this.number;
    }

    @Generated
    public Double getSpeed() {
        return this.speed;
    }

    @Generated
    public void setNumber(Integer number) {
        this.number = number;
    }

    @Generated
    public void setSpeed(Double speed) {
        this.speed = speed;
    }
}

