/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.skill;

import cn.handyplus.monster.constants.SkillEnum;
import cn.handyplus.monster.core.MonsterScoreboardTag;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.core.YmlUtil;
import cn.handyplus.monster.lib.expand.adapter.HandyRunnable;
import cn.handyplus.monster.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.monster.lib.util.ProbabilityUtil;
import cn.handyplus.monster.skill.Skill;
import cn.handyplus.monster.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class SkillFactory {
    public static void attackSkill(EntityDamageByEntityEvent event, LivingEntity livingEntity, Player player) {
        List<String> skillList = MonsterScoreboardTag.getSkill(livingEntity);
        if (CollUtil.isEmpty(skillList)) {
            return;
        }
        for (String skill : skillList) {
            SkillEnum skillEnum = SkillEnum.getSpawnEnumByType(skill, "attack");
            if (skillEnum == null) continue;
            SkillFactory.initAttackSkill(event, livingEntity, player, skillEnum);
        }
    }

    private static void initAttackSkill(EntityDamageByEntityEvent event, LivingEntity livingEntity, Player player, SkillEnum skill) {
        FileConfiguration fileConfiguration = ConfigUtil.SKILL_CONFIG_MAP.get(skill.getType());
        if (fileConfiguration == null) {
            return;
        }
        Map<String, Object> skillMap = YmlUtil.ymlToMap("skill/" + skill.getType());
        int probability = fileConfiguration.getInt("probability", 0);
        if (!ProbabilityUtil.getInstance().pickIndex(probability, 100)) {
            return;
        }
        Skill.attackExecution(event, livingEntity, player, skillMap, skill);
    }

    public static void spawnSkill(LivingEntity livingEntity) {
        List<String> skillList = MonsterScoreboardTag.getSkill(livingEntity);
        if (CollUtil.isEmpty(skillList)) {
            return;
        }
        for (String skill : skillList) {
            SkillEnum skillEnum = SkillEnum.getSpawnEnumByType(skill, "spawn");
            if (skillEnum == null) continue;
            SkillFactory.initSpawnSkill(livingEntity, skillEnum);
        }
    }

    private static void initSpawnSkill(final LivingEntity livingEntity, final SkillEnum skill) {
        FileConfiguration fileConfiguration = ConfigUtil.SKILL_CONFIG_MAP.get(skill.getType());
        if (fileConfiguration == null) {
            return;
        }
        final Map<String, Object> skillMap = YmlUtil.ymlToMap("skill/" + skill.getType());
        final int probability = fileConfiguration.getInt("probability", 0);
        int delay = fileConfiguration.getInt("delay", 20);
        int period = fileConfiguration.getInt("period", 60);
        if (probability <= 0) {
            return;
        }
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                if (livingEntity == null || !livingEntity.isValid()) {
                    this.cancel();
                    return;
                }
                if (!ProbabilityUtil.getInstance().pickIndex(probability, 100)) {
                    return;
                }
                HandySchedulerUtil.runTask(() -> Skill.spawnExecution(livingEntity, skillMap, skill));
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 20L * (long)delay, 20L * (long)period);
    }
}

