/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.skill;

import cn.handyplus.monster.lib.core.BeanUtil;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.skill.AttackArrow;
import cn.handyplus.monster.skill.Skill;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SpawnArrow
extends Skill {
    private Integer number;
    private Double speed;

    public static SpawnArrow getInstance(Map<String, Object> skillMap) {
        return BeanUtil.mapToBean(SpawnArrow.class, skillMap);
    }

    public void execution(LivingEntity livingEntity) {
        Location location;
        World world = livingEntity.getWorld();
        Collection playerCollectionList = world.getNearbyEntities(location = livingEntity.getLocation(), 30.0, 30.0, 30.0, s -> EntityType.PLAYER.equals((Object)s.getType()));
        if (CollUtil.isEmpty(playerCollectionList)) {
            return;
        }
        for (Entity player : playerCollectionList) {
            for (int i = 0; i < this.number; ++i) {
                Arrow arrow = (Arrow)livingEntity.launchProjectile(Arrow.class);
                AttackArrow.randomArrow(arrow);
                Vector direction = player.getLocation().toVector().subtract(livingEntity.getLocation().toVector()).normalize();
                arrow.setVelocity(direction.multiply(this.speed.doubleValue()));
            }
            super.sendMsg((Player)player, livingEntity.getCustomName());
        }
    }

    @Generated
    public Integer getNumber() {
        return this.number;
    }

    @Generated
    public Double getSpeed() {
        return this.speed;
    }

    @Generated
    public void setNumber(Integer number) {
        this.number = number;
    }

    @Generated
    public void setSpeed(Double speed) {
        this.speed = speed;
    }
}

