/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.skill;

import cn.handyplus.monster.lib.core.BeanUtil;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.util.LegacyUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.skill.Skill;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class SpawnPotion
extends Skill {
    private List<String> potionTypeList;

    public static SpawnPotion getInstance(Map<String, Object> skillMap) {
        return BeanUtil.mapToBean(SpawnPotion.class, skillMap);
    }

    public void execution(LivingEntity livingEntity) {
        Location location;
        if (CollUtil.isEmpty(this.potionTypeList)) {
            return;
        }
        World world = livingEntity.getWorld();
        Collection playerCollectionList = world.getNearbyEntities(location = livingEntity.getLocation(), 30.0, 30.0, 30.0, s -> EntityType.PLAYER.equals((Object)s.getType()));
        if (CollUtil.isEmpty(playerCollectionList)) {
            return;
        }
        for (Entity entity : playerCollectionList) {
            ItemStack lingeringPotion = this.dropLingeringPotion();
            ThrownPotion potionEntity = (ThrownPotion)world.spawn(entity.getLocation(), ThrownPotion.class);
            potionEntity.setItem(lingeringPotion);
            super.sendMsg((Player)entity, livingEntity.getCustomName());
        }
    }

    private ItemStack dropLingeringPotion() {
        ItemStack lingeringPotion = new ItemStack(Material.LINGERING_POTION);
        PotionMeta meta = (PotionMeta)lingeringPotion.getItemMeta();
        if (meta == null) {
            return new ItemStack(Material.AIR);
        }
        Collections.shuffle(this.potionTypeList);
        Optional<PotionType> potionTypeOptional = this.getPotionType(this.potionTypeList.get(0));
        if (!potionTypeOptional.isPresent()) {
            return new ItemStack(Material.AIR);
        }
        meta.setBasePotionType(potionTypeOptional.get());
        lingeringPotion.setItemMeta((ItemMeta)meta);
        return lingeringPotion;
    }

    public static PotionType randomPotion() {
        LegacyUtil.getPotionEffectTypeList();
        PotionType[] allPotionType = PotionType.values();
        Random random = new Random();
        return allPotionType[random.nextInt(allPotionType.length)];
    }

    private Optional<PotionType> getPotionType(String key) {
        if ("RANDOM".equalsIgnoreCase(key)) {
            return Optional.ofNullable(SpawnPotion.randomPotion());
        }
        try {
            return Optional.of(PotionType.valueOf((String)key.toUpperCase()));
        }
        catch (IllegalArgumentException var2) {
            MessageUtil.sendConsoleMessage("\u4e0d\u5b58\u5728\u7684\u836f\u6c34\u7c7b\u578b:" + key);
            return Optional.empty();
        }
    }

    @Generated
    public List<String> getPotionTypeList() {
        return this.potionTypeList;
    }

    @Generated
    public void setPotionTypeList(List<String> potionTypeList) {
        this.potionTypeList = potionTypeList;
    }
}

