/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.util;

import cn.handyplus.monster.command.admin.LookCommand;
import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.constants.MonsterTypeEnum;
import cn.handyplus.monster.constants.SkillEnum;
import cn.handyplus.monster.lib.constants.BaseConstants;
import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.util.HandyConfigUtil;
import cn.handyplus.monster.lib.util.LotteryUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.param.MonsterSpawnParam;
import cn.handyplus.monster.util.TaskUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigUtil {
    public static FileConfiguration DRAWING_CONFIG;
    public static FileConfiguration PREFIX_CONFIG;
    public static FileConfiguration FAST_SPAWN_CONFIG;
    public static Map<String, FileConfiguration> SPAWN_CONFIG_MAP;
    public static Map<String, FileConfiguration> ITEM_CONFIG_MAP;
    public static Map<String, FileConfiguration> DRAWINGS_CONFIG_MAP;
    public static Map<String, FileConfiguration> SKILL_CONFIG_MAP;

    public static void init() {
        HandyConfigUtil.loadConfig();
        HandyConfigUtil.loadLangConfig(true);
        DRAWING_CONFIG = HandyConfigUtil.load("gui/drawings.yml");
        PREFIX_CONFIG = HandyConfigUtil.load("prefix.yml");
        FAST_SPAWN_CONFIG = HandyConfigUtil.load("fastSpawn.yml");
        for (SkillEnum skillEnum : SkillEnum.values()) {
            HandyConfigUtil.load("skill/" + skillEnum.getType());
        }
        if (!HandyConfigUtil.exists("spawn/")) {
            HandyConfigUtil.load("spawn/example.yml");
        }
        if (!HandyConfigUtil.exists("item/")) {
            HandyConfigUtil.load("item/example.yml");
        }
        if (!HandyConfigUtil.exists("drawings/")) {
            HandyConfigUtil.load("drawings/example.yml");
        }
        SPAWN_CONFIG_MAP = HandyConfigUtil.loadDirectory("spawn/");
        ITEM_CONFIG_MAP = HandyConfigUtil.loadDirectory("item/");
        DRAWINGS_CONFIG_MAP = HandyConfigUtil.loadDirectory("drawings/");
        SKILL_CONFIG_MAP = HandyConfigUtil.loadDirectory("skill/");
        ConfigUtil.cacheConfig();
        TaskUtil.init();
        ConfigUtil.upConfig();
    }

    private static void cacheConfig() {
        ConfigUtil.setItemLottery();
        ConfigUtil.setEnchantment();
        ConfigUtil.setItem();
        ConfigUtil.setDrawings();
        ConfigUtil.setFastSpawn();
        ConfigUtil.setSpawn();
    }

    private static void setFastSpawn() {
        MonsterPlusConstants.FAST_SPAWN_LIST.clear();
        MonsterPlusConstants.FAST_SPAWN_LIST.addAll(FAST_SPAWN_CONFIG.getKeys(false));
    }

    private static void setDrawings() {
        MonsterPlusConstants.DRAWINGS_LIST.clear();
        if (DRAWINGS_CONFIG_MAP.isEmpty()) {
            return;
        }
        for (String fileName : DRAWINGS_CONFIG_MAP.keySet()) {
            FileConfiguration fileConfiguration = DRAWINGS_CONFIG_MAP.get(fileName);
            Set keys = fileConfiguration.getKeys(false);
            for (String key : keys) {
                MonsterPlusConstants.DRAWINGS_LIST.add(fileName + "_" + key);
            }
        }
    }

    private static void setItem() {
        MonsterPlusConstants.ITEM_LIST.clear();
        if (ITEM_CONFIG_MAP.isEmpty()) {
            return;
        }
        for (String fileName : ITEM_CONFIG_MAP.keySet()) {
            FileConfiguration fileConfiguration = ITEM_CONFIG_MAP.get(fileName);
            Set keys = fileConfiguration.getKeys(false);
            for (String key : keys) {
                MonsterPlusConstants.ITEM_LIST.add(fileName + "_" + key);
            }
        }
    }

    private static void setEnchantment() {
        ArrayList<Double> enchantment = new ArrayList<Double>();
        enchantment.add(BaseConstants.CONFIG.getDouble("enchantment"));
        enchantment.add(1.0 - BaseConstants.CONFIG.getDouble("enchantment"));
        MonsterPlusConstants.ENCHANTMENT_LOTTERY = new LotteryUtil(enchantment);
        MonsterPlusConstants.ENCHANTMENT_NUMBER = BaseConstants.CONFIG.getInt("enchantmentNumber");
    }

    private static void setItemLottery() {
        ArrayList<Double> lotteryList = new ArrayList<Double>();
        lotteryList.add(BaseConstants.CONFIG.getDouble("nether"));
        lotteryList.add(BaseConstants.CONFIG.getDouble("diamond"));
        lotteryList.add(BaseConstants.CONFIG.getDouble("iron"));
        lotteryList.add(BaseConstants.CONFIG.getDouble("golden"));
        lotteryList.add(BaseConstants.CONFIG.getDouble("chainMail"));
        lotteryList.add(BaseConstants.CONFIG.getDouble("leather"));
        lotteryList.add(BaseConstants.CONFIG.getDouble("none"));
        MonsterPlusConstants.EQUIPMENT_LOTTERY = new LotteryUtil(lotteryList);
    }

    private static void setSpawn() {
        MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.clear();
        LookCommand.removeAll();
        if (SPAWN_CONFIG_MAP.isEmpty()) {
            return;
        }
        for (String fileName : SPAWN_CONFIG_MAP.keySet()) {
            FileConfiguration fileConfiguration = SPAWN_CONFIG_MAP.get(fileName);
            Set keys = fileConfiguration.getKeys(false);
            for (String key : keys) {
                boolean enable = fileConfiguration.getBoolean(key + ".enable", true);
                if (!enable) continue;
                int time = fileConfiguration.getInt(key + ".time", 60);
                long lastSpawnTime = fileConfiguration.getLong(key + ".lastSpawnTime", System.currentTimeMillis());
                String entityType = fileConfiguration.getString(key + ".entityType", "").trim();
                int number = fileConfiguration.getInt(key + ".number", 1);
                int maxNumber = fileConfiguration.getInt(key + ".maxNumber", 1);
                String level = fileConfiguration.getString(key + ".level", "1,10");
                String world = fileConfiguration.getString(key + ".world", "").trim();
                String skinName = fileConfiguration.getString(key + ".skinName", "").trim();
                String displayName = fileConfiguration.getString(key + ".displayName", "").trim();
                double x = fileConfiguration.getDouble(key + ".x");
                double y = fileConfiguration.getDouble(key + ".y");
                double z = fileConfiguration.getDouble(key + ".z");
                List dropList = fileConfiguration.getStringList(key + ".dropList");
                List skill = fileConfiguration.getStringList(key + ".skill");
                List apAttributeList = fileConfiguration.getStringList(key + ".apAttribute");
                List attributeList = fileConfiguration.getStringList(key + ".attribute");
                boolean hdTip = fileConfiguration.getBoolean(key + ".hdTip", false);
                List spawnMessage = fileConfiguration.getStringList(key + ".spawnMessage");
                List deathMessages = fileConfiguration.getStringList(key + ".deathMessages");
                Optional<MonsterTypeEnum> monsterTypeEnumOptional = MonsterTypeEnum.getEnum(entityType);
                if (!monsterTypeEnumOptional.isPresent()) {
                    MessageUtil.sendConsoleMessage("&4\u52a0\u8f7d\u602a\u7269" + key + "\u5f02\u5e38,\u539f\u56e0: \u6ca1\u6709 " + entityType + " \u7c7b\u578b");
                    continue;
                }
                World bukkitWorld = Bukkit.getWorld((String)world);
                if (bukkitWorld == null) {
                    MessageUtil.sendConsoleMessage("&4\u52a0\u8f7d\u602a\u7269" + key + "\u5f02\u5e38,\u539f\u56e0: \u6ca1\u6709 " + world + " \u4e16\u754c");
                    continue;
                }
                MonsterSpawnParam monsterSpawnParam = new MonsterSpawnParam();
                monsterSpawnParam.setEnable(true);
                monsterSpawnParam.setDisplayName(displayName);
                monsterSpawnParam.setTime(time);
                monsterSpawnParam.setLastSpawnTime(lastSpawnTime);
                monsterSpawnParam.setEntityType(entityType);
                monsterSpawnParam.setNumber(number);
                monsterSpawnParam.setMaxNumber(maxNumber);
                monsterSpawnParam.setLevel(level);
                monsterSpawnParam.setWorld(world);
                monsterSpawnParam.setX(x);
                monsterSpawnParam.setY(y);
                monsterSpawnParam.setZ(z);
                monsterSpawnParam.setDropList(dropList);
                monsterSpawnParam.setSkill(skill);
                monsterSpawnParam.setApAttributeList(apAttributeList);
                monsterSpawnParam.setLevelList(StrUtil.strToIntList(level));
                monsterSpawnParam.setLocation(new Location(bukkitWorld, x, y, z));
                monsterSpawnParam.setFileName(fileName);
                monsterSpawnParam.setKey(key);
                monsterSpawnParam.setMapKey(fileName.replace(".yml", "") + "#" + key);
                monsterSpawnParam.setSkinName(skinName);
                monsterSpawnParam.setAttributeList(attributeList);
                monsterSpawnParam.setRemoveWhenFarAway(false);
                monsterSpawnParam.setHdTip(hdTip);
                monsterSpawnParam.setSpawnMessage(spawnMessage);
                monsterSpawnParam.setDeathMessages(deathMessages);
                MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.put(monsterSpawnParam.getMapKey(), monsterSpawnParam);
            }
        }
    }

    public static void setLastSpawnTime(String fileName, String key) {
        FileConfiguration configuration = SPAWN_CONFIG_MAP.get(fileName);
        if (configuration == null) {
            return;
        }
        HandyConfigUtil.setPath(configuration, key + ".lastSpawnTime", System.currentTimeMillis(), null, "spawn/" + fileName);
    }

    private static void upConfig() {
        String language = "languages/" + BaseConstants.CONFIG.getString("language") + ".yml";
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.1", "\u7cbe\u82f1I", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.2", "\u7cbe\u82f1II", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.3", "\u7cbe\u82f1III", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.4", "\u7cbe\u82f1IV", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.5", "\u7cbe\u82f1V", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.6", "\u7cbe\u82f1VI", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.7", "\u7cbe\u82f1VII", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.8", "\u7cbe\u82f1VIII", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.9", "\u7cbe\u82f1IX", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "elite.10", "\u7cbe\u82f1X", null, language);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.LANG_CONFIG, "dropTip", "&8[&c!&8] &7\u4e3a\u4e86\u9632\u6b62\u8bef\u4e22\u5931,\u8be5\u7269\u54c1\u65e0\u6cd5\u4f7f\u7528Q\u4e22\u5f03!", null, language);
        HandyConfigUtil.loadLangConfig(true);
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "isAnvil", true, Collections.singletonList("\u662f\u5426\u5f00\u542f\u94c1\u7827\u65e0\u6cd5\u4fee\u6539\u672c\u63d2\u4ef6\u7269\u54c1\u529f\u80fd"), "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "autoPickup", false, Collections.singletonList("\u662f\u5426\u5f00\u542f\u6389\u843d\u7269\u76f4\u63a5\u8fdb\u5165\u51fb\u6740\u8005\u80cc\u5305"), "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "isDropItem", true, Collections.singletonList("\u662f\u5426\u5f00\u542f\u65e0\u6cd5\u4e22\u5f03\u672c\u63d2\u4ef6\u7269\u54c1\u529f\u80fd"), "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "dropHdTip", true, Collections.singletonList("\u662f\u5426\u5f00\u542f\u672c\u63d2\u4ef6\u6389\u843d\u7269\u5168\u606f\u663e\u793a"), "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "isPickupItem", true, Collections.singletonList("\u662f\u5426\u5f00\u542f\u672c\u63d2\u4ef6\u602a\u7269\u7981\u6b62\u6361\u7269\u54c1\u529f\u80fd"), "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "buffType", "attribute_plus", Collections.singletonList("buff\u7c7b\u578b \u76ee\u524d\u53ea\u652f\u6301 attribute_plus \u6216 sx_attribute \u6216 AttributeSystem \u6216 MythicLib \u6216 SagaLoreStats"), "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "buffType", "attribute_plus", Collections.singletonList("buff\u7c7b\u578b \u76ee\u524d\u53ea\u652f\u6301 attribute_plus \u6216 sx_attribute \u6216 AttributeSystem \u6216 MythicLib \u6216 SagaLoreStats"), "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "isTrimMaterial", true, Collections.singletonList("\u662f\u5426\u5f00\u542f\u672c\u63d2\u4ef6\u602a\u7269\u88c5\u5907\u968f\u673a\u76d4\u7532\u7eb9\u9970\u529f\u80fd 1.20+\u751f\u6548"), "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "spawnChance.all", 0.1, null, "config.yml");
        HandyConfigUtil.setPathIsNotContains(BaseConstants.CONFIG, "isVanishing", true, Collections.singletonList("\u662f\u5426\u5f00\u542f\u6d88\u5931\u8bc5\u5492\u4f1a\u6389\u843d\u529f\u80fd"), "config.yml");
        HandyConfigUtil.loadConfig();
    }

    static {
        SPAWN_CONFIG_MAP = new HashMap<String, FileConfiguration>();
        ITEM_CONFIG_MAP = new HashMap<String, FileConfiguration>();
        DRAWINGS_CONFIG_MAP = new HashMap<String, FileConfiguration>();
        SKILL_CONFIG_MAP = new HashMap<String, FileConfiguration>();
    }
}

