/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.util;

import cn.handyplus.monster.MonsterPlus;
import cn.handyplus.monster.constants.MonsterTypeEnum;
import cn.handyplus.monster.core.MonsterDamage;
import cn.handyplus.monster.core.MonsterEquipment;
import cn.handyplus.monster.core.MonsterLevel;
import cn.handyplus.monster.core.MonsterPotionEffect;
import cn.handyplus.monster.core.MonsterScoreboardTag;
import cn.handyplus.monster.hook.LibsDisguisesHook;
import cn.handyplus.monster.hook.PlayerIntensifyHook;
import cn.handyplus.monster.lib.attribute.AttributeEnum;
import cn.handyplus.monster.lib.attribute.AttributeUtil;
import cn.handyplus.monster.lib.constants.AttributeCompatEnum;
import cn.handyplus.monster.lib.constants.BaseConstants;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.core.JsonUtil;
import cn.handyplus.monster.lib.core.MapUtil;
import cn.handyplus.monster.lib.core.NumberUtil;
import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.HandyConfigUtil;
import cn.handyplus.monster.lib.util.ItemMetaUtil;
import cn.handyplus.monster.lib.util.ItemStackUtil;
import cn.handyplus.monster.lib.util.LegacyUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.lib.util.ProbabilityUtil;
import cn.handyplus.monster.param.DrawingsParam;
import cn.handyplus.monster.param.MonsterSpawnParam;
import cn.handyplus.monster.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class MonsterPlusUtil {
    public static void spawnEntity(Location location, MonsterTypeEnum monsterTypeEnum) {
        MonsterPlusUtil.spawnEntity(location, monsterTypeEnum, -1, null, null, null, null, null, null, null, true);
    }

    public static void spawnEntity(Location location, MonsterSpawnParam monsterSpawnParam) {
        MonsterTypeEnum monsterTypeEnum = MonsterTypeEnum.getEnumThrow(monsterSpawnParam.getEntityType());
        List<Integer> levelList = monsterSpawnParam.getLevelList();
        int level = levelList.get(0);
        if (levelList.size() > 1) {
            level = new Random().nextInt(levelList.get(1) - levelList.get(0) + 1) + levelList.get(0);
        }
        MonsterPlusUtil.spawnEntity(location, monsterTypeEnum, level, monsterSpawnParam.getDropList(), monsterSpawnParam.getSkill(), monsterSpawnParam.getApAttributeList(), monsterSpawnParam.getDisplayName(), monsterSpawnParam.getAttributeList(), monsterSpawnParam.getMapKey(), monsterSpawnParam.getSkinName(), monsterSpawnParam.isRemoveWhenFarAway());
    }

    public static LivingEntity spawnEntity(Location location, MonsterTypeEnum monsterTypeEnum, int level, List<String> drops, List<String> skill, List<String> apList, String displayName, List<String> attrList, String mapKey, String skinName, boolean removeWhenFarAway) {
        String buffType;
        AttributeEnum attributeEnum;
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        Entity entity = world.spawnEntity(location, monsterTypeEnum.getEntityType());
        LivingEntity livingEntity = (LivingEntity)entity;
        MonsterLevel.setLevel(livingEntity, monsterTypeEnum.getDesc(), level, drops, skill, displayName, removeWhenFarAway);
        if (StrUtil.isNotEmpty(mapKey)) {
            MonsterScoreboardTag.addScoreboardTag(livingEntity, "key=.=" + mapKey);
        }
        if (monsterTypeEnum.getEquipment().booleanValue()) {
            MonsterEquipment.setEquipment(livingEntity, monsterTypeEnum);
        }
        if (monsterTypeEnum.getPotionEffect().booleanValue()) {
            MonsterPotionEffect.setPotionEffect(livingEntity);
        }
        if (CollUtil.isNotEmpty(apList) && (attributeEnum = AttributeEnum.getEnum(buffType = BaseConstants.CONFIG.getString("buffType"))) != null) {
            AttributeUtil.getInstance().addAttribute(livingEntity, apList, attributeEnum);
        }
        if (CollUtil.isNotEmpty(attrList)) {
            for (String attr : attrList) {
                List<String> attributeList = StrUtil.strToStrList(attr, ":");
                try {
                    AttributeCompatEnum attributeCompatEnum = AttributeCompatEnum.getByName(attributeList.get(0));
                    AttributeInstance attributeInstance = livingEntity.getAttribute(attributeCompatEnum.resolve());
                    if (attributeInstance == null) continue;
                    attributeInstance.setBaseValue(NumberUtil.isNumericToDouble(attributeList.get(1), 1.0).doubleValue());
                    if (!AttributeCompatEnum.MAX_HEALTH.equals((Object)attributeCompatEnum)) continue;
                    livingEntity.setHealth(attributeInstance.getValue());
                    livingEntity.setMaxHealth(attributeInstance.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("\u914d\u7f6e\u5f02\u5e38,\u6ca1\u6709\u5bf9\u5e94\u5c5e\u6027:" + attributeList.get(0).toLowerCase());
                }
            }
        }
        LibsDisguisesHook.playerDisguise(livingEntity, skinName);
        return livingEntity;
    }

    public static void spawnEntity(LivingEntity livingEntity) {
        Optional<MonsterTypeEnum> monsterTypeEnumOptional = MonsterTypeEnum.getEnumNotOther(LegacyUtil.getEntityTypeName(livingEntity.getType()));
        if (!monsterTypeEnumOptional.isPresent()) {
            return;
        }
        MonsterTypeEnum monsterTypeEnum = monsterTypeEnumOptional.get();
        double allChance = BaseConstants.CONFIG.getDouble("spawnChance.all", 1.0);
        double chance = BaseConstants.CONFIG.getDouble("spawnChance." + monsterTypeEnum.getType().toLowerCase(), allChance);
        if (!ProbabilityUtil.getInstance().pickIndex(chance)) {
            return;
        }
        MonsterLevel.setLevel(livingEntity, monsterTypeEnum.getDesc(), -1);
        if (monsterTypeEnum.getEquipment().booleanValue()) {
            MonsterEquipment.setEquipment(livingEntity, monsterTypeEnum);
        }
        if (monsterTypeEnum.getPotionEffect().booleanValue()) {
            MonsterPotionEffect.setPotionEffect(livingEntity);
        }
    }

    public static ItemStack spawnItem(String fileName, String key) {
        FileConfiguration configuration = ConfigUtil.ITEM_CONFIG_MAP.get(fileName);
        if (configuration == null) {
            MessageUtil.sendConsoleMessage("\u914d\u7f6e\u9519\u8bef,\u7269\u54c1\u6587\u4ef6\u540d\u4e0d\u5b58\u5728:" + fileName);
            return new ItemStack(Material.AIR);
        }
        String material = configuration.getString(key + ".material");
        if (StrUtil.isEmpty(material)) {
            MessageUtil.sendConsoleMessage("\u914d\u7f6e\u9519\u8bef,\u7269\u54c1key\u4e0d\u5b58\u5728:" + key);
            return new ItemStack(Material.AIR);
        }
        String name = configuration.getString(key + ".name");
        int customModelData = configuration.getInt(key + ".custom-model-data");
        boolean unbreakable = configuration.getBoolean(key + ".unbreakable");
        List loreList = configuration.getStringList(key + ".lore");
        List enchantmentList = configuration.getStringList(key + ".enchantment");
        boolean isEnchant = configuration.getBoolean(key + ".isEnchant", false);
        boolean hideFlag = configuration.getBoolean(key + ".hideFlag", false);
        String tooltipStyle = configuration.getString(key + ".tooltipStyle");
        String itemModel = configuration.getString(key + ".itemModel");
        ItemStack itemStack = ItemStackUtil.getItemStack(material, name, loreList, isEnchant, customModelData, hideFlag, null, false, null, tooltipStyle, itemModel);
        if (CollUtil.isNotEmpty(enchantmentList)) {
            for (String enchantmentStr : enchantmentList) {
                String[] split = enchantmentStr.split(":");
                String enchantmentName = split[0].trim();
                int level = Integer.parseInt(split[1].trim());
                Enchantment enchantment = LegacyUtil.getEnchantmentByName(enchantmentName);
                if (enchantment == null) continue;
                itemStack.addUnsafeEnchantment(enchantment, level);
            }
        }
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        if (unbreakable) {
            itemMeta.setUnbreakable(true);
        }
        Set<String> slotKey = HandyConfigUtil.getKey(configuration, key + ".attributes");
        for (String slot : slotKey) {
            List attributeList = configuration.getStringList(key + ".attributes." + slot);
            EquipmentSlot equipmentSlot = EquipmentSlot.valueOf((String)slot.toUpperCase());
            for (String attribute : attributeList) {
                List<String> attrList = StrUtil.strToStrList(attribute, ":");
                String attr = attrList.get(0);
                double amount = NumberUtil.isNumericToDouble(attrList.get(1), 0.0);
                AttributeModifier genericArmor = LegacyUtil.getAttributeModifier(attr, amount, AttributeModifier.Operation.ADD_NUMBER, equipmentSlot);
                itemMeta.addAttributeModifier(AttributeCompatEnum.getByName(attr).resolve(), genericArmor);
            }
        }
        ItemMetaUtil.setPersistentData(itemMeta, Boolean.TRUE.toString(), "MonsterPlus");
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack spawnDrawings(String fileName, String key) {
        FileConfiguration configuration = ConfigUtil.DRAWINGS_CONFIG_MAP.get(fileName);
        String material = configuration.getString(key + ".material");
        if (StrUtil.isEmpty(material)) {
            return new ItemStack(Material.AIR);
        }
        String name = configuration.getString(key + ".name");
        int customModelData = configuration.getInt(key + ".custom-model-data");
        boolean isEnchant = configuration.getBoolean(key + ".isEnchant");
        List loreList = configuration.getStringList(key + ".lore");
        String item = configuration.getString(key + ".item", "");
        List needList = configuration.getStringList(key + ".need");
        List commandList = configuration.getStringList(key + ".commands");
        List<String> newLoreList = ItemStackUtil.loreBatchReplaceMap(loreList, MonsterPlusUtil.getLoreBatchReplaceMap(needList), "");
        String tooltipStyle = configuration.getString(key + ".tooltipStyle");
        String itemModel = configuration.getString(key + ".itemModel");
        ItemStack itemStack = ItemStackUtil.getItemStack(material, name, newLoreList, isEnchant, customModelData, false, null, false, null, tooltipStyle, itemModel);
        DrawingsParam drawingsParam = new DrawingsParam();
        drawingsParam.setNeedList(needList);
        drawingsParam.setItem(item);
        drawingsParam.setCommandList(commandList);
        ItemStackUtil.setPersistentData(itemStack, JsonUtil.toJson(drawingsParam), "drawings");
        return itemStack;
    }

    public static Map<ItemStack, Integer> getNeedItemList(List<String> itemList) {
        HashMap<ItemStack, Integer> itemStackMap = MapUtil.newHashMapWithExpectedSize(itemList.size());
        for (String item : itemList) {
            String[] split;
            if (item.contains("[ITEM]")) {
                item = item.replace("[ITEM]", "");
                String[] itemStr = item.split("_");
                String itemFileName = itemStr[0].trim();
                String itemKeyStr = itemStr[1].trim();
                String[] split2 = itemKeyStr.split(":");
                String itemKey = split2[0].trim();
                ItemStack spawnItemStack = MonsterPlusUtil.spawnItem(itemFileName, itemKey);
                itemStackMap.put(spawnItemStack, Integer.parseInt(split2[1].trim()));
                continue;
            }
            if (item.contains("[CE]")) {
                if (!MonsterPlus.USE_CE) {
                    throw new RuntimeException("not fount CE");
                }
                split = (item = item.replace("[CE]", "")).split(":");
                CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)split[0].trim(), (String)split[1].trim()));
                if (customItem == null) continue;
                itemStackMap.put((ItemStack)customItem.buildItemStack(), Integer.parseInt(split[2].trim()));
                continue;
            }
            split = item.split(":");
            String type = split[0].trim();
            itemStackMap.put(new ItemStack(ItemStackUtil.getMaterial(type)), Integer.parseInt(split[1].trim()));
        }
        return itemStackMap;
    }

    public static List<ItemStack> getDropItemList(List<String> itemList, UUID monsterId) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (String item : itemList) {
            String[] split;
            ItemStack itemStack;
            if (item.contains("[ITEM]")) {
                itemStack = MonsterPlusUtil.getItemStack(item, "[ITEM]");
                if (itemStack == null) continue;
                itemStackList.add(itemStack);
                continue;
            }
            if (item.contains("[DRAWINGS]")) {
                itemStack = MonsterPlusUtil.getDrawings(item, "[DRAWINGS]");
                if (itemStack == null) continue;
                itemStackList.add(itemStack);
                continue;
            }
            if (item.contains("[CE]")) {
                if (!MonsterPlus.USE_CE) {
                    throw new RuntimeException("not fount CE");
                }
                itemStack = MonsterPlusUtil.getCraftEngine(item, "[CE]");
                if (itemStack == null) continue;
                itemStackList.add(itemStack);
                continue;
            }
            if (item.contains("[PlayerIntensify]")) {
                itemStack = MonsterPlusUtil.getIntensify(item, "[PlayerIntensify]");
                if (itemStack == null) continue;
                itemStackList.add(itemStack);
                continue;
            }
            if (item.contains("[COMMAND]")) {
                item = item.replace("[COMMAND]", "");
                split = item.split(":");
                String command = split[0].trim();
                if (split.length > 1) {
                    double probability = Double.parseDouble(split[1].trim());
                    if (!ProbabilityUtil.getInstance().pickIndex(probability)) continue;
                }
                List<Map.Entry<String, Double>> topThreePlayers = MonsterDamage.getTopThreePlayers(monsterId);
                for (int i = 0; i < 3; ++i) {
                    String rankPrefix;
                    Map.Entry<String, Double> entry = topThreePlayers.get(i);
                    if ("\u65e0".equals(entry.getKey()) || !command.contains(rankPrefix = MonsterDamage.getRankPrefix(i) + "Player")) continue;
                    String playerName = entry.getKey();
                    command = StrUtil.replace(command, rankPrefix, playerName);
                    PlayerSchedulerUtil.dispatchCommand(command);
                }
                continue;
            }
            if (item.contains("[") && item.contains("]")) continue;
            split = item.split(":");
            String type = split[0].trim();
            int amount = Integer.parseInt(split[1].trim());
            double probability = Double.parseDouble(split[2].trim());
            if (!ProbabilityUtil.getInstance().pickIndex(probability)) continue;
            itemStackList.add(new ItemStack(ItemStackUtil.getMaterial(type), amount));
        }
        return itemStackList;
    }

    @Nullable
    private static ItemStack getIntensify(String item, String replaceStr) {
        ItemStack itemStack;
        item = item.replace(replaceStr, "");
        String[] split = item.split(":");
        String type = split[0].trim();
        int amount = Integer.parseInt(split[1].trim());
        double probability = Double.parseDouble(split[2].trim());
        if (!ProbabilityUtil.getInstance().pickIndex(probability)) {
            return null;
        }
        if (type.contains("intensifyCard-")) {
            String[] typeStr = type.split("-");
            Integer level = Integer.parseInt(typeStr[1].trim());
            String intensifyCard = typeStr[2].trim();
            itemStack = PlayerIntensifyHook.giveIntensifyCard(level, intensifyCard);
        } else {
            itemStack = PlayerIntensifyHook.getItem(type);
        }
        itemStack.setAmount(amount);
        return itemStack;
    }

    @Nullable
    private static ItemStack getDrawings(String item, String replaceStr) {
        item = item.replace(replaceStr, "");
        String[] itemStr = item.split("_");
        String itemFileName = itemStr[0].trim();
        String itemKeyStr = itemStr[1].trim();
        String[] split = itemKeyStr.split(":");
        String itemKey = split[0].trim();
        int amount = Integer.parseInt(split[1].trim());
        double probability = Double.parseDouble(split[2].trim());
        if (!ProbabilityUtil.getInstance().pickIndex(probability)) {
            return null;
        }
        ItemStack itemStack = MonsterPlusUtil.spawnDrawings(itemFileName, itemKey);
        itemStack.setAmount(amount);
        return itemStack;
    }

    @Nullable
    private static ItemStack getCraftEngine(String item, String replaceStr) {
        String value;
        String[] itemStr = (item = item.replace(replaceStr, "")).split(":");
        String namespace = itemStr[0].trim();
        CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)namespace, (String)(value = itemStr[1].trim())));
        if (customItem == null) {
            return null;
        }
        int amount = Integer.parseInt(itemStr[2].trim());
        double probability = Double.parseDouble(itemStr[3].trim());
        if (!ProbabilityUtil.getInstance().pickIndex(probability)) {
            return null;
        }
        ItemStack itemStack = (ItemStack)customItem.buildItemStack();
        itemStack.setAmount(amount);
        return itemStack;
    }

    @Nullable
    private static ItemStack getItemStack(String item, String replaceStr) {
        item = item.replace(replaceStr, "");
        String[] itemStr = item.split("_");
        String itemFileName = itemStr[0].trim();
        String itemKeyStr = itemStr[1].trim();
        String[] split = itemKeyStr.split(":");
        String itemKey = split[0].trim();
        int amount = Integer.parseInt(split[1].trim());
        double probability = Double.parseDouble(split[2].trim());
        if (!ProbabilityUtil.getInstance().pickIndex(probability)) {
            return null;
        }
        ItemStack itemStack = MonsterPlusUtil.spawnItem(itemFileName, itemKey);
        itemStack.setAmount(amount);
        return itemStack;
    }

    public static Map<Integer, List<ItemStack>> getTopDropItemList(List<Map.Entry<String, Double>> topThreePlayers, List<String> itemList) {
        HashMap<Integer, List<ItemStack>> itemStackListMap = new HashMap<Integer, List<ItemStack>>();
        for (int i = 0; i < 3; ++i) {
            itemStackListMap.put(i, new ArrayList());
            Map.Entry<String, Double> entry = topThreePlayers.get(i);
            if ("\u65e0".equals(entry.getKey())) continue;
            String rankPrefix = "[" + MonsterDamage.getRankPrefix(i).toUpperCase();
            for (String item : itemList) {
                ItemStack itemStack;
                String itemStr;
                if (item.contains(itemStr = rankPrefix + "[ITEM]".replace("[", "_"))) {
                    ItemStack itemStack2 = MonsterPlusUtil.getItemStack(item, itemStr);
                    if (itemStack2 == null) continue;
                    ((List)itemStackListMap.get(i)).add(itemStack2);
                    continue;
                }
                String drawingsStr = rankPrefix + "[DRAWINGS]".replace("[", "_");
                if (item.contains(drawingsStr)) {
                    ItemStack itemStack3 = MonsterPlusUtil.getDrawings(item, drawingsStr);
                    if (itemStack3 == null) continue;
                    ((List)itemStackListMap.get(i)).add(itemStack3);
                    continue;
                }
                String playerIntensifyStr = rankPrefix + "[PlayerIntensify]".replace("[", "_");
                if (!item.contains(playerIntensifyStr) || (itemStack = MonsterPlusUtil.getIntensify(item, playerIntensifyStr)) == null) continue;
                ((List)itemStackListMap.get(i)).add(itemStack);
            }
        }
        return itemStackListMap;
    }

    public static Map<ItemStack, Integer> getDrawingsItem(String item) {
        int amount = 1;
        if (item.contains("[ITEM]")) {
            List<String> itemList = StrUtil.strToStrList(item, ":");
            if (itemList.size() > 1) {
                amount = Integer.parseInt(itemList.get(1));
            }
            item = item.replace("[ITEM]", "");
            String[] itemStr = item.split("_");
            String itemFileName = itemStr[0].trim();
            String itemKey = itemStr[1].trim();
            return MapUtil.of(MonsterPlusUtil.spawnItem(itemFileName, itemKey), amount);
        }
        if (item.contains("[CE]")) {
            CustomItem customItem;
            if (!MonsterPlus.USE_CE) {
                throw new RuntimeException("not fount CE");
            }
            String[] split = (item = item.replace("[CE]", "")).split(":");
            if (split.length > 2) {
                amount = Integer.parseInt(split[2].trim());
            }
            if ((customItem = CraftEngineItems.byId((Key)Key.of((String)split[0].trim(), (String)split[1].trim()))) != null) {
                return MapUtil.of((ItemStack)customItem.buildItemStack(), amount);
            }
            return MapUtil.of(new ItemStack(Material.AIR), amount);
        }
        if (item.contains("[PlayerIntensify]")) {
            ItemStack itemStack;
            String type;
            List<String> itemList = StrUtil.strToStrList(item, ":");
            if (itemList.size() > 1) {
                amount = Integer.parseInt(itemList.get(1));
            }
            if ((type = item.replace("[PlayerIntensify]", "")).contains("intensifyCard-")) {
                String[] typeStr = type.split("-");
                Integer level = Integer.parseInt(typeStr[1].trim());
                String intensifyCard = typeStr[2].trim();
                itemStack = PlayerIntensifyHook.giveIntensifyCard(level, intensifyCard);
            } else {
                itemStack = PlayerIntensifyHook.getItem(type);
            }
            return MapUtil.of(itemStack, amount);
        }
        return MapUtil.of(new ItemStack(ItemStackUtil.getMaterial(item)), amount);
    }

    private static Map<String, List<String>> getLoreBatchReplaceMap(List<String> itemList) {
        HashMap<String, List<String>> map = MapUtil.newHashMapWithExpectedSize(1);
        map.put("item", MonsterPlusUtil.itemReplaceMap(itemList));
        return map;
    }

    private static List<String> itemReplaceMap(List<String> needList) {
        ArrayList<String> loreList = new ArrayList<String>();
        Map<ItemStack, Integer> needItemList = MonsterPlusUtil.getNeedItemList(needList);
        for (ItemStack itemStack : needItemList.keySet()) {
            Integer number = needItemList.get(itemStack);
            String displayName = BaseUtil.getDisplayName(itemStack);
            loreList.add(displayName + " : " + number);
        }
        return loreList;
    }

    public static Player getPlayer(CommandSender sender, String name) {
        if ("${player}".equalsIgnoreCase(name)) {
            if (BaseUtil.isNotPlayer(sender).booleanValue()) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
                return null;
            }
            return (Player)sender;
        }
        return BaseUtil.getOnlinePlayer(name).orElse(null);
    }
}

