/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.util;

import cn.handyplus.monster.MonsterPlus;
import cn.handyplus.monster.command.admin.LookCommand;
import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.constants.MonsterTypeEnum;
import cn.handyplus.monster.core.MonsterDamage;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.core.DateUtil;
import cn.handyplus.monster.lib.core.MapUtil;
import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.expand.adapter.HandyRunnable;
import cn.handyplus.monster.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.monster.lib.hologram.HdUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.param.MonsterSpawnParam;
import cn.handyplus.monster.util.ConfigUtil;
import cn.handyplus.monster.util.MonsterPlusUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class TaskUtil {
    public static void init() {
        HandySchedulerUtil.cancelTask();
        HdUtil.deleteAll();
        LookCommand.removeAll();
        MonsterPlusConstants.PLAYER_DAMAGE_MAP.clear();
        if (MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        for (String mapKey : MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.keySet()) {
            MonsterSpawnParam monsterSpawnParam = MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.get(mapKey);
            int time = monsterSpawnParam.getTime();
            long countdown = 0L;
            if ((long)time > (now - monsterSpawnParam.getLastSpawnTime()) / 1000L) {
                countdown = (long)time - (now - monsterSpawnParam.getLastSpawnTime()) / 1000L;
            }
            MessageUtil.sendConsoleDebugMessage("\u5b9a\u65f6\u4efb\u52a1:\u751f\u6210\u602a\u7269:" + mapKey + ",\u672c\u6b21\u751f\u6210\u5ef6\u8fdf:" + countdown + ",\u5faa\u73af\u5b9a\u65f6:" + time);
            TaskUtil.spawnRunTaskTimer(mapKey, countdown, time);
        }
    }

    public static void spawnRunTaskTimer(final String mapKey, long countdown, final int time) {
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                Location location;
                MonsterSpawnParam monsterSpawnParam = MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.get(mapKey);
                if (monsterSpawnParam == null) {
                    MessageUtil.sendConsoleDebugMessage("\u5b9a\u65f6\u4efb\u52a1:\u4e0d\u751f\u6210\u602a\u7269:" + mapKey + ",\u539f\u56e0:\u672a\u627e\u5230\u8bb0\u5f55");
                    this.cancel();
                    return;
                }
                if (!monsterSpawnParam.getEnable().booleanValue()) {
                    MessageUtil.sendConsoleDebugMessage("\u5b9a\u65f6\u4efb\u52a1:\u4e0d\u751f\u6210\u602a\u7269:" + mapKey + ",\u539f\u56e0:\u672a\u5f00\u542f");
                    this.cancel();
                    return;
                }
                Optional<MonsterTypeEnum> monsterTypeEnumOptional = MonsterTypeEnum.getEnum(monsterSpawnParam.getEntityType());
                if (!monsterTypeEnumOptional.isPresent()) {
                    MessageUtil.sendConsoleMessage("\u5b9a\u65f6\u4efb\u52a1:\u4e0d\u751f\u6210\u602a\u7269:" + mapKey + ",\u539f\u56e0:\u6ca1\u6709\u8fd9\u6837\u7684\u602a\u7269\u7c7b\u578b" + monsterSpawnParam.getEntityType());
                    this.cancel();
                    return;
                }
                MonsterTypeEnum monsterTypeEnum = monsterTypeEnumOptional.get();
                List<UUID> uuids = MonsterPlusConstants.MONSTER_ENTITY_MAP.get(mapKey);
                if (CollUtil.isEmpty(uuids)) {
                    uuids = new ArrayList<UUID>();
                }
                if (!(location = monsterSpawnParam.getLocation()).getChunk().isLoaded()) {
                    MessageUtil.sendConsoleDebugMessage("\u5b9a\u65f6\u4efb\u52a1:\u4e0d\u751f\u6210\u602a\u7269:" + mapKey + ",\u539f\u56e0:\u533a\u5757\u672a\u52a0\u8f7d");
                    return;
                }
                World world = location.getWorld();
                if (world == null) {
                    MessageUtil.sendConsoleDebugMessage("\u5b9a\u65f6\u4efb\u52a1:\u4e0d\u751f\u6210\u602a\u7269:" + mapKey + ",\u539f\u56e0:\u4e16\u754c\u672a\u627e\u5230");
                    return;
                }
                Integer maxNumber = monsterSpawnParam.getMaxNumber();
                if (uuids.size() >= maxNumber) {
                    MessageUtil.sendConsoleDebugMessage("\u5b9a\u65f6\u4efb\u52a1:\u4e0d\u751f\u6210\u602a\u7269:" + mapKey + ",\u539f\u56e0:\u5df2\u8fbe\u5230\u6700\u5927\u6570\u91cf" + uuids.size());
                    TaskUtil.createHd(monsterSpawnParam.isHdTip(), location, time, "&a\u5f53\u524d\u5df2\u8fbe\u53ef\u5237\u65b0\u6700\u5927\u6570\u91cf", monsterSpawnParam.getKey());
                    return;
                }
                int generateNumber = monsterSpawnParam.getNumber();
                if (generateNumber > maxNumber - uuids.size()) {
                    generateNumber = maxNumber - uuids.size();
                }
                String hdText = null;
                if (generateNumber + uuids.size() >= monsterSpawnParam.getMaxNumber()) {
                    hdText = "&a\u5f53\u524d\u5df2\u8fbe\u53ef\u5237\u65b0\u6700\u5927\u6570\u91cf";
                }
                MessageUtil.sendConsoleDebugMessage("\u5b9a\u65f6\u4efb\u52a1:\u751f\u6210\u602a\u7269:" + mapKey + ",\u5df2\u751f\u6210\u6570\u91cf:" + uuids.size() + ",\u672c\u6b21\u751f\u6210\u6570\u91cf" + generateNumber);
                List<Integer> levelList = monsterSpawnParam.getLevelList();
                int level = levelList.get(0);
                if (levelList.size() > 1) {
                    level = new Random().nextInt(levelList.get(1) - levelList.get(0) + 1) + levelList.get(0);
                }
                MessageUtil.sendConsoleDebugMessage("\u5b9a\u65f6\u4efb\u52a1:\u751f\u6210\u602a\u7269:" + mapKey + ",\u672c\u6b21\u751f\u6210\u7b49\u7ea7" + level);
                for (int i = 0; i < generateNumber; ++i) {
                    LivingEntity livingEntity = MonsterPlusUtil.spawnEntity(location, monsterTypeEnum, level, monsterSpawnParam.getDropList(), monsterSpawnParam.getSkill(), monsterSpawnParam.getApAttributeList(), monsterSpawnParam.getDisplayName(), monsterSpawnParam.getAttributeList(), mapKey, monsterSpawnParam.getSkinName(), monsterSpawnParam.isRemoveWhenFarAway());
                    if (livingEntity == null) continue;
                    uuids.add(livingEntity.getUniqueId());
                    List<String> spawnMessage = MonsterDamage.replaceVariables(monsterSpawnParam.getSpawnMessage(), MapUtil.of("name", livingEntity.getCustomName()));
                    MessageUtil.sendAllMessage(spawnMessage);
                }
                MonsterPlusConstants.MONSTER_ENTITY_MAP.put(mapKey, uuids);
                ConfigUtil.setLastSpawnTime(monsterSpawnParam.getFileName(), monsterSpawnParam.getKey());
                TaskUtil.createHd(monsterSpawnParam.isHdTip(), location, time, hdText, monsterSpawnParam.getKey());
                location.getChunk().addPluginChunkTicket((Plugin)MonsterPlus.INSTANCE);
            }
        };
        HandySchedulerUtil.runTaskTimer(handyRunnable, 20L * countdown, 20L * (long)time);
    }

    private static void createHd(boolean isHdTip, Location location, int time, String text, String name) {
        if (!MonsterPlus.USE_HD || !isHdTip) {
            return;
        }
        Location hdLocation = location.clone();
        hdLocation.setY(hdLocation.getY() + 2.0);
        HdUtil.delete(hdLocation);
        Date offset = DateUtil.offset(new Date(), 13, time);
        String dateStr = DateUtil.format(offset, "yyyy-MM-dd HH:mm:ss");
        ArrayList<String> textLineList = new ArrayList<String>();
        textLineList.add("&e======" + name + "\u4e0b\u6b21\u5237\u65b0\u65f6\u95f4======");
        textLineList.add(dateStr);
        if (StrUtil.isNotEmpty(text)) {
            textLineList.add(text);
        }
        HdUtil.create(textLineList, hdLocation, "DIAMOND_SWORD", 0);
    }
}

