/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.api;

import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.core.MonsterScoreboardTag;
import cn.handyplus.monster.lib.util.ItemMetaUtil;
import cn.handyplus.monster.lib.util.ItemStackUtil;
import java.util.Optional;
import java.util.Set;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MonsterPlusApi {
    private MonsterPlusApi() {
    }

    public static int getLevel(LivingEntity entity) {
        return MonsterScoreboardTag.getLevel(entity);
    }

    public static boolean isMonsterPlus(LivingEntity entity) {
        return MonsterScoreboardTag.isMonsterPlus(entity);
    }

    public static String getMonsterName(LivingEntity entity) {
        return MonsterScoreboardTag.getMonsterName(entity);
    }

    public static String getMonsterKey(LivingEntity entity) {
        return MonsterScoreboardTag.getMonsterKey(entity);
    }

    public static Set<String> getMonsterKeyList() {
        return MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.keySet();
    }

    public static boolean isMonsterPlusItem(ItemStack itemStack) {
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        Optional<String> itemOpt = ItemMetaUtil.getPersistentData(itemMeta, "MonsterPlus");
        return itemOpt.isPresent() && Boolean.TRUE.toString().equals(itemOpt.get());
    }
}

